/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.SweepingEdgeEnchantment;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class EnchantmentHelper {
    private static final String TAG_ENCH_ID = "id";
    private static final String TAG_ENCH_LEVEL = "lvl";

    public static CompoundTag storeEnchantment(@Nullable ResourceLocation pId, int pLevel) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putString(TAG_ENCH_ID, String.valueOf(pId));
        compoundtag.putShort(TAG_ENCH_LEVEL, (short)pLevel);
        return compoundtag;
    }

    public static void setEnchantmentLevel(CompoundTag pCompoundTag, int pLevel) {
        pCompoundTag.putShort(TAG_ENCH_LEVEL, (short)pLevel);
    }

    public static int getEnchantmentLevel(CompoundTag pCompoundTag) {
        return Mth.clamp(pCompoundTag.getInt(TAG_ENCH_LEVEL), 0, 255);
    }

    @Nullable
    public static ResourceLocation getEnchantmentId(CompoundTag pCompoundTag) {
        return ResourceLocation.tryParse(pCompoundTag.getString(TAG_ENCH_ID));
    }

    @Nullable
    public static ResourceLocation getEnchantmentId(Enchantment pCompoundTag) {
        return Registry.ENCHANTMENT.getKey(pCompoundTag);
    }

    public static int getItemEnchantmentLevel(Enchantment pEnchantment, ItemStack pStack) {
        if (pStack.isEmpty()) {
            return 0;
        }
        ResourceLocation resourcelocation = EnchantmentHelper.getEnchantmentId(pEnchantment);
        ListTag listtag = pStack.getEnchantmentTags();
        int i = 0;
        while (i < listtag.size()) {
            CompoundTag compoundtag = listtag.getCompound(i);
            ResourceLocation resourcelocation1 = EnchantmentHelper.getEnchantmentId(compoundtag);
            if (resourcelocation1 != null && resourcelocation1.equals(resourcelocation)) {
                return EnchantmentHelper.getEnchantmentLevel(compoundtag);
            }
            ++i;
        }
        return 0;
    }

    public static Map<Enchantment, Integer> getEnchantments(ItemStack pStack) {
        ListTag listtag = pStack.is(Items.ENCHANTED_BOOK) ? EnchantedBookItem.getEnchantments(pStack) : pStack.getEnchantmentTags();
        return EnchantmentHelper.deserializeEnchantments(listtag);
    }

    public static Map<Enchantment, Integer> deserializeEnchantments(ListTag pSerialized) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        int i = 0;
        while (i < pSerialized.size()) {
            CompoundTag compoundtag = pSerialized.getCompound(i);
            Registry.ENCHANTMENT.getOptional(EnchantmentHelper.getEnchantmentId(compoundtag)).ifPresent(p_44871_ -> map.put(p_44871_, EnchantmentHelper.getEnchantmentLevel(compoundtag)));
            ++i;
        }
        return map;
    }

    public static void setEnchantments(Map<Enchantment, Integer> pEnchantmentsMap, ItemStack pStack) {
        ListTag listtag = new ListTag();
        for (Map.Entry<Enchantment, Integer> entry : pEnchantmentsMap.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i = entry.getValue();
            listtag.add(EnchantmentHelper.storeEnchantment(EnchantmentHelper.getEnchantmentId(enchantment), i));
            if (!pStack.is(Items.ENCHANTED_BOOK)) continue;
            EnchantedBookItem.addEnchantment(pStack, new EnchantmentInstance(enchantment, i));
        }
        if (listtag.isEmpty()) {
            pStack.removeTagKey("Enchantments");
        } else if (!pStack.is(Items.ENCHANTED_BOOK)) {
            pStack.addTagElement("Enchantments", listtag);
        }
    }

    private static void runIterationOnItem(EnchantmentVisitor pVisitor, ItemStack pStack) {
        if (!pStack.isEmpty()) {
            ListTag listtag = pStack.getEnchantmentTags();
            int i = 0;
            while (i < listtag.size()) {
                CompoundTag compoundtag = listtag.getCompound(i);
                Registry.ENCHANTMENT.getOptional(EnchantmentHelper.getEnchantmentId(compoundtag)).ifPresent(p_182437_ -> pVisitor.accept((Enchantment)p_182437_, EnchantmentHelper.getEnchantmentLevel(compoundtag)));
                ++i;
            }
        }
    }

    private static void runIterationOnInventory(EnchantmentVisitor pVisitor, Iterable<ItemStack> pStacks) {
        for (ItemStack itemstack : pStacks) {
            EnchantmentHelper.runIterationOnItem(pVisitor, itemstack);
        }
    }

    public static int getDamageProtection(Iterable<ItemStack> pStacks, DamageSource pSource) {
        MutableInt mutableint = new MutableInt();
        EnchantmentHelper.runIterationOnInventory((p_44892_, p_44893_) -> mutableint.add(p_44892_.getDamageProtection(p_44893_, pSource)), pStacks);
        return mutableint.intValue();
    }

    public static float getDamageBonus(ItemStack pStack, MobType pCreatureAttribute) {
        MutableFloat mutablefloat = new MutableFloat();
        EnchantmentHelper.runIterationOnItem((p_44887_, p_44888_) -> mutablefloat.add(p_44887_.getDamageBonus(p_44888_, pCreatureAttribute)), pStack);
        return mutablefloat.floatValue();
    }

    public static float getSweepingDamageRatio(LivingEntity pEntity) {
        int i = EnchantmentHelper.getEnchantmentLevel(Enchantments.SWEEPING_EDGE, pEntity);
        return i > 0 ? SweepingEdgeEnchantment.getSweepingDamageRatio(i) : 0.0f;
    }

    public static void doPostHurtEffects(LivingEntity pUser, Entity pAttacker) {
        EnchantmentVisitor enchantmenthelper$enchantmentvisitor = (p_44902_, p_44903_) -> p_44902_.doPostHurt(pUser, pAttacker, p_44903_);
        if (pUser != null) {
            EnchantmentHelper.runIterationOnInventory(enchantmenthelper$enchantmentvisitor, pUser.getAllSlots());
        }
        if (pAttacker instanceof Player) {
            EnchantmentHelper.runIterationOnItem(enchantmenthelper$enchantmentvisitor, pUser.getMainHandItem());
        }
    }

    public static void doPostDamageEffects(LivingEntity pUser, Entity pTarget) {
        EnchantmentVisitor enchantmenthelper$enchantmentvisitor = (p_44829_, p_44830_) -> p_44829_.doPostAttack(pUser, pTarget, p_44830_);
        if (pUser != null) {
            EnchantmentHelper.runIterationOnInventory(enchantmenthelper$enchantmentvisitor, pUser.getAllSlots());
        }
        if (pUser instanceof Player) {
            EnchantmentHelper.runIterationOnItem(enchantmenthelper$enchantmentvisitor, pUser.getMainHandItem());
        }
    }

    public static int getEnchantmentLevel(Enchantment pEnchantment, LivingEntity pEntity) {
        Collection<ItemStack> iterable = pEnchantment.getSlotItems(pEntity).values();
        if (iterable == null) {
            return 0;
        }
        int i = 0;
        for (ItemStack itemstack : iterable) {
            int j = EnchantmentHelper.getItemEnchantmentLevel(pEnchantment, itemstack);
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public static int getKnockbackBonus(LivingEntity pPlayer) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.KNOCKBACK, pPlayer);
    }

    public static int getFireAspect(LivingEntity pPlayer) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.FIRE_ASPECT, pPlayer);
    }

    public static int getRespiration(LivingEntity pEntity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.RESPIRATION, pEntity);
    }

    public static int getDepthStrider(LivingEntity pEntity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.DEPTH_STRIDER, pEntity);
    }

    public static int getBlockEfficiency(LivingEntity pEntity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.BLOCK_EFFICIENCY, pEntity);
    }

    public static int getFishingLuckBonus(ItemStack pStack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.FISHING_LUCK, pStack);
    }

    public static int getFishingSpeedBonus(ItemStack pStack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.FISHING_SPEED, pStack);
    }

    public static int getMobLooting(LivingEntity pEntity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.MOB_LOOTING, pEntity);
    }

    public static boolean hasAquaAffinity(LivingEntity pEntity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.AQUA_AFFINITY, pEntity) > 0;
    }

    public static boolean hasFrostWalker(LivingEntity pPlayer) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.FROST_WALKER, pPlayer) > 0;
    }

    public static boolean hasSoulSpeed(LivingEntity pEntity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.SOUL_SPEED, pEntity) > 0;
    }

    public static boolean hasBindingCurse(ItemStack pStack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.BINDING_CURSE, pStack) > 0;
    }

    public static boolean hasVanishingCurse(ItemStack pStack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.VANISHING_CURSE, pStack) > 0;
    }

    public static int getLoyalty(ItemStack pStack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.LOYALTY, pStack);
    }

    public static int getRiptide(ItemStack pStack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.RIPTIDE, pStack);
    }

    public static boolean hasChanneling(ItemStack pStack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.CHANNELING, pStack) > 0;
    }

    @Nullable
    public static Map.Entry<EquipmentSlot, ItemStack> getRandomItemWith(Enchantment pTargetEnchantment, LivingEntity pEntity) {
        return EnchantmentHelper.getRandomItemWith(pTargetEnchantment, pEntity, p_44941_ -> true);
    }

    @Nullable
    public static Map.Entry<EquipmentSlot, ItemStack> getRandomItemWith(Enchantment pEnchantment, LivingEntity pLivingEntity, Predicate<ItemStack> pStackCondition) {
        Map<EquipmentSlot, ItemStack> map = pEnchantment.getSlotItems(pLivingEntity);
        if (map.isEmpty()) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<EquipmentSlot, ItemStack> entry : map.entrySet()) {
            ItemStack itemstack = entry.getValue();
            if (itemstack.isEmpty() || EnchantmentHelper.getItemEnchantmentLevel(pEnchantment, itemstack) <= 0 || !pStackCondition.test(itemstack)) continue;
            list.add(entry);
        }
        return list.isEmpty() ? null : (Map.Entry)list.get(pLivingEntity.getRandom().nextInt(list.size()));
    }

    public static int getEnchantmentCost(Random pRand, int pEnchantNum, int pPower, ItemStack pStack) {
        Item item = pStack.getItem();
        int i = item.getEnchantmentValue();
        if (i <= 0) {
            return 0;
        }
        if (pPower > 15) {
            pPower = 15;
        }
        int j = pRand.nextInt(8) + 1 + (pPower >> 1) + pRand.nextInt(pPower + 1);
        if (pEnchantNum == 0) {
            return Math.max(j / 3, 1);
        }
        return pEnchantNum == 1 ? j * 2 / 3 + 1 : Math.max(j, pPower * 2);
    }

    public static ItemStack enchantItem(Random pRandom, ItemStack pStack, int pLevel, boolean pAllowTreasure) {
        List<EnchantmentInstance> list = EnchantmentHelper.selectEnchantment(pRandom, pStack, pLevel, pAllowTreasure);
        boolean flag = pStack.is(Items.BOOK);
        if (flag) {
            pStack = new ItemStack(Items.ENCHANTED_BOOK);
        }
        for (EnchantmentInstance enchantmentinstance : list) {
            if (flag) {
                EnchantedBookItem.addEnchantment(pStack, enchantmentinstance);
                continue;
            }
            pStack.enchant(enchantmentinstance.enchantment, enchantmentinstance.level);
        }
        return pStack;
    }

    public static List<EnchantmentInstance> selectEnchantment(Random pRandom, ItemStack pItemStack, int pLevel, boolean pAllowTreasure) {
        ArrayList list = Lists.newArrayList();
        Item item = pItemStack.getItem();
        int i = item.getEnchantmentValue();
        if (i <= 0) {
            return list;
        }
        pLevel += 1 + pRandom.nextInt(i / 4 + 1) + pRandom.nextInt(i / 4 + 1);
        float f = (pRandom.nextFloat() + pRandom.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentInstance> list1 = EnchantmentHelper.getAvailableEnchantmentResults(pLevel = Mth.clamp(Math.round((float)pLevel + (float)pLevel * f), 1, Integer.MAX_VALUE), pItemStack, pAllowTreasure);
        if (!list1.isEmpty()) {
            WeightedRandom.getRandomItem(pRandom, list1).ifPresent(list::add);
            while (pRandom.nextInt(50) <= pLevel) {
                if (!list.isEmpty()) {
                    EnchantmentHelper.filterCompatibleEnchantments(list1, (EnchantmentInstance)Util.lastOf(list));
                }
                if (list1.isEmpty()) break;
                WeightedRandom.getRandomItem(pRandom, list1).ifPresent(list::add);
                pLevel /= 2;
            }
        }
        return list;
    }

    public static void filterCompatibleEnchantments(List<EnchantmentInstance> pDataList, EnchantmentInstance pData) {
        Iterator<EnchantmentInstance> iterator = pDataList.iterator();
        while (iterator.hasNext()) {
            if (pData.enchantment.isCompatibleWith(iterator.next().enchantment)) continue;
            iterator.remove();
        }
    }

    public static boolean isEnchantmentCompatible(Collection<Enchantment> pEnchantments, Enchantment pEnchantment) {
        for (Enchantment enchantment : pEnchantments) {
            if (enchantment.isCompatibleWith(pEnchantment)) continue;
            return false;
        }
        return true;
    }

    public static List<EnchantmentInstance> getAvailableEnchantmentResults(int pLevel, ItemStack pStack, boolean pAllowTreasure) {
        ArrayList list = Lists.newArrayList();
        Item item = pStack.getItem();
        boolean flag = pStack.is(Items.BOOK);
        block0: for (Enchantment enchantment : Registry.ENCHANTMENT) {
            if (enchantment.isTreasureOnly() && !pAllowTreasure || !enchantment.isDiscoverable() || !enchantment.category.canEnchant(item) && !flag) continue;
            int i = enchantment.getMaxLevel();
            while (i > enchantment.getMinLevel() - 1) {
                if (pLevel >= enchantment.getMinCost(i) && pLevel <= enchantment.getMaxCost(i)) {
                    list.add(new EnchantmentInstance(enchantment, i));
                    continue block0;
                }
                --i;
            }
        }
        return list;
    }

    @FunctionalInterface
    static interface EnchantmentVisitor {
        public void accept(Enchantment var1, int var2);
    }
}

