/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class ProtectionEnchantment
extends Enchantment {
    public final Type type;

    public ProtectionEnchantment(Enchantment.Rarity pRarity, Type pType, EquipmentSlot ... pApplicableSlots) {
        super(pRarity, pType == Type.FALL ? EnchantmentCategory.ARMOR_FEET : EnchantmentCategory.ARMOR, pApplicableSlots);
        this.type = pType;
    }

    @Override
    public int getMinCost(int pEnchantmentLevel) {
        return this.type.getMinCost() + (pEnchantmentLevel - 1) * this.type.getLevelCost();
    }

    @Override
    public int getMaxCost(int pEnchantmentLevel) {
        return this.getMinCost(pEnchantmentLevel) + this.type.getLevelCost();
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public int getDamageProtection(int pLevel, DamageSource pSource) {
        if (pSource.isBypassInvul()) {
            return 0;
        }
        if (this.type == Type.ALL) {
            return pLevel;
        }
        if (this.type == Type.FIRE && pSource.isFire()) {
            return pLevel * 2;
        }
        if (this.type == Type.FALL && pSource.isFall()) {
            return pLevel * 3;
        }
        if (this.type == Type.EXPLOSION && pSource.isExplosion()) {
            return pLevel * 2;
        }
        return this.type == Type.PROJECTILE && pSource.isProjectile() ? pLevel * 2 : 0;
    }

    @Override
    public boolean checkCompatibility(Enchantment pEnch) {
        if (pEnch instanceof ProtectionEnchantment) {
            ProtectionEnchantment protectionenchantment = (ProtectionEnchantment)pEnch;
            if (this.type == protectionenchantment.type) {
                return false;
            }
            return this.type == Type.FALL || protectionenchantment.type == Type.FALL;
        }
        return super.checkCompatibility(pEnch);
    }

    public static int getFireAfterDampener(LivingEntity pLivingEntity, int pLevel) {
        int i = EnchantmentHelper.getEnchantmentLevel(Enchantments.FIRE_PROTECTION, pLivingEntity);
        if (i > 0) {
            pLevel -= Mth.floor((float)pLevel * (float)i * 0.15f);
        }
        return pLevel;
    }

    public static double getExplosionKnockbackAfterDampener(LivingEntity pLivingEntity, double pDamage) {
        int i = EnchantmentHelper.getEnchantmentLevel(Enchantments.BLAST_PROTECTION, pLivingEntity);
        if (i > 0) {
            pDamage -= (double)Mth.floor(pDamage * (double)((float)i * 0.15f));
        }
        return pDamage;
    }

    public static enum Type {
        ALL(1, 11),
        FIRE(10, 8),
        FALL(5, 6),
        EXPLOSION(5, 8),
        PROJECTILE(3, 6);

        private final int minCost;
        private final int levelCost;

        private Type(int p_151299_, int p_151300_) {
            this.minCost = p_151299_;
            this.levelCost = p_151300_;
        }

        public int getMinCost() {
            return this.minCost;
        }

        public int getLevelCost() {
            return this.levelCost;
        }
    }
}

