/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import java.util.Map;
import java.util.Random;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class ThornsEnchantment
extends Enchantment {
    private static final float CHANCE_PER_LEVEL = 0.15f;

    public ThornsEnchantment(Enchantment.Rarity pRarity, EquipmentSlot ... pApplicableSlots) {
        super(pRarity, EnchantmentCategory.ARMOR_CHEST, pApplicableSlots);
    }

    @Override
    public int getMinCost(int pEnchantmentLevel) {
        return 10 + 20 * (pEnchantmentLevel - 1);
    }

    @Override
    public int getMaxCost(int pEnchantmentLevel) {
        return super.getMinCost(pEnchantmentLevel) + 50;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public boolean canEnchant(ItemStack pStack) {
        return pStack.getItem() instanceof ArmorItem ? true : super.canEnchant(pStack);
    }

    @Override
    public void doPostHurt(LivingEntity pUser, Entity pAttacker, int pLevel) {
        Random random = pUser.getRandom();
        Map.Entry<EquipmentSlot, ItemStack> entry = EnchantmentHelper.getRandomItemWith(Enchantments.THORNS, pUser);
        if (ThornsEnchantment.shouldHit(pLevel, random)) {
            if (pAttacker != null) {
                pAttacker.hurt(DamageSource.thorns(pUser), ThornsEnchantment.getDamage(pLevel, random));
            }
            if (entry != null) {
                entry.getValue().hurtAndBreak(2, pUser, p_45208_ -> p_45208_.broadcastBreakEvent((EquipmentSlot)((Object)((Object)entry.getKey()))));
            }
        }
    }

    public static boolean shouldHit(int pLevel, Random pRnd) {
        if (pLevel <= 0) {
            return false;
        }
        return pRnd.nextFloat() < 0.15f * (float)pLevel;
    }

    public static int getDamage(int pLevel, Random pRnd) {
        return pLevel > 10 ? pLevel - 10 : 1 + pRnd.nextInt(4);
    }
}

