/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.brigadier.ResultConsumer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class BaseCommandBlock
implements CommandSource {
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final Component DEFAULT_NAME = new TextComponent("@");
    private long lastExecution = -1L;
    private boolean updateLastExecution = true;
    private int successCount;
    private boolean trackOutput = true;
    @Nullable
    private Component lastOutput;
    private String command = "";
    private Component name = DEFAULT_NAME;

    public int getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(int pSuccessCount) {
        this.successCount = pSuccessCount;
    }

    public Component getLastOutput() {
        return this.lastOutput == null ? TextComponent.EMPTY : this.lastOutput;
    }

    public CompoundTag save(CompoundTag pCompound) {
        pCompound.putString("Command", this.command);
        pCompound.putInt("SuccessCount", this.successCount);
        pCompound.putString("CustomName", Component.Serializer.toJson(this.name));
        pCompound.putBoolean("TrackOutput", this.trackOutput);
        if (this.lastOutput != null && this.trackOutput) {
            pCompound.putString("LastOutput", Component.Serializer.toJson(this.lastOutput));
        }
        pCompound.putBoolean("UpdateLastExecution", this.updateLastExecution);
        if (this.updateLastExecution && this.lastExecution > 0L) {
            pCompound.putLong("LastExecution", this.lastExecution);
        }
        return pCompound;
    }

    public void load(CompoundTag pNbt) {
        this.command = pNbt.getString("Command");
        this.successCount = pNbt.getInt("SuccessCount");
        if (pNbt.contains("CustomName", 8)) {
            this.setName(Component.Serializer.fromJson(pNbt.getString("CustomName")));
        }
        if (pNbt.contains("TrackOutput", 1)) {
            this.trackOutput = pNbt.getBoolean("TrackOutput");
        }
        if (pNbt.contains("LastOutput", 8) && this.trackOutput) {
            try {
                this.lastOutput = Component.Serializer.fromJson(pNbt.getString("LastOutput"));
            }
            catch (Throwable throwable) {
                this.lastOutput = new TextComponent(throwable.getMessage());
            }
        } else {
            this.lastOutput = null;
        }
        if (pNbt.contains("UpdateLastExecution")) {
            this.updateLastExecution = pNbt.getBoolean("UpdateLastExecution");
        }
        this.lastExecution = this.updateLastExecution && pNbt.contains("LastExecution") ? pNbt.getLong("LastExecution") : -1L;
    }

    public void setCommand(String pCommand) {
        this.command = pCommand;
        this.successCount = 0;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean performCommand(Level pLevel) {
        if (!pLevel.isClientSide && pLevel.getGameTime() != this.lastExecution) {
            if ("Searge".equalsIgnoreCase(this.command)) {
                this.lastOutput = new TextComponent("#itzlipofutzli");
                this.successCount = 1;
                return true;
            }
            this.successCount = 0;
            MinecraftServer minecraftserver = this.getLevel().getServer();
            if (minecraftserver.isCommandBlockEnabled() && !StringUtil.isNullOrEmpty(this.command)) {
                try {
                    this.lastOutput = null;
                    CommandSourceStack commandsourcestack = this.createCommandSourceStack().withCallback((ResultConsumer<CommandSourceStack>)((ResultConsumer)(p_45417_, p_45418_, p_45419_) -> {
                        if (p_45418_) {
                            ++this.successCount;
                        }
                    }));
                    minecraftserver.getCommands().performCommand(commandsourcestack, this.command);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.forThrowable(throwable, "Executing command block");
                    CrashReportCategory crashreportcategory = crashreport.addCategory("Command to be executed");
                    crashreportcategory.setDetail("Command", this::getCommand);
                    crashreportcategory.setDetail("Name", () -> this.getName().getString());
                    throw new ReportedException(crashreport);
                }
            }
            this.lastExecution = this.updateLastExecution ? pLevel.getGameTime() : -1L;
            return true;
        }
        return false;
    }

    public Component getName() {
        return this.name;
    }

    public void setName(@Nullable Component pName) {
        this.name = pName != null ? pName : DEFAULT_NAME;
    }

    @Override
    public void sendMessage(Component pComponent, UUID pSenderUUID) {
        if (this.trackOutput) {
            this.lastOutput = new TextComponent("[" + TIME_FORMAT.format(new Date()) + "] ").append(pComponent);
            this.onUpdated();
        }
    }

    public abstract ServerLevel getLevel();

    public abstract void onUpdated();

    public void setLastOutput(@Nullable Component pLastOutputMessage) {
        this.lastOutput = pLastOutputMessage;
    }

    public void setTrackOutput(boolean pShouldTrackOutput) {
        this.trackOutput = pShouldTrackOutput;
    }

    public boolean isTrackOutput() {
        return this.trackOutput;
    }

    public InteractionResult usedBy(Player pPlayer) {
        if (!pPlayer.canUseGameMasterBlocks()) {
            return InteractionResult.PASS;
        }
        if (pPlayer.getCommandSenderWorld().isClientSide) {
            pPlayer.openMinecartCommandBlock(this);
        }
        return InteractionResult.sidedSuccess(pPlayer.level.isClientSide);
    }

    public abstract Vec3 getPosition();

    public abstract CommandSourceStack createCommandSourceStack();

    @Override
    public boolean acceptsSuccess() {
        return this.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK) && this.trackOutput;
    }

    @Override
    public boolean acceptsFailure() {
        return this.trackOutput;
    }

    @Override
    public boolean shouldInformAdmins() {
        return this.getLevel().getGameRules().getBoolean(GameRules.RULE_COMMANDBLOCKOUTPUT);
    }
}

