/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public abstract class BaseSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int EVENT_SPAWN = 1;
    private int spawnDelay = 20;
    private SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.empty();
    private SpawnData nextSpawnData = new SpawnData();
    private double spin;
    private double oSpin;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    @Nullable
    private Entity displayEntity;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;
    private final Random random = new Random();

    public void setEntityId(EntityType<?> pType) {
        this.nextSpawnData.getEntityToSpawn().putString("id", Registry.ENTITY_TYPE.getKey(pType).toString());
    }

    private boolean isNearPlayer(Level pLevel, BlockPos pPos) {
        return pLevel.hasNearbyAlivePlayer((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, this.requiredPlayerRange);
    }

    public void clientTick(Level pLevel, BlockPos pPos) {
        if (!this.isNearPlayer(pLevel, pPos)) {
            this.oSpin = this.spin;
        } else {
            double d0 = (double)pPos.getX() + pLevel.random.nextDouble();
            double d1 = (double)pPos.getY() + pLevel.random.nextDouble();
            double d2 = (double)pPos.getZ() + pLevel.random.nextDouble();
            pLevel.addParticle(ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            pLevel.addParticle(ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(ServerLevel pServerLevel, BlockPos pPos) {
        block12: {
            block13: {
                if (!this.isNearPlayer(pServerLevel, pPos)) break block12;
                if (this.spawnDelay == -1) {
                    this.delay(pServerLevel, pPos);
                }
                if (this.spawnDelay <= 0) break block13;
                --this.spawnDelay;
                break block12;
            }
            boolean flag = false;
            int i = 0;
            while (i < this.spawnCount) {
                block14: {
                    Entity entity;
                    block15: {
                        SpawnData.CustomSpawnRules spawndata$customspawnrules;
                        double d2;
                        CompoundTag compoundtag = this.nextSpawnData.getEntityToSpawn();
                        Optional<EntityType<?>> optional = EntityType.by(compoundtag);
                        if (optional.isEmpty()) {
                            this.delay(pServerLevel, pPos);
                            return;
                        }
                        ListTag listtag = compoundtag.getList("Pos", 6);
                        int j = listtag.size();
                        double d0 = j >= 1 ? listtag.getDouble(0) : (double)pPos.getX() + (pServerLevel.random.nextDouble() - pServerLevel.random.nextDouble()) * (double)this.spawnRange + 0.5;
                        double d1 = j >= 2 ? listtag.getDouble(1) : (double)(pPos.getY() + pServerLevel.random.nextInt(3) - 1);
                        double d = d2 = j >= 3 ? listtag.getDouble(2) : (double)pPos.getZ() + (pServerLevel.random.nextDouble() - pServerLevel.random.nextDouble()) * (double)this.spawnRange + 0.5;
                        if (!pServerLevel.noCollision(optional.get().getAABB(d0, d1, d2))) break block14;
                        BlockPos blockpos = new BlockPos(d0, d1, d2);
                        if (!this.nextSpawnData.getCustomSpawnRules().isPresent() ? !SpawnPlacements.checkSpawnRules(optional.get(), pServerLevel, MobSpawnType.SPAWNER, blockpos, pServerLevel.getRandom()) : !optional.get().getCategory().isFriendly() && pServerLevel.getDifficulty() == Difficulty.PEACEFUL || !(spawndata$customspawnrules = this.nextSpawnData.getCustomSpawnRules().get()).blockLightLimit().isValueInRange(pServerLevel.getBrightness(LightLayer.BLOCK, blockpos)) || !spawndata$customspawnrules.skyLightLimit().isValueInRange(pServerLevel.getBrightness(LightLayer.SKY, blockpos))) break block14;
                        entity = EntityType.loadEntityRecursive(compoundtag, pServerLevel, p_151310_ -> {
                            p_151310_.moveTo(d0, d1, d2, p_151310_.getYRot(), p_151310_.getXRot());
                            return p_151310_;
                        });
                        if (entity == null) {
                            this.delay(pServerLevel, pPos);
                            return;
                        }
                        int k = pServerLevel.getEntitiesOfClass(entity.getClass(), new AABB(pPos.getX(), pPos.getY(), pPos.getZ(), pPos.getX() + 1, pPos.getY() + 1, pPos.getZ() + 1).inflate(this.spawnRange)).size();
                        if (k >= this.maxNearbyEntities) {
                            this.delay(pServerLevel, pPos);
                            return;
                        }
                        entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), pServerLevel.random.nextFloat() * 360.0f, 0.0f);
                        if (!(entity instanceof Mob)) break block15;
                        Mob mob = (Mob)entity;
                        if (this.nextSpawnData.getCustomSpawnRules().isEmpty() && !mob.checkSpawnRules(pServerLevel, MobSpawnType.SPAWNER) || !mob.checkSpawnObstruction(pServerLevel)) break block14;
                        if (this.nextSpawnData.getEntityToSpawn().size() == 1 && this.nextSpawnData.getEntityToSpawn().contains("id", 8)) {
                            ((Mob)entity).finalizeSpawn(pServerLevel, pServerLevel.getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.SPAWNER, null, null);
                        }
                    }
                    if (!pServerLevel.tryAddFreshEntityWithPassengers(entity)) {
                        this.delay(pServerLevel, pPos);
                        return;
                    }
                    pServerLevel.levelEvent(2004, pPos, 0);
                    if (entity instanceof Mob) {
                        ((Mob)entity).spawnAnim();
                    }
                    flag = true;
                }
                ++i;
            }
            if (flag) {
                this.delay(pServerLevel, pPos);
            }
        }
    }

    private void delay(Level pLevel, BlockPos pPos) {
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + this.random.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom(this.random).ifPresent(p_186386_ -> this.setNextSpawnData(pLevel, pPos, (SpawnData)p_186386_.getData()));
        this.broadcastEvent(pLevel, pPos, 1);
    }

    public void load(@Nullable Level pLevel, BlockPos pPos, CompoundTag pTag) {
        this.spawnDelay = pTag.getShort("Delay");
        boolean flag = pTag.contains("SpawnPotentials", 9);
        boolean flag1 = pTag.contains("SpawnData", 10);
        if (!flag) {
            SpawnData spawndata = flag1 ? SpawnData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pTag.getCompound("SpawnData")).resultOrPartial(p_186391_ -> LOGGER.warn("Invalid SpawnData: {}", p_186391_)).orElseGet(SpawnData::new) : new SpawnData();
            this.spawnPotentials = SimpleWeightedRandomList.single(spawndata);
            this.setNextSpawnData(pLevel, pPos, spawndata);
        } else {
            ListTag listtag = pTag.getList("SpawnPotentials", 10);
            this.spawnPotentials = SpawnData.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)listtag).resultOrPartial(p_186388_ -> LOGGER.warn("Invalid SpawnPotentials list: {}", p_186388_)).orElseGet(SimpleWeightedRandomList::empty);
            if (flag1) {
                SpawnData spawndata1 = SpawnData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pTag.getCompound("SpawnData")).resultOrPartial(p_186380_ -> LOGGER.warn("Invalid SpawnData: {}", p_186380_)).orElseGet(SpawnData::new);
                this.setNextSpawnData(pLevel, pPos, spawndata1);
            } else {
                this.spawnPotentials.getRandom(this.random).ifPresent(p_186378_ -> this.setNextSpawnData(pLevel, pPos, (SpawnData)p_186378_.getData()));
            }
        }
        if (pTag.contains("MinSpawnDelay", 99)) {
            this.minSpawnDelay = pTag.getShort("MinSpawnDelay");
            this.maxSpawnDelay = pTag.getShort("MaxSpawnDelay");
            this.spawnCount = pTag.getShort("SpawnCount");
        }
        if (pTag.contains("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = pTag.getShort("MaxNearbyEntities");
            this.requiredPlayerRange = pTag.getShort("RequiredPlayerRange");
        }
        if (pTag.contains("SpawnRange", 99)) {
            this.spawnRange = pTag.getShort("SpawnRange");
        }
        this.displayEntity = null;
    }

    public CompoundTag save(CompoundTag p_186382_) {
        p_186382_.putShort("Delay", (short)this.spawnDelay);
        p_186382_.putShort("MinSpawnDelay", (short)this.minSpawnDelay);
        p_186382_.putShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        p_186382_.putShort("SpawnCount", (short)this.spawnCount);
        p_186382_.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        p_186382_.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        p_186382_.putShort("SpawnRange", (short)this.spawnRange);
        p_186382_.put("SpawnData", (Tag)SpawnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.nextSpawnData).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        p_186382_.put("SpawnPotentials", (Tag)SpawnData.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.spawnPotentials).result().orElseThrow());
        return p_186382_;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level pLevel) {
        if (this.displayEntity == null) {
            this.displayEntity = EntityType.loadEntityRecursive(this.nextSpawnData.getEntityToSpawn(), pLevel, Function.identity());
            if (this.nextSpawnData.getEntityToSpawn().size() == 1 && this.nextSpawnData.getEntityToSpawn().contains("id", 8)) {
                boolean cfr_ignored_0 = this.displayEntity instanceof Mob;
            }
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(Level p_151317_, int p_151318_) {
        if (p_151318_ == 1) {
            if (p_151317_.isClientSide) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    public void setNextSpawnData(@Nullable Level pLevel, BlockPos pPos, SpawnData pNextSpawnData) {
        this.nextSpawnData = pNextSpawnData;
    }

    public abstract void broadcastEvent(Level var1, BlockPos var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }
}

