/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface BlockGetter
extends LevelHeightAccessor {
    @Nullable
    public BlockEntity getBlockEntity(BlockPos var1);

    default public <T extends BlockEntity> Optional<T> getBlockEntity(BlockPos pPos, BlockEntityType<T> pBlockEntityType) {
        BlockEntity blockentity = this.getBlockEntity(pPos);
        return blockentity != null && blockentity.getType() == pBlockEntityType ? Optional.of(blockentity) : Optional.empty();
    }

    public BlockState getBlockState(BlockPos var1);

    public FluidState getFluidState(BlockPos var1);

    default public int getLightEmission(BlockPos pPos) {
        return this.getBlockState(pPos).getLightEmission();
    }

    default public int getMaxLightLevel() {
        return 15;
    }

    default public Stream<BlockState> getBlockStates(AABB pArea) {
        return BlockPos.betweenClosedStream(pArea).map(this::getBlockState);
    }

    default public BlockHitResult isBlockInLine(ClipBlockStateContext pContext) {
        return BlockGetter.traverseBlocks(pContext.getFrom(), pContext.getTo(), pContext, (p_151356_, p_151357_) -> {
            BlockState blockstate = this.getBlockState((BlockPos)p_151357_);
            Vec3 vec3 = p_151356_.getFrom().subtract(p_151356_.getTo());
            return p_151356_.isTargetBlock().test(blockstate) ? new BlockHitResult(p_151356_.getTo(), Direction.getNearest(vec3.x, vec3.y, vec3.z), new BlockPos(p_151356_.getTo()), false) : null;
        }, p_151370_ -> {
            Vec3 vec3 = p_151370_.getFrom().subtract(p_151370_.getTo());
            return BlockHitResult.miss(p_151370_.getTo(), Direction.getNearest(vec3.x, vec3.y, vec3.z), new BlockPos(p_151370_.getTo()));
        });
    }

    default public BlockHitResult clip(ClipContext pContext) {
        return BlockGetter.traverseBlocks(pContext.getFrom(), pContext.getTo(), pContext, (p_151359_, p_151360_) -> {
            BlockState blockstate = this.getBlockState((BlockPos)p_151360_);
            FluidState fluidstate = this.getFluidState((BlockPos)p_151360_);
            Vec3 vec3 = p_151359_.getFrom();
            Vec3 vec31 = p_151359_.getTo();
            VoxelShape voxelshape = p_151359_.getBlockShape(blockstate, this, (BlockPos)p_151360_);
            BlockHitResult blockhitresult = this.clipWithInteractionOverride(vec3, vec31, (BlockPos)p_151360_, voxelshape, blockstate);
            VoxelShape voxelshape1 = p_151359_.getFluidShape(fluidstate, this, (BlockPos)p_151360_);
            BlockHitResult blockhitresult1 = voxelshape1.clip(vec3, vec31, (BlockPos)p_151360_);
            double d0 = blockhitresult == null ? Double.MAX_VALUE : p_151359_.getFrom().distanceToSqr(blockhitresult.getLocation());
            double d1 = blockhitresult1 == null ? Double.MAX_VALUE : p_151359_.getFrom().distanceToSqr(blockhitresult1.getLocation());
            return d0 <= d1 ? blockhitresult : blockhitresult1;
        }, p_151372_ -> {
            Vec3 vec3 = p_151372_.getFrom().subtract(p_151372_.getTo());
            return BlockHitResult.miss(p_151372_.getTo(), Direction.getNearest(vec3.x, vec3.y, vec3.z), new BlockPos(p_151372_.getTo()));
        });
    }

    @Nullable
    default public BlockHitResult clipWithInteractionOverride(Vec3 pStartVec, Vec3 pEndVec, BlockPos pPos, VoxelShape pShape, BlockState pState) {
        BlockHitResult blockhitresult1;
        BlockHitResult blockhitresult = pShape.clip(pStartVec, pEndVec, pPos);
        if (blockhitresult != null && (blockhitresult1 = pState.getInteractionShape(this, pPos).clip(pStartVec, pEndVec, pPos)) != null && blockhitresult1.getLocation().subtract(pStartVec).lengthSqr() < blockhitresult.getLocation().subtract(pStartVec).lengthSqr()) {
            return blockhitresult.withDirection(blockhitresult1.getDirection());
        }
        return blockhitresult;
    }

    default public double getBlockFloorHeight(VoxelShape pShape, Supplier<VoxelShape> pBelowShapeSupplier) {
        if (!pShape.isEmpty()) {
            return pShape.max(Direction.Axis.Y);
        }
        double d0 = pBelowShapeSupplier.get().max(Direction.Axis.Y);
        return d0 >= 1.0 ? d0 - 1.0 : Double.NEGATIVE_INFINITY;
    }

    default public double getBlockFloorHeight(BlockPos pPos) {
        return this.getBlockFloorHeight(this.getBlockState(pPos).getCollisionShape(this, pPos), () -> {
            BlockPos blockpos = pPos.below();
            return this.getBlockState(blockpos).getCollisionShape(this, blockpos);
        });
    }

    public static <T, C> T traverseBlocks(Vec3 pFrom, Vec3 pTo, C pContext, BiFunction<C, BlockPos, T> pTester, Function<C, T> pOnFail) {
        int k;
        int j;
        if (pFrom.equals(pTo)) {
            return pOnFail.apply(pContext);
        }
        double d0 = Mth.lerp(-1.0E-7, pTo.x, pFrom.x);
        double d1 = Mth.lerp(-1.0E-7, pTo.y, pFrom.y);
        double d2 = Mth.lerp(-1.0E-7, pTo.z, pFrom.z);
        double d3 = Mth.lerp(-1.0E-7, pFrom.x, pTo.x);
        double d4 = Mth.lerp(-1.0E-7, pFrom.y, pTo.y);
        double d5 = Mth.lerp(-1.0E-7, pFrom.z, pTo.z);
        int i = Mth.floor(d3);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(i, j = Mth.floor(d4), k = Mth.floor(d5));
        T t = pTester.apply(pContext, blockpos$mutableblockpos);
        if (t != null) {
            return t;
        }
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        int l = Mth.sign(d6);
        int i1 = Mth.sign(d7);
        int j1 = Mth.sign(d8);
        double d9 = l == 0 ? Double.MAX_VALUE : (double)l / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l > 0 ? 1.0 - Mth.frac(d3) : Mth.frac(d3));
        double d13 = d10 * (i1 > 0 ? 1.0 - Mth.frac(d4) : Mth.frac(d4));
        double d14 = d11 * (j1 > 0 ? 1.0 - Mth.frac(d5) : Mth.frac(d5));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            if (d12 < d13) {
                if (d12 < d14) {
                    i += l;
                    d12 += d9;
                } else {
                    k += j1;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                j += i1;
                d13 += d10;
            } else {
                k += j1;
                d14 += d11;
            }
            T t1 = pTester.apply(pContext, blockpos$mutableblockpos.set(i, j, k));
            if (t1 == null) continue;
            return t1;
        }
        return pOnFail.apply(pContext);
    }
}

