/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;

public class ChunkPos {
    private static final int SAFETY_MARGIN = 1056;
    public static final long INVALID_CHUNK_POS = ChunkPos.asLong(1875066, 1875066);
    public static final ChunkPos ZERO = new ChunkPos(0, 0);
    private static final long COORD_BITS = 32L;
    private static final long COORD_MASK = 0xFFFFFFFFL;
    private static final int REGION_BITS = 5;
    private static final int REGION_MASK = 31;
    public final int x;
    public final int z;
    private static final int HASH_A = 1664525;
    private static final int HASH_C = 1013904223;
    private static final int HASH_Z_XOR = -559038737;
    private int cachedHashCode = 0;

    public ChunkPos(int pX, int pY) {
        this.x = pX;
        this.z = pY;
    }

    public ChunkPos(BlockPos pPos) {
        this.x = SectionPos.blockToSectionCoord(pPos.getX());
        this.z = SectionPos.blockToSectionCoord(pPos.getZ());
    }

    public ChunkPos(long pPos) {
        this.x = (int)pPos;
        this.z = (int)(pPos >> 32);
    }

    public long toLong() {
        return ChunkPos.asLong(this.x, this.z);
    }

    public static long asLong(int pX, int pZ) {
        return (long)pX & 0xFFFFFFFFL | ((long)pZ & 0xFFFFFFFFL) << 32;
    }

    public static long asLong(BlockPos pPos) {
        return ChunkPos.asLong(SectionPos.blockToSectionCoord(pPos.getX()), SectionPos.blockToSectionCoord(pPos.getZ()));
    }

    public static int getX(long pChunkAsLong) {
        return (int)(pChunkAsLong & 0xFFFFFFFFL);
    }

    public static int getZ(long pChunkAsLong) {
        return (int)(pChunkAsLong >>> 32 & 0xFFFFFFFFL);
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        int i = 1664525 * this.x + 1013904223;
        int j = 1664525 * (this.z ^ 0xDEADBEEF) + 1013904223;
        this.cachedHashCode = i ^ j;
        return this.cachedHashCode;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (!(pOther instanceof ChunkPos)) {
            return false;
        }
        ChunkPos chunkpos = (ChunkPos)pOther;
        return this.x == chunkpos.x && this.z == chunkpos.z;
    }

    public int getMiddleBlockX() {
        return this.getBlockX(8);
    }

    public int getMiddleBlockZ() {
        return this.getBlockZ(8);
    }

    public int getMinBlockX() {
        return SectionPos.sectionToBlockCoord(this.x);
    }

    public int getMinBlockZ() {
        return SectionPos.sectionToBlockCoord(this.z);
    }

    public int getMaxBlockX() {
        return this.getBlockX(15);
    }

    public int getMaxBlockZ() {
        return this.getBlockZ(15);
    }

    public int getRegionX() {
        return this.x >> 5;
    }

    public int getRegionZ() {
        return this.z >> 5;
    }

    public int getRegionLocalX() {
        return this.x & 0x1F;
    }

    public int getRegionLocalZ() {
        return this.z & 0x1F;
    }

    public BlockPos getBlockAt(int pXSection, int pY, int pZSection) {
        return new BlockPos(this.getBlockX(pXSection), pY, this.getBlockZ(pZSection));
    }

    public int getBlockX(int pX) {
        return SectionPos.sectionToBlockCoord(this.x, pX);
    }

    public int getBlockZ(int pZ) {
        return SectionPos.sectionToBlockCoord(this.z, pZ);
    }

    public BlockPos getMiddleBlockPosition(int pY) {
        return new BlockPos(this.getMiddleBlockX(), pY, this.getMiddleBlockZ());
    }

    public String toString() {
        return "[" + this.x + ", " + this.z + "]";
    }

    public BlockPos getWorldPosition() {
        return new BlockPos(this.getMinBlockX(), 0, this.getMinBlockZ());
    }

    public int getChessboardDistance(ChunkPos pChunkPos) {
        return Math.max(Math.abs(this.x - pChunkPos.x), Math.abs(this.z - pChunkPos.z));
    }

    public static Stream<ChunkPos> rangeClosed(ChunkPos pCenter, int pRadius) {
        return ChunkPos.rangeClosed(new ChunkPos(pCenter.x - pRadius, pCenter.z - pRadius), new ChunkPos(pCenter.x + pRadius, pCenter.z + pRadius));
    }

    public static Stream<ChunkPos> rangeClosed(ChunkPos pCenter, ChunkPos pRadius) {
        int i = Math.abs(pCenter.x - pRadius.x) + 1;
        int j = Math.abs(pCenter.z - pRadius.z) + 1;
        int k = pCenter.x < pRadius.x ? 1 : -1;
        int l = pCenter.z < pRadius.z ? 1 : -1;
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<ChunkPos>((long)(i * j), 64){
            @Nullable
            private ChunkPos pos;

            @Override
            public boolean tryAdvance(Consumer<? super ChunkPos> p_45630_) {
                if (this.pos == null) {
                    this.pos = pCenter;
                } else {
                    int i1 = this.pos.x;
                    int j1 = this.pos.z;
                    if (i1 == pRadius.x) {
                        if (j1 == pRadius.z) {
                            return false;
                        }
                        this.pos = new ChunkPos(pCenter.x, j1 + l);
                    } else {
                        this.pos = new ChunkPos(i1 + k, j1);
                    }
                }
                p_45630_.accept(this.pos);
                return true;
            }
        }, false);
    }
}

