/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface EntityGetter {
    public List<Entity> getEntities(@Nullable Entity var1, AABB var2, Predicate<? super Entity> var3);

    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> var1, AABB var2, Predicate<? super T> var3);

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> pClazz, AABB pArea, Predicate<? super T> pFilter) {
        return this.getEntities(EntityTypeTest.forClass(pClazz), pArea, pFilter);
    }

    public List<? extends Player> players();

    default public List<Entity> getEntities(@Nullable Entity pEntity, AABB pArea) {
        return this.getEntities(pEntity, pArea, EntitySelector.NO_SPECTATORS);
    }

    default public boolean isUnobstructed(@Nullable Entity pEntity, VoxelShape pShape) {
        if (pShape.isEmpty()) {
            return true;
        }
        for (Entity entity : this.getEntities(pEntity, pShape.bounds())) {
            if (entity.isRemoved() || !entity.blocksBuilding || pEntity != null && entity.isPassengerOfSameVehicle(pEntity) || !Shapes.joinIsNotEmpty(pShape, Shapes.create(entity.getBoundingBox()), BooleanOp.AND)) continue;
            return false;
        }
        return true;
    }

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> pEntityClass, AABB pArea) {
        return this.getEntitiesOfClass(pEntityClass, pArea, EntitySelector.NO_SPECTATORS);
    }

    default public List<VoxelShape> getEntityCollisions(@Nullable Entity p_186451_, AABB p_186452_) {
        if (p_186452_.getSize() < 1.0E-7) {
            return List.of();
        }
        Predicate<Entity> predicate = p_186451_ == null ? EntitySelector.CAN_BE_COLLIDED_WITH : EntitySelector.NO_SPECTATORS.and(p_186451_::canCollideWith);
        List<Entity> list = this.getEntities(p_186451_, p_186452_.inflate(1.0E-7), predicate);
        if (list.isEmpty()) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)list.size());
        for (Entity entity : list) {
            builder.add((Object)Shapes.create(entity.getBoundingBox()));
        }
        return builder.build();
    }

    @Nullable
    default public Player getNearestPlayer(double pX, double p_45920_, double pY, double p_45922_, @Nullable Predicate<Entity> pZ) {
        double d0 = -1.0;
        Player player = null;
        for (Player player2 : this.players()) {
            if (pZ != null && !pZ.test(player2)) continue;
            double d1 = player2.distanceToSqr(pX, p_45920_, pY);
            if (!(p_45922_ < 0.0) && !(d1 < p_45922_ * p_45922_) || d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            player = player2;
        }
        return player;
    }

    @Nullable
    default public Player getNearestPlayer(Entity pEntity, double pDistance) {
        return this.getNearestPlayer(pEntity.getX(), pEntity.getY(), pEntity.getZ(), pDistance, false);
    }

    @Nullable
    default public Player getNearestPlayer(double pX, double p_45926_, double pY, double p_45928_, boolean pZ) {
        Predicate<Entity> predicate = pZ ? EntitySelector.NO_CREATIVE_OR_SPECTATOR : EntitySelector.NO_SPECTATORS;
        return this.getNearestPlayer(pX, p_45926_, pY, p_45928_, predicate);
    }

    default public boolean hasNearbyAlivePlayer(double pX, double p_45916_, double pY, double p_45918_) {
        for (Player player : this.players()) {
            if (!EntitySelector.NO_SPECTATORS.test(player) || !EntitySelector.LIVING_ENTITY_STILL_ALIVE.test(player)) continue;
            double d0 = player.distanceToSqr(pX, p_45916_, pY);
            if (!(p_45918_ < 0.0) && !(d0 < p_45918_ * p_45918_)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public Player getNearestPlayer(TargetingConditions pEntity, LivingEntity pDistance) {
        return this.getNearestEntity(this.players(), pEntity, pDistance, pDistance.getX(), pDistance.getY(), pDistance.getZ());
    }

    @Nullable
    default public Player getNearestPlayer(TargetingConditions pX, LivingEntity p_45951_, double pY, double p_45953_, double pZ) {
        return this.getNearestEntity(this.players(), pX, p_45951_, pY, p_45953_, pZ);
    }

    @Nullable
    default public Player getNearestPlayer(TargetingConditions pPredicate, double pX, double p_45944_, double pY) {
        return this.getNearestEntity(this.players(), pPredicate, null, pX, p_45944_, pY);
    }

    @Nullable
    default public <T extends LivingEntity> T getNearestEntity(Class<? extends T> pEntityClazz, TargetingConditions pConditions, @Nullable LivingEntity pTarget, double pX, double p_45968_, double pY, AABB p_45970_) {
        return (T)this.getNearestEntity(this.getEntitiesOfClass(pEntityClazz, p_45970_, p_186454_ -> true), pConditions, pTarget, pX, p_45968_, pY);
    }

    @Nullable
    default public <T extends LivingEntity> T getNearestEntity(List<? extends T> pEntities, TargetingConditions pPredicate, @Nullable LivingEntity pTarget, double pX, double p_45987_, double pY) {
        double d0 = -1.0;
        LivingEntity t = null;
        for (LivingEntity t1 : pEntities) {
            if (!pPredicate.test(pTarget, t1)) continue;
            double d1 = t1.distanceToSqr(pX, p_45987_, pY);
            if (d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            t = t1;
        }
        return (T)t;
    }

    default public List<Player> getNearbyPlayers(TargetingConditions pPredicate, LivingEntity pTarget, AABB pArea) {
        ArrayList list = Lists.newArrayList();
        for (Player player : this.players()) {
            if (!pArea.contains(player.getX(), player.getY(), player.getZ()) || !pPredicate.test(pTarget, player)) continue;
            list.add(player);
        }
        return list;
    }

    default public <T extends LivingEntity> List<T> getNearbyEntities(Class<T> pEntityClazz, TargetingConditions pEntityPredicate, LivingEntity pEntity, AABB pArea) {
        List<LivingEntity> list = this.getEntitiesOfClass(pEntityClazz, pArea, p_186450_ -> true);
        ArrayList list1 = Lists.newArrayList();
        for (LivingEntity t : list) {
            if (!pEntityPredicate.test(pEntity, t)) continue;
            list1.add(t);
        }
        return list1;
    }

    @Nullable
    default public Player getPlayerByUUID(UUID pUniqueId) {
        int i = 0;
        while (i < this.players().size()) {
            Player player = this.players().get(i);
            if (pUniqueId.equals(player.getUUID())) {
                return player;
            }
            ++i;
        }
        return null;
    }
}

