/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicLike;
import java.util.Comparator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;

public class GameRules {
    public static final int DEFAULT_RANDOM_TICK_SPEED = 3;
    static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Key<?>, Type<?>> GAME_RULE_TYPES = Maps.newTreeMap(Comparator.comparing(p_46218_ -> p_46218_.id));
    public static final Key<BooleanValue> RULE_DOFIRETICK = GameRules.register("doFireTick", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_MOBGRIEFING = GameRules.register("mobGriefing", Category.MOBS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_KEEPINVENTORY = GameRules.register("keepInventory", Category.PLAYER, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_DOMOBSPAWNING = GameRules.register("doMobSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOMOBLOOT = GameRules.register("doMobLoot", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOBLOCKDROPS = GameRules.register("doTileDrops", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOENTITYDROPS = GameRules.register("doEntityDrops", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_COMMANDBLOCKOUTPUT = GameRules.register("commandBlockOutput", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_NATURAL_REGENERATION = GameRules.register("naturalRegeneration", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DAYLIGHT = GameRules.register("doDaylightCycle", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_LOGADMINCOMMANDS = GameRules.register("logAdminCommands", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_SHOWDEATHMESSAGES = GameRules.register("showDeathMessages", Category.CHAT, BooleanValue.create(true));
    public static final Key<IntegerValue> RULE_RANDOMTICKING = GameRules.register("randomTickSpeed", Category.UPDATES, IntegerValue.create(3));
    public static final Key<BooleanValue> RULE_SENDCOMMANDFEEDBACK = GameRules.register("sendCommandFeedback", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_REDUCEDDEBUGINFO = GameRules.register("reducedDebugInfo", Category.MISC, BooleanValue.create(false, (p_46212_, p_46213_) -> {
        byte b0 = (byte)(p_46213_.get() ? 22 : 23);
        for (ServerPlayer serverplayer : p_46212_.getPlayerList().getPlayers()) {
            serverplayer.connection.send(new ClientboundEntityEventPacket(serverplayer, b0));
        }
    }));
    public static final Key<BooleanValue> RULE_SPECTATORSGENERATECHUNKS = GameRules.register("spectatorsGenerateChunks", Category.PLAYER, BooleanValue.create(true));
    public static final Key<IntegerValue> RULE_SPAWN_RADIUS = GameRules.register("spawnRadius", Category.PLAYER, IntegerValue.create(10));
    public static final Key<BooleanValue> RULE_DISABLE_ELYTRA_MOVEMENT_CHECK = GameRules.register("disableElytraMovementCheck", Category.PLAYER, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_MAX_ENTITY_CRAMMING = GameRules.register("maxEntityCramming", Category.MOBS, IntegerValue.create(24));
    public static final Key<BooleanValue> RULE_WEATHER_CYCLE = GameRules.register("doWeatherCycle", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_LIMITED_CRAFTING = GameRules.register("doLimitedCrafting", Category.PLAYER, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_MAX_COMMAND_CHAIN_LENGTH = GameRules.register("maxCommandChainLength", Category.MISC, IntegerValue.create(65536));
    public static final Key<BooleanValue> RULE_ANNOUNCE_ADVANCEMENTS = GameRules.register("announceAdvancements", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DISABLE_RAIDS = GameRules.register("disableRaids", Category.MOBS, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_DOINSOMNIA = GameRules.register("doInsomnia", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_IMMEDIATE_RESPAWN = GameRules.register("doImmediateRespawn", Category.PLAYER, BooleanValue.create(false, (p_46200_, p_46201_) -> {
        for (ServerPlayer serverplayer : p_46200_.getPlayerList().getPlayers()) {
            serverplayer.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.IMMEDIATE_RESPAWN, p_46201_.get() ? 1.0f : 0.0f));
        }
    }));
    public static final Key<BooleanValue> RULE_DROWNING_DAMAGE = GameRules.register("drowningDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FALL_DAMAGE = GameRules.register("fallDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FIRE_DAMAGE = GameRules.register("fireDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FREEZE_DAMAGE = GameRules.register("freezeDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_PATROL_SPAWNING = GameRules.register("doPatrolSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_TRADER_SPAWNING = GameRules.register("doTraderSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FORGIVE_DEAD_PLAYERS = GameRules.register("forgiveDeadPlayers", Category.MOBS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_UNIVERSAL_ANGER = GameRules.register("universalAnger", Category.MOBS, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_PLAYERS_SLEEPING_PERCENTAGE = GameRules.register("playersSleepingPercentage", Category.PLAYER, IntegerValue.create(100));
    private final Map<Key<?>, Value<?>> rules;

    private static <T extends Value<T>> Key<T> register(String pName, Category pCategory, Type<T> pType) {
        Key key = new Key(pName, pCategory);
        Type<T> type = GAME_RULE_TYPES.put(key, pType);
        if (type != null) {
            throw new IllegalStateException("Duplicate game rule registration for " + pName);
        }
        return key;
    }

    public GameRules(DynamicLike<?> pRules) {
        this();
        this.loadFromTag(pRules);
    }

    public GameRules() {
        this.rules = (Map)GAME_RULE_TYPES.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_46210_ -> ((Type)p_46210_.getValue()).createRule()));
    }

    private GameRules(Map<Key<?>, Value<?>> pRules) {
        this.rules = pRules;
    }

    public <T extends Value<T>> T getRule(Key<T> pKey) {
        return (T)this.rules.get(pKey);
    }

    public CompoundTag createTag() {
        CompoundTag compoundtag = new CompoundTag();
        this.rules.forEach((p_46197_, p_46198_) -> compoundtag.putString(p_46197_.id, p_46198_.serialize()));
        return compoundtag;
    }

    private void loadFromTag(DynamicLike<?> pDynamic) {
        this.rules.forEach((p_46187_, p_46188_) -> pDynamic.get(p_46187_.id).asString().result().ifPresent(p_46188_::deserialize));
    }

    public GameRules copy() {
        return new GameRules((Map)this.rules.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_46194_ -> ((Value)p_46194_.getValue()).copy())));
    }

    public static void visitGameRuleTypes(GameRuleTypeVisitor pVisitor) {
        GAME_RULE_TYPES.forEach((p_46205_, p_46206_) -> GameRules.callVisitorCap(pVisitor, p_46205_, p_46206_));
    }

    private static <T extends Value<T>> void callVisitorCap(GameRuleTypeVisitor pVisitor, Key<?> pKey, Type<?> pType) {
        pVisitor.visit(pKey, pType);
        pType.callVisitor(pVisitor, pKey);
    }

    public void assignFrom(GameRules pRules, @Nullable MinecraftServer pServer) {
        pRules.rules.keySet().forEach(p_46182_ -> this.assignCap((Key)p_46182_, pRules, pServer));
    }

    private <T extends Value<T>> void assignCap(Key<T> pKey, GameRules pRules, @Nullable MinecraftServer pServer) {
        T t = pRules.getRule(pKey);
        ((Value)this.getRule(pKey)).setFrom(t, pServer);
    }

    public boolean getBoolean(Key<BooleanValue> pKey) {
        return this.getRule(pKey).get();
    }

    public int getInt(Key<IntegerValue> pKey) {
        return this.getRule(pKey).get();
    }

    public static class BooleanValue
    extends Value<BooleanValue> {
        private boolean value;

        static Type<BooleanValue> create(boolean pDefaultValue, BiConsumer<MinecraftServer, BooleanValue> pChangeListener) {
            return new Type<BooleanValue>(BoolArgumentType::bool, p_46242_ -> new BooleanValue((Type<BooleanValue>)p_46242_, pDefaultValue), pChangeListener, GameRuleTypeVisitor::visitBoolean);
        }

        static Type<BooleanValue> create(boolean pDefaultValue) {
            return BooleanValue.create(pDefaultValue, (p_46236_, p_46237_) -> {});
        }

        public BooleanValue(Type<BooleanValue> pType, boolean pValue) {
            super(pType);
            this.value = pValue;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandSourceStack> pContext, String pParamName) {
            this.value = BoolArgumentType.getBool(pContext, (String)pParamName);
        }

        public boolean get() {
            return this.value;
        }

        public void set(boolean pValue, @Nullable MinecraftServer pServer) {
            this.value = pValue;
            this.onChanged(pServer);
        }

        @Override
        public String serialize() {
            return Boolean.toString(this.value);
        }

        @Override
        protected void deserialize(String pValue) {
            this.value = Boolean.parseBoolean(pValue);
        }

        @Override
        public int getCommandResult() {
            return this.value ? 1 : 0;
        }

        @Override
        protected BooleanValue getSelf() {
            return this;
        }

        @Override
        protected BooleanValue copy() {
            return new BooleanValue(this.type, this.value);
        }

        @Override
        public void setFrom(BooleanValue pValue, @Nullable MinecraftServer pServer) {
            this.value = pValue.value;
            this.onChanged(pServer);
        }
    }

    public static enum Category {
        PLAYER("gamerule.category.player"),
        MOBS("gamerule.category.mobs"),
        SPAWNING("gamerule.category.spawning"),
        DROPS("gamerule.category.drops"),
        UPDATES("gamerule.category.updates"),
        CHAT("gamerule.category.chat"),
        MISC("gamerule.category.misc");

        private final String descriptionId;

        private Category(String p_46273_) {
            this.descriptionId = p_46273_;
        }

        public String getDescriptionId() {
            return this.descriptionId;
        }
    }

    public static interface GameRuleTypeVisitor {
        default public <T extends Value<T>> void visit(Key<T> pKey, Type<T> pType) {
        }

        default public void visitBoolean(Key<BooleanValue> pKey, Type<BooleanValue> pType) {
        }

        default public void visitInteger(Key<IntegerValue> pKey, Type<IntegerValue> pType) {
        }
    }

    public static class IntegerValue
    extends Value<IntegerValue> {
        private int value;

        private static Type<IntegerValue> create(int pDefaultValue, BiConsumer<MinecraftServer, IntegerValue> pChangeListener) {
            return new Type<IntegerValue>(IntegerArgumentType::integer, p_46293_ -> new IntegerValue((Type<IntegerValue>)p_46293_, pDefaultValue), pChangeListener, GameRuleTypeVisitor::visitInteger);
        }

        static Type<IntegerValue> create(int pDefaultValue) {
            return IntegerValue.create(pDefaultValue, (p_46309_, p_46310_) -> {});
        }

        public IntegerValue(Type<IntegerValue> pType, int pValue) {
            super(pType);
            this.value = pValue;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandSourceStack> pContext, String pParamName) {
            this.value = IntegerArgumentType.getInteger(pContext, (String)pParamName);
        }

        public int get() {
            return this.value;
        }

        public void set(int pValue, @Nullable MinecraftServer pServer) {
            this.value = pValue;
            this.onChanged(pServer);
        }

        @Override
        public String serialize() {
            return Integer.toString(this.value);
        }

        @Override
        protected void deserialize(String pValue) {
            this.value = IntegerValue.safeParse(pValue);
        }

        public boolean tryDeserialize(String pName) {
            try {
                this.value = Integer.parseInt(pName);
                return true;
            }
            catch (NumberFormatException numberformatexception) {
                return false;
            }
        }

        private static int safeParse(String pStrValue) {
            if (!pStrValue.isEmpty()) {
                try {
                    return Integer.parseInt(pStrValue);
                }
                catch (NumberFormatException numberformatexception) {
                    LOGGER.warn("Failed to parse integer {}", (Object)pStrValue);
                }
            }
            return 0;
        }

        @Override
        public int getCommandResult() {
            return this.value;
        }

        @Override
        protected IntegerValue getSelf() {
            return this;
        }

        @Override
        protected IntegerValue copy() {
            return new IntegerValue(this.type, this.value);
        }

        @Override
        public void setFrom(IntegerValue pValue, @Nullable MinecraftServer pServer) {
            this.value = pValue.value;
            this.onChanged(pServer);
        }
    }

    public static final class Key<T extends Value<T>> {
        final String id;
        private final Category category;

        public Key(String pId, Category pCategory) {
            this.id = pId;
            this.category = pCategory;
        }

        public String toString() {
            return this.id;
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            return pOther instanceof Key && ((Key)pOther).id.equals(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String getId() {
            return this.id;
        }

        public String getDescriptionId() {
            return "gamerule." + this.id;
        }

        public Category getCategory() {
            return this.category;
        }
    }

    public static class Type<T extends Value<T>> {
        private final Supplier<ArgumentType<?>> argument;
        private final Function<Type<T>, T> constructor;
        final BiConsumer<MinecraftServer, T> callback;
        private final VisitorCaller<T> visitorCaller;

        Type(Supplier<ArgumentType<?>> pArgument, Function<Type<T>, T> pConstructor, BiConsumer<MinecraftServer, T> pCallback, VisitorCaller<T> pVisitorCaller) {
            this.argument = pArgument;
            this.constructor = pConstructor;
            this.callback = pCallback;
            this.visitorCaller = pVisitorCaller;
        }

        public RequiredArgumentBuilder<CommandSourceStack, ?> createArgument(String pName) {
            return Commands.argument(pName, this.argument.get());
        }

        public T createRule() {
            return (T)((Value)this.constructor.apply(this));
        }

        public void callVisitor(GameRuleTypeVisitor pVisitor, Key<T> pKey) {
            this.visitorCaller.call(pVisitor, pKey, this);
        }
    }

    public static abstract class Value<T extends Value<T>> {
        protected final Type<T> type;

        public Value(Type<T> pType) {
            this.type = pType;
        }

        protected abstract void updateFromArgument(CommandContext<CommandSourceStack> var1, String var2);

        public void setFromArgument(CommandContext<CommandSourceStack> pContext, String pParamName) {
            this.updateFromArgument(pContext, pParamName);
            this.onChanged(((CommandSourceStack)pContext.getSource()).getServer());
        }

        protected void onChanged(@Nullable MinecraftServer pServer) {
            if (pServer != null) {
                this.type.callback.accept(pServer, (MinecraftServer)this.getSelf());
            }
        }

        protected abstract void deserialize(String var1);

        public abstract String serialize();

        public String toString() {
            return this.serialize();
        }

        public abstract int getCommandResult();

        protected abstract T getSelf();

        protected abstract T copy();

        public abstract void setFrom(T var1, @Nullable MinecraftServer var2);
    }

    static interface VisitorCaller<T extends Value<T>> {
        public void call(GameRuleTypeVisitor var1, Key<T> var2, Type<T> var3);
    }
}

