/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;

public interface LevelAccessor
extends CommonLevelAccessor,
LevelTimeAccess {
    @Override
    default public long dayTime() {
        return this.getLevelData().getDayTime();
    }

    public long nextSubTickCount();

    public LevelTickAccess<Block> getBlockTicks();

    private <T> ScheduledTick<T> createTick(BlockPos p_186483_, T p_186484_, int p_186485_, TickPriority p_186486_) {
        return new ScheduledTick<T>(p_186484_, p_186483_, this.getLevelData().getGameTime() + (long)p_186485_, p_186486_, this.nextSubTickCount());
    }

    private <T> ScheduledTick<T> createTick(BlockPos p_186479_, T p_186480_, int p_186481_) {
        return new ScheduledTick<T>(p_186480_, p_186479_, this.getLevelData().getGameTime() + (long)p_186481_, this.nextSubTickCount());
    }

    default public void scheduleTick(BlockPos p_186465_, Block p_186466_, int p_186467_, TickPriority p_186468_) {
        this.getBlockTicks().schedule(this.createTick(p_186465_, p_186466_, p_186467_, p_186468_));
    }

    default public void scheduleTick(BlockPos p_186461_, Block p_186462_, int p_186463_) {
        this.getBlockTicks().schedule(this.createTick(p_186461_, p_186462_, p_186463_));
    }

    public LevelTickAccess<Fluid> getFluidTicks();

    default public void scheduleTick(BlockPos p_186474_, Fluid p_186475_, int p_186476_, TickPriority p_186477_) {
        this.getFluidTicks().schedule(this.createTick(p_186474_, p_186475_, p_186476_, p_186477_));
    }

    default public void scheduleTick(BlockPos p_186470_, Fluid p_186471_, int p_186472_) {
        this.getFluidTicks().schedule(this.createTick(p_186470_, p_186471_, p_186472_));
    }

    public LevelData getLevelData();

    public DifficultyInstance getCurrentDifficultyAt(BlockPos var1);

    @Nullable
    public MinecraftServer getServer();

    default public Difficulty getDifficulty() {
        return this.getLevelData().getDifficulty();
    }

    public ChunkSource getChunkSource();

    @Override
    default public boolean hasChunk(int pChunkX, int pChunkZ) {
        return this.getChunkSource().hasChunk(pChunkX, pChunkZ);
    }

    public Random getRandom();

    default public void blockUpdated(BlockPos pPos, Block pBlock) {
    }

    public void playSound(@Nullable Player var1, BlockPos var2, SoundEvent var3, SoundSource var4, float var5, float var6);

    public void addParticle(ParticleOptions var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public void levelEvent(@Nullable Player var1, int var2, BlockPos var3, int var4);

    default public void levelEvent(int pType, BlockPos pPos, int pData) {
        this.levelEvent(null, pType, pPos, pData);
    }

    public void gameEvent(@Nullable Entity var1, GameEvent var2, BlockPos var3);

    default public void gameEvent(GameEvent pGameEvent, BlockPos pPos) {
        this.gameEvent(null, pGameEvent, pPos);
    }

    default public void gameEvent(GameEvent pGameEvent, Entity pPos) {
        this.gameEvent(null, pGameEvent, pPos.blockPosition());
    }

    default public void gameEvent(@Nullable Entity pEntity, GameEvent pEvent, Entity pPos) {
        this.gameEvent(pEntity, pEvent, pPos.blockPosition());
    }
}

