/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;

public interface LevelHeightAccessor {
    public int getHeight();

    public int getMinBuildHeight();

    default public int getMaxBuildHeight() {
        return this.getMinBuildHeight() + this.getHeight();
    }

    default public int getSectionsCount() {
        return this.getMaxSection() - this.getMinSection();
    }

    default public int getMinSection() {
        return SectionPos.blockToSectionCoord(this.getMinBuildHeight());
    }

    default public int getMaxSection() {
        return SectionPos.blockToSectionCoord(this.getMaxBuildHeight() - 1) + 1;
    }

    default public boolean isOutsideBuildHeight(BlockPos pY) {
        return this.isOutsideBuildHeight(pY.getY());
    }

    default public boolean isOutsideBuildHeight(int pY) {
        return pY < this.getMinBuildHeight() || pY >= this.getMaxBuildHeight();
    }

    default public int getSectionIndex(int pY) {
        return this.getSectionIndexFromSectionY(SectionPos.blockToSectionCoord(pY));
    }

    default public int getSectionIndexFromSectionY(int pSectionIndex) {
        return pSectionIndex - this.getMinSection();
    }

    default public int getSectionYFromSectionIndex(int pSectionIndex) {
        return pSectionIndex + this.getMinSection();
    }

    public static LevelHeightAccessor create(int p_186488_, int p_186489_) {
        return new LevelHeightAccessor(){

            @Override
            public int getHeight() {
                return p_186489_;
            }

            @Override
            public int getMinBuildHeight() {
                return p_186488_;
            }
        };
    }
}

