/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public interface LevelReader
extends BlockAndTintGetter,
CollisionGetter,
BiomeManager.NoiseBiomeSource {
    @Nullable
    public ChunkAccess getChunk(int var1, int var2, ChunkStatus var3, boolean var4);

    @Deprecated
    public boolean hasChunk(int var1, int var2);

    public int getHeight(Heightmap.Types var1, int var2, int var3);

    public int getSkyDarken();

    public BiomeManager getBiomeManager();

    default public Holder<Biome> getBiome(BlockPos pPos) {
        return this.getBiomeManager().getBiome(pPos);
    }

    default public Stream<BlockState> getBlockStatesIfLoaded(AABB pAabb) {
        int j1;
        int i = Mth.floor(pAabb.minX);
        int j = Mth.floor(pAabb.maxX);
        int k = Mth.floor(pAabb.minY);
        int l = Mth.floor(pAabb.maxY);
        int i1 = Mth.floor(pAabb.minZ);
        return this.hasChunksAt(i, k, i1, j, l, j1 = Mth.floor(pAabb.maxZ)) ? this.getBlockStates(pAabb) : Stream.empty();
    }

    @Override
    default public int getBlockTint(BlockPos pBlockPos, ColorResolver pColorResolver) {
        return pColorResolver.getColor(this.getBiome(pBlockPos).value(), pBlockPos.getX(), pBlockPos.getZ());
    }

    @Override
    default public Holder<Biome> getNoiseBiome(int pX, int pY, int pZ) {
        ChunkAccess chunkaccess = this.getChunk(QuartPos.toSection(pX), QuartPos.toSection(pZ), ChunkStatus.BIOMES, false);
        return chunkaccess != null ? chunkaccess.getNoiseBiome(pX, pY, pZ) : this.getUncachedNoiseBiome(pX, pY, pZ);
    }

    public Holder<Biome> getUncachedNoiseBiome(int var1, int var2, int var3);

    public boolean isClientSide();

    @Deprecated
    public int getSeaLevel();

    public DimensionType dimensionType();

    @Override
    default public int getMinBuildHeight() {
        return this.dimensionType().minY();
    }

    @Override
    default public int getHeight() {
        return this.dimensionType().height();
    }

    default public BlockPos getHeightmapPos(Heightmap.Types pHeightmapType, BlockPos pPos) {
        return new BlockPos(pPos.getX(), this.getHeight(pHeightmapType, pPos.getX(), pPos.getZ()), pPos.getZ());
    }

    default public boolean isEmptyBlock(BlockPos pPos) {
        return this.getBlockState(pPos).isAir();
    }

    default public boolean canSeeSkyFromBelowWater(BlockPos pPos) {
        if (pPos.getY() >= this.getSeaLevel()) {
            return this.canSeeSky(pPos);
        }
        BlockPos blockpos = new BlockPos(pPos.getX(), this.getSeaLevel(), pPos.getZ());
        if (!this.canSeeSky(blockpos)) {
            return false;
        }
        BlockPos blockpos1 = blockpos.below();
        while (blockpos1.getY() > pPos.getY()) {
            BlockState blockstate = this.getBlockState(blockpos1);
            if (blockstate.getLightBlock(this, blockpos1) > 0 && !blockstate.getMaterial().isLiquid()) {
                return false;
            }
            blockpos1 = blockpos1.below();
        }
        return true;
    }

    @Deprecated
    default public float getBrightness(BlockPos pPos) {
        return this.dimensionType().brightness(this.getMaxLocalRawBrightness(pPos));
    }

    default public int getDirectSignal(BlockPos pPos, Direction pDirection) {
        return this.getBlockState(pPos).getDirectSignal(this, pPos, pDirection);
    }

    default public ChunkAccess getChunk(BlockPos pPos) {
        return this.getChunk(SectionPos.blockToSectionCoord(pPos.getX()), SectionPos.blockToSectionCoord(pPos.getZ()));
    }

    default public ChunkAccess getChunk(int pChunkX, int pChunkZ) {
        return this.getChunk(pChunkX, pChunkZ, ChunkStatus.FULL, true);
    }

    default public ChunkAccess getChunk(int pChunkX, int pChunkZ, ChunkStatus pRequiredStatus) {
        return this.getChunk(pChunkX, pChunkZ, pRequiredStatus, true);
    }

    @Override
    @Nullable
    default public BlockGetter getChunkForCollisions(int pChunkX, int pChunkZ) {
        return this.getChunk(pChunkX, pChunkZ, ChunkStatus.EMPTY, false);
    }

    default public boolean isWaterAt(BlockPos pPos) {
        return this.getFluidState(pPos).is(FluidTags.WATER);
    }

    default public boolean containsAnyLiquid(AABB pBb) {
        int i = Mth.floor(pBb.minX);
        int j = Mth.ceil(pBb.maxX);
        int k = Mth.floor(pBb.minY);
        int l = Mth.ceil(pBb.maxY);
        int i1 = Mth.floor(pBb.minZ);
        int j1 = Mth.ceil(pBb.maxZ);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    BlockState blockstate = this.getBlockState(blockpos$mutableblockpos.set(k1, l1, i2));
                    if (!blockstate.getFluidState().isEmpty()) {
                        return true;
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    default public int getMaxLocalRawBrightness(BlockPos pPos) {
        return this.getMaxLocalRawBrightness(pPos, this.getSkyDarken());
    }

    default public int getMaxLocalRawBrightness(BlockPos pPos, int pAmount) {
        return pPos.getX() >= -30000000 && pPos.getZ() >= -30000000 && pPos.getX() < 30000000 && pPos.getZ() < 30000000 ? this.getRawBrightness(pPos, pAmount) : 15;
    }

    @Deprecated
    default public boolean hasChunkAt(int pX, int pZ) {
        return this.hasChunk(SectionPos.blockToSectionCoord(pX), SectionPos.blockToSectionCoord(pZ));
    }

    @Deprecated
    default public boolean hasChunkAt(BlockPos pPos) {
        return this.hasChunkAt(pPos.getX(), pPos.getZ());
    }

    @Deprecated
    default public boolean hasChunksAt(BlockPos pFrom, BlockPos pTo) {
        return this.hasChunksAt(pFrom.getX(), pFrom.getY(), pFrom.getZ(), pTo.getX(), pTo.getY(), pTo.getZ());
    }

    @Deprecated
    default public boolean hasChunksAt(int pFromX, int pFromY, int pFromZ, int pToX, int pToY, int pToZ) {
        return pToY >= this.getMinBuildHeight() && pFromY < this.getMaxBuildHeight() ? this.hasChunksAt(pFromX, pFromZ, pToX, pToZ) : false;
    }

    @Deprecated
    default public boolean hasChunksAt(int pFromX, int pFromZ, int pToX, int pToZ) {
        int i = SectionPos.blockToSectionCoord(pFromX);
        int j = SectionPos.blockToSectionCoord(pToX);
        int k = SectionPos.blockToSectionCoord(pFromZ);
        int l = SectionPos.blockToSectionCoord(pToZ);
        int i1 = i;
        while (i1 <= j) {
            int j1 = k;
            while (j1 <= l) {
                if (!this.hasChunk(i1, j1)) {
                    return false;
                }
                ++j1;
            }
            ++i1;
        }
        return true;
    }
}

