/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.PotentialCalculator;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.NetherFortressFeature;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public final class NaturalSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MIN_SPAWN_DISTANCE = 24;
    public static final int SPAWN_DISTANCE_CHUNK = 8;
    public static final int SPAWN_DISTANCE_BLOCK = 128;
    static final int MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);
    private static final MobCategory[] SPAWNING_CATEGORIES = (MobCategory[])Stream.of(MobCategory.values()).filter(p_47037_ -> p_47037_ != MobCategory.MISC).toArray(MobCategory[]::new);

    private NaturalSpawner() {
    }

    public static SpawnState createState(int p_186525_, Iterable<Entity> p_186526_, ChunkGetter p_186527_, LocalMobCapCalculator p_186528_) {
        PotentialCalculator potentialcalculator = new PotentialCalculator();
        Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
        Iterator<Entity> iterator = p_186526_.iterator();
        while (iterator.hasNext()) {
            MobCategory mobcategory;
            Mob mob;
            Entity entity = iterator.next();
            if (entity instanceof Mob && ((mob = (Mob)entity).isPersistenceRequired() || mob.requiresCustomPersistence()) || (mobcategory = entity.getType().getCategory()) == MobCategory.MISC) continue;
            Entity entity_f = entity;
            BlockPos blockpos = entity.blockPosition();
            p_186527_.query(ChunkPos.asLong(blockpos), p_186541_ -> {
                MobSpawnSettings.MobSpawnCost mobspawnsettings$mobspawncost = NaturalSpawner.getRoughBiome(blockpos, p_186541_).getMobSettings().getMobSpawnCost(entity_f.getType());
                if (mobspawnsettings$mobspawncost != null) {
                    potentialcalculator.addCharge(entity_f.blockPosition(), mobspawnsettings$mobspawncost.getCharge());
                }
                if (entity_f instanceof Mob) {
                    p_186528_.addMob(p_186541_.getPos(), mobcategory);
                }
                object2intopenhashmap.addTo((Object)mobcategory, 1);
            });
        }
        return new SpawnState(p_186525_, (Object2IntOpenHashMap<MobCategory>)object2intopenhashmap, potentialcalculator, p_186528_);
    }

    static Biome getRoughBiome(BlockPos pPos, ChunkAccess pChunk) {
        return pChunk.getNoiseBiome(QuartPos.fromBlock(pPos.getX()), QuartPos.fromBlock(pPos.getY()), QuartPos.fromBlock(pPos.getZ())).value();
    }

    public static void spawnForChunk(ServerLevel p_47030_, LevelChunk p_47031_, SpawnState p_47032_, boolean p_47033_, boolean p_47034_, boolean p_47035_) {
        p_47030_.getProfiler().push("spawner");
        MobCategory[] mobCategoryArray = SPAWNING_CATEGORIES;
        int n = SPAWNING_CATEGORIES.length;
        int n2 = 0;
        while (n2 < n) {
            MobCategory mobcategory = mobCategoryArray[n2];
            if (!(!p_47033_ && mobcategory.isFriendly() || !p_47034_ && !mobcategory.isFriendly() || !p_47035_ && mobcategory.isPersistent() || !p_47032_.canSpawnForCategory(mobcategory, p_47031_.getPos()))) {
                NaturalSpawner.spawnCategoryForChunk(mobcategory, p_47030_, p_47031_, (arg_0, arg_1, arg_2) -> SpawnState.access$0(p_47032_, arg_0, arg_1, arg_2), (arg_0, arg_1) -> SpawnState.access$1(p_47032_, arg_0, arg_1));
            }
            ++n2;
        }
        p_47030_.getProfiler().pop();
    }

    public static void spawnCategoryForChunk(MobCategory pCategory, ServerLevel pLevel, LevelChunk pChunk, SpawnPredicate pFilter, AfterSpawnCallback pCallback) {
        BlockPos blockpos = NaturalSpawner.getRandomPosWithin(pLevel, pChunk);
        if (blockpos.getY() >= pLevel.getMinBuildHeight() + 1) {
            NaturalSpawner.spawnCategoryForPosition(pCategory, pLevel, pChunk, blockpos, pFilter, pCallback);
        }
    }

    @VisibleForDebug
    public static void spawnCategoryForPosition(MobCategory pCategory, ServerLevel pLevel, BlockPos pPos) {
        NaturalSpawner.spawnCategoryForPosition(pCategory, pLevel, pLevel.getChunk(pPos), pPos, (p_151606_, p_151607_, p_151608_) -> true, (p_151610_, p_151611_) -> {});
    }

    public static void spawnCategoryForPosition(MobCategory pCategory, ServerLevel pLevel, ChunkAccess pChunk, BlockPos pPos, SpawnPredicate pFilter, AfterSpawnCallback pCallback) {
        StructureFeatureManager structurefeaturemanager = pLevel.structureFeatureManager();
        ChunkGenerator chunkgenerator = pLevel.getChunkSource().getGenerator();
        int i = pPos.getY();
        BlockState blockstate = pChunk.getBlockState(pPos);
        if (!blockstate.isRedstoneConductor(pChunk, pPos)) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            int j = 0;
            int k = 0;
            while (k < 3) {
                int l = pPos.getX();
                int i1 = pPos.getZ();
                int j1 = 6;
                MobSpawnSettings.SpawnerData mobspawnsettings$spawnerdata = null;
                SpawnGroupData spawngroupdata = null;
                int k1 = Mth.ceil(pLevel.random.nextFloat() * 4.0f);
                int l1 = 0;
                int i2 = 0;
                while (i2 < k1) {
                    double d2;
                    blockpos$mutableblockpos.set(l += pLevel.random.nextInt(6) - pLevel.random.nextInt(6), i, i1 += pLevel.random.nextInt(6) - pLevel.random.nextInt(6));
                    double d0 = (double)l + 0.5;
                    double d1 = (double)i1 + 0.5;
                    Player player = pLevel.getNearestPlayer(d0, (double)i, d1, -1.0, false);
                    if (player != null && NaturalSpawner.isRightDistanceToPlayerAndSpawnPoint(pLevel, pChunk, blockpos$mutableblockpos, d2 = player.distanceToSqr(d0, i, d1))) {
                        if (mobspawnsettings$spawnerdata == null) {
                            Optional<MobSpawnSettings.SpawnerData> optional = NaturalSpawner.getRandomSpawnMobAt(pLevel, structurefeaturemanager, chunkgenerator, pCategory, pLevel.random, blockpos$mutableblockpos);
                            if (optional.isEmpty()) break;
                            mobspawnsettings$spawnerdata = optional.get();
                            k1 = mobspawnsettings$spawnerdata.minCount + pLevel.random.nextInt(1 + mobspawnsettings$spawnerdata.maxCount - mobspawnsettings$spawnerdata.minCount);
                        }
                        if (NaturalSpawner.isValidSpawnPostitionForType(pLevel, pCategory, structurefeaturemanager, chunkgenerator, mobspawnsettings$spawnerdata, blockpos$mutableblockpos, d2) && pFilter.test(mobspawnsettings$spawnerdata.type, blockpos$mutableblockpos, pChunk)) {
                            Mob mob = NaturalSpawner.getMobForSpawn(pLevel, mobspawnsettings$spawnerdata.type);
                            if (mob == null) {
                                return;
                            }
                            mob.moveTo(d0, i, d1, pLevel.random.nextFloat() * 360.0f, 0.0f);
                            if (NaturalSpawner.isValidPositionForMob(pLevel, mob, d2)) {
                                spawngroupdata = mob.finalizeSpawn(pLevel, pLevel.getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.NATURAL, spawngroupdata, null);
                                ++l1;
                                pLevel.addFreshEntityWithPassengers(mob);
                                pCallback.run(mob, pChunk);
                                if (++j >= mob.getMaxSpawnClusterSize()) {
                                    return;
                                }
                                if (mob.isMaxGroupSizeReached(l1)) break;
                            }
                        }
                    }
                    ++i2;
                }
                ++k;
            }
        }
    }

    private static boolean isRightDistanceToPlayerAndSpawnPoint(ServerLevel pLevel, ChunkAccess pChunk, BlockPos.MutableBlockPos pPos, double pDistance) {
        if (pDistance <= 576.0) {
            return false;
        }
        if (pLevel.getSharedSpawnPos().closerToCenterThan(new Vec3((double)pPos.getX() + 0.5, pPos.getY(), (double)pPos.getZ() + 0.5), 24.0)) {
            return false;
        }
        return Objects.equals(new ChunkPos(pPos), pChunk.getPos()) || pLevel.isNaturalSpawningAllowed(pPos);
    }

    private static boolean isValidSpawnPostitionForType(ServerLevel pLevel, MobCategory pCategory, StructureFeatureManager pStructureManager, ChunkGenerator pGenerator, MobSpawnSettings.SpawnerData pData, BlockPos.MutableBlockPos pPos, double pDistance) {
        EntityType<?> entitytype = pData.type;
        if (entitytype.getCategory() == MobCategory.MISC) {
            return false;
        }
        if (!entitytype.canSpawnFarFromPlayer() && pDistance > (double)(entitytype.getCategory().getDespawnDistance() * entitytype.getCategory().getDespawnDistance())) {
            return false;
        }
        if (entitytype.canSummon() && NaturalSpawner.canSpawnMobAt(pLevel, pStructureManager, pGenerator, pCategory, pData, pPos)) {
            SpawnPlacements.Type spawnplacements$type = SpawnPlacements.getPlacementType(entitytype);
            if (!NaturalSpawner.isSpawnPositionOk(spawnplacements$type, pLevel, pPos, entitytype)) {
                return false;
            }
            if (!SpawnPlacements.checkSpawnRules(entitytype, pLevel, MobSpawnType.NATURAL, pPos, pLevel.random)) {
                return false;
            }
            return pLevel.noCollision(entitytype.getAABB((double)pPos.getX() + 0.5, pPos.getY(), (double)pPos.getZ() + 0.5));
        }
        return false;
    }

    @Nullable
    private static Mob getMobForSpawn(ServerLevel pLevel, EntityType<?> pEntityType) {
        try {
            Object entity = pEntityType.create(pLevel);
            if (!(entity instanceof Mob)) {
                throw new IllegalStateException("Trying to spawn a non-mob: " + Registry.ENTITY_TYPE.getKey(pEntityType));
            }
            return (Mob)entity;
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to create mob", (Throwable)exception);
            return null;
        }
    }

    private static boolean isValidPositionForMob(ServerLevel pLevel, Mob pMob, double pDistance) {
        if (pDistance > (double)(pMob.getType().getCategory().getDespawnDistance() * pMob.getType().getCategory().getDespawnDistance()) && pMob.removeWhenFarAway(pDistance)) {
            return false;
        }
        return pMob.checkSpawnRules(pLevel, MobSpawnType.NATURAL) && pMob.checkSpawnObstruction(pLevel);
    }

    private static Optional<MobSpawnSettings.SpawnerData> getRandomSpawnMobAt(ServerLevel pLevel, StructureFeatureManager pStructureManager, ChunkGenerator pGenerator, MobCategory pCategory, Random pRandom, BlockPos pPos) {
        Holder<Biome> holder = pLevel.getBiome(pPos);
        return pCategory == MobCategory.WATER_AMBIENT && Biome.getBiomeCategory(holder) == Biome.BiomeCategory.RIVER && pRandom.nextFloat() < 0.98f ? Optional.empty() : NaturalSpawner.mobsAt(pLevel, pStructureManager, pGenerator, pCategory, pPos, holder).getRandom(pRandom);
    }

    private static boolean canSpawnMobAt(ServerLevel pLevel, StructureFeatureManager pStructureManager, ChunkGenerator pGenerator, MobCategory pCategory, MobSpawnSettings.SpawnerData pData, BlockPos pPos) {
        return NaturalSpawner.mobsAt(pLevel, pStructureManager, pGenerator, pCategory, pPos, null).unwrap().contains(pData);
    }

    private static WeightedRandomList<MobSpawnSettings.SpawnerData> mobsAt(ServerLevel pLevel, StructureFeatureManager pStructureManager, ChunkGenerator pGenerator, MobCategory pCategory, BlockPos pPos, @Nullable Holder<Biome> pBiome) {
        return NaturalSpawner.isInNetherFortressBounds(pPos, pLevel, pCategory, pStructureManager) ? NetherFortressFeature.FORTRESS_ENEMIES : pGenerator.getMobsAt(pBiome != null ? pBiome : pLevel.getBiome(pPos), pStructureManager, pCategory, pPos);
    }

    public static boolean isInNetherFortressBounds(BlockPos p_186530_, ServerLevel p_186531_, MobCategory p_186532_, StructureFeatureManager p_186533_) {
        if (p_186532_ == MobCategory.MONSTER && p_186531_.getBlockState(p_186530_.below()).is(Blocks.NETHER_BRICKS)) {
            ConfiguredStructureFeature<?, ?> configuredstructurefeature = p_186533_.registryAccess().registryOrThrow(Registry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY).get(BuiltinStructures.FORTRESS);
            return configuredstructurefeature == null ? false : p_186533_.getStructureAt(p_186530_, configuredstructurefeature).isValid();
        }
        return false;
    }

    private static BlockPos getRandomPosWithin(Level pLevel, LevelChunk pChunk) {
        ChunkPos chunkpos = pChunk.getPos();
        int i = chunkpos.getMinBlockX() + pLevel.random.nextInt(16);
        int j = chunkpos.getMinBlockZ() + pLevel.random.nextInt(16);
        int k = pChunk.getHeight(Heightmap.Types.WORLD_SURFACE, i, j) + 1;
        int l = Mth.randomBetweenInclusive(pLevel.random, pLevel.getMinBuildHeight(), k);
        return new BlockPos(i, l, j);
    }

    public static boolean isValidEmptySpawnBlock(BlockGetter pBlock, BlockPos pPos, BlockState pBlockState, FluidState pFluidState, EntityType<?> pEntityType) {
        if (pBlockState.isCollisionShapeFullBlock(pBlock, pPos)) {
            return false;
        }
        if (pBlockState.isSignalSource()) {
            return false;
        }
        if (!pFluidState.isEmpty()) {
            return false;
        }
        if (pBlockState.is(BlockTags.PREVENT_MOB_SPAWNING_INSIDE)) {
            return false;
        }
        return !pEntityType.isBlockDangerous(pBlockState);
    }

    public static boolean isSpawnPositionOk(SpawnPlacements.Type pPlaceType, LevelReader pLevel, BlockPos pPos, @Nullable EntityType<?> pEntityType) {
        if (pPlaceType == SpawnPlacements.Type.NO_RESTRICTIONS) {
            return true;
        }
        if (pEntityType != null && pLevel.getWorldBorder().isWithinBounds(pPos)) {
            BlockState blockstate = pLevel.getBlockState(pPos);
            FluidState fluidstate = pLevel.getFluidState(pPos);
            BlockPos blockpos = pPos.above();
            BlockPos blockpos1 = pPos.below();
            switch (pPlaceType) {
                case IN_WATER: {
                    return fluidstate.is(FluidTags.WATER) && !pLevel.getBlockState(blockpos).isRedstoneConductor(pLevel, blockpos);
                }
                case IN_LAVA: {
                    return fluidstate.is(FluidTags.LAVA);
                }
            }
            BlockState blockstate1 = pLevel.getBlockState(blockpos1);
            if (!blockstate1.isValidSpawn(pLevel, blockpos1, pEntityType)) {
                return false;
            }
            return NaturalSpawner.isValidEmptySpawnBlock(pLevel, pPos, blockstate, fluidstate, pEntityType) && NaturalSpawner.isValidEmptySpawnBlock(pLevel, blockpos, pLevel.getBlockState(blockpos), pLevel.getFluidState(blockpos), pEntityType);
        }
        return false;
    }

    public static void spawnMobsForChunkGeneration(ServerLevelAccessor pLevel, Holder<Biome> pBiome, ChunkPos pChunkPos, Random pRandom) {
        block9: {
            MobSpawnSettings mobspawnsettings = pBiome.value().getMobSettings();
            WeightedRandomList<MobSpawnSettings.SpawnerData> weightedrandomlist = mobspawnsettings.getMobs(MobCategory.CREATURE);
            if (weightedrandomlist.isEmpty()) break block9;
            int i = pChunkPos.getMinBlockX();
            int j = pChunkPos.getMinBlockZ();
            while (pRandom.nextFloat() < mobspawnsettings.getCreatureProbability()) {
                Optional<MobSpawnSettings.SpawnerData> optional = weightedrandomlist.getRandom(pRandom);
                if (!optional.isPresent()) continue;
                MobSpawnSettings.SpawnerData mobspawnsettings$spawnerdata = optional.get();
                int k = mobspawnsettings$spawnerdata.minCount + pRandom.nextInt(1 + mobspawnsettings$spawnerdata.maxCount - mobspawnsettings$spawnerdata.minCount);
                SpawnGroupData spawngroupdata = null;
                int l = i + pRandom.nextInt(16);
                int i1 = j + pRandom.nextInt(16);
                int j1 = l;
                int k1 = i1;
                int l1 = 0;
                while (l1 < k) {
                    boolean flag = false;
                    int i2 = 0;
                    while (!flag && i2 < 4) {
                        block8: {
                            block10: {
                                Mob mob;
                                Object entity;
                                BlockPos blockpos = NaturalSpawner.getTopNonCollidingPos(pLevel, mobspawnsettings$spawnerdata.type, l, i1);
                                if (!mobspawnsettings$spawnerdata.type.canSummon() || !NaturalSpawner.isSpawnPositionOk(SpawnPlacements.getPlacementType(mobspawnsettings$spawnerdata.type), pLevel, blockpos, mobspawnsettings$spawnerdata.type)) break block10;
                                float f = mobspawnsettings$spawnerdata.type.getWidth();
                                double d0 = Mth.clamp((double)l, (double)i + (double)f, (double)i + 16.0 - (double)f);
                                double d1 = Mth.clamp((double)i1, (double)j + (double)f, (double)j + 16.0 - (double)f);
                                if (!pLevel.noCollision(mobspawnsettings$spawnerdata.type.getAABB(d0, blockpos.getY(), d1)) || !SpawnPlacements.checkSpawnRules(mobspawnsettings$spawnerdata.type, pLevel, MobSpawnType.CHUNK_GENERATION, new BlockPos(d0, (double)blockpos.getY(), d1), pLevel.getRandom())) break block8;
                                try {
                                    entity = mobspawnsettings$spawnerdata.type.create(pLevel.getLevel());
                                }
                                catch (Exception exception) {
                                    LOGGER.warn("Failed to create mob", (Throwable)exception);
                                    break block8;
                                }
                                ((Entity)entity).moveTo(d0, blockpos.getY(), d1, pRandom.nextFloat() * 360.0f, 0.0f);
                                if (entity instanceof Mob && (mob = (Mob)entity).checkSpawnRules(pLevel, MobSpawnType.CHUNK_GENERATION) && mob.checkSpawnObstruction(pLevel)) {
                                    spawngroupdata = mob.finalizeSpawn(pLevel, pLevel.getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.CHUNK_GENERATION, spawngroupdata, null);
                                    pLevel.addFreshEntityWithPassengers(mob);
                                    flag = true;
                                }
                            }
                            l += pRandom.nextInt(5) - pRandom.nextInt(5);
                            i1 += pRandom.nextInt(5) - pRandom.nextInt(5);
                            while (l < i || l >= i + 16 || i1 < j || i1 >= j + 16) {
                                l = j1 + pRandom.nextInt(5) - pRandom.nextInt(5);
                                i1 = k1 + pRandom.nextInt(5) - pRandom.nextInt(5);
                            }
                        }
                        ++i2;
                    }
                    ++l1;
                }
            }
        }
    }

    private static BlockPos getTopNonCollidingPos(LevelReader pLevel, EntityType<?> pEntityType, int pX, int pZ) {
        BlockPos blockpos;
        int i = pLevel.getHeight(SpawnPlacements.getHeightmapType(pEntityType), pX, pZ);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(pX, i, pZ);
        if (pLevel.dimensionType().hasCeiling()) {
            do {
                blockpos$mutableblockpos.move(Direction.DOWN);
            } while (!pLevel.getBlockState(blockpos$mutableblockpos).isAir());
            do {
                blockpos$mutableblockpos.move(Direction.DOWN);
            } while (pLevel.getBlockState(blockpos$mutableblockpos).isAir() && blockpos$mutableblockpos.getY() > pLevel.getMinBuildHeight());
        }
        if (SpawnPlacements.getPlacementType(pEntityType) == SpawnPlacements.Type.ON_GROUND && pLevel.getBlockState(blockpos = blockpos$mutableblockpos.below()).isPathfindable(pLevel, blockpos, PathComputationType.LAND)) {
            return blockpos;
        }
        return blockpos$mutableblockpos.immutable();
    }

    @FunctionalInterface
    public static interface AfterSpawnCallback {
        public void run(Mob var1, ChunkAccess var2);
    }

    @FunctionalInterface
    public static interface ChunkGetter {
        public void query(long var1, Consumer<LevelChunk> var3);
    }

    @FunctionalInterface
    public static interface SpawnPredicate {
        public boolean test(EntityType<?> var1, BlockPos var2, ChunkAccess var3);
    }

    public static class SpawnState {
        private final int spawnableChunkCount;
        private final Object2IntOpenHashMap<MobCategory> mobCategoryCounts;
        private final PotentialCalculator spawnPotential;
        private final Object2IntMap<MobCategory> unmodifiableMobCategoryCounts;
        private final LocalMobCapCalculator localMobCapCalculator;
        @Nullable
        private BlockPos lastCheckedPos;
        @Nullable
        private EntityType<?> lastCheckedType;
        private double lastCharge;

        SpawnState(int p_186544_, Object2IntOpenHashMap<MobCategory> p_186545_, PotentialCalculator p_186546_, LocalMobCapCalculator p_186547_) {
            this.spawnableChunkCount = p_186544_;
            this.mobCategoryCounts = p_186545_;
            this.spawnPotential = p_186546_;
            this.localMobCapCalculator = p_186547_;
            this.unmodifiableMobCategoryCounts = Object2IntMaps.unmodifiable(p_186545_);
        }

        private boolean canSpawn(EntityType<?> pEntityType, BlockPos pPos, ChunkAccess pChunk) {
            double d0;
            this.lastCheckedPos = pPos;
            this.lastCheckedType = pEntityType;
            MobSpawnSettings.MobSpawnCost mobspawnsettings$mobspawncost = NaturalSpawner.getRoughBiome(pPos, pChunk).getMobSettings().getMobSpawnCost(pEntityType);
            if (mobspawnsettings$mobspawncost == null) {
                this.lastCharge = 0.0;
                return true;
            }
            this.lastCharge = d0 = mobspawnsettings$mobspawncost.getCharge();
            double d1 = this.spawnPotential.getPotentialEnergyChange(pPos, d0);
            return d1 <= mobspawnsettings$mobspawncost.getEnergyBudget();
        }

        private void afterSpawn(Mob pMob, ChunkAccess pChunk) {
            MobSpawnSettings.MobSpawnCost mobspawnsettings$mobspawncost;
            EntityType<?> entitytype = pMob.getType();
            BlockPos blockpos = pMob.blockPosition();
            double d0 = blockpos.equals(this.lastCheckedPos) && entitytype == this.lastCheckedType ? this.lastCharge : ((mobspawnsettings$mobspawncost = NaturalSpawner.getRoughBiome(blockpos, pChunk).getMobSettings().getMobSpawnCost(entitytype)) != null ? mobspawnsettings$mobspawncost.getCharge() : 0.0);
            this.spawnPotential.addCharge(blockpos, d0);
            MobCategory mobcategory = entitytype.getCategory();
            this.mobCategoryCounts.addTo((Object)mobcategory, 1);
            this.localMobCapCalculator.addMob(new ChunkPos(blockpos), mobcategory);
        }

        public int getSpawnableChunkCount() {
            return this.spawnableChunkCount;
        }

        public Object2IntMap<MobCategory> getMobCategoryCounts() {
            return this.unmodifiableMobCategoryCounts;
        }

        boolean canSpawnForCategory(MobCategory p_186549_, ChunkPos p_186550_) {
            int i = p_186549_.getMaxInstancesPerChunk() * this.spawnableChunkCount / MAGIC_NUMBER;
            if (this.mobCategoryCounts.getInt((Object)p_186549_) >= i) {
                return false;
            }
            return this.localMobCapCalculator.canSpawn(p_186549_, p_186550_);
        }

        static /* synthetic */ boolean access$0(SpawnState spawnState, EntityType entityType, BlockPos blockPos, ChunkAccess chunkAccess) {
            return spawnState.canSpawn(entityType, blockPos, chunkAccess);
        }

        static /* synthetic */ void access$1(SpawnState spawnState, Mob mob, ChunkAccess chunkAccess) {
            spawnState.afterSpawn(mob, chunkAccess);
        }
    }
}

