/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;

public class PotentialCalculator {
    private final List<PointCharge> charges = Lists.newArrayList();

    public void addCharge(BlockPos pPos, double pCharge) {
        if (pCharge != 0.0) {
            this.charges.add(new PointCharge(pPos, pCharge));
        }
    }

    public double getPotentialEnergyChange(BlockPos pPos, double pCharge) {
        if (pCharge == 0.0) {
            return 0.0;
        }
        double d0 = 0.0;
        for (PointCharge potentialcalculator$pointcharge : this.charges) {
            d0 += potentialcalculator$pointcharge.getPotentialChange(pPos);
        }
        return d0 * pCharge;
    }

    static class PointCharge {
        private final BlockPos pos;
        private final double charge;

        public PointCharge(BlockPos pPos, double pCharge) {
            this.pos = pPos;
            this.charge = pCharge;
        }

        public double getPotentialChange(BlockPos pPos) {
            double d0 = this.pos.distSqr(pPos);
            return d0 == 0.0 ? Double.POSITIVE_INFINITY : this.charge / Math.sqrt(d0);
        }
    }
}

