/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public final class Biome {
    public static final Codec<Biome> DIRECT_CODEC = RecordCodecBuilder.create(p_186636_ -> p_186636_.group((App)ClimateSettings.CODEC.forGetter(p_151717_ -> p_151717_.climateSettings), (App)BiomeCategory.CODEC.fieldOf("category").forGetter(p_151715_ -> p_151715_.biomeCategory), (App)BiomeSpecialEffects.CODEC.fieldOf("effects").forGetter(p_186644_ -> p_186644_.specialEffects), (App)BiomeGenerationSettings.CODEC.forGetter(p_186642_ -> p_186642_.generationSettings), (App)MobSpawnSettings.CODEC.forGetter(p_186640_ -> p_186640_.mobSettings)).apply((Applicative)p_186636_, Biome::new));
    public static final Codec<Biome> NETWORK_CODEC = RecordCodecBuilder.create(p_186632_ -> p_186632_.group((App)ClimateSettings.CODEC.forGetter(p_186638_ -> p_186638_.climateSettings), (App)BiomeCategory.CODEC.fieldOf("category").forGetter(p_186634_ -> p_186634_.biomeCategory), (App)BiomeSpecialEffects.CODEC.fieldOf("effects").forGetter(p_186630_ -> p_186630_.specialEffects)).apply((Applicative)p_186632_, (p_186626_, p_186627_, p_186628_) -> new Biome((ClimateSettings)p_186626_, (BiomeCategory)p_186627_, (BiomeSpecialEffects)p_186628_, BiomeGenerationSettings.EMPTY, MobSpawnSettings.EMPTY)));
    public static final Codec<Holder<Biome>> CODEC = RegistryFileCodec.create(Registry.BIOME_REGISTRY, DIRECT_CODEC);
    public static final Codec<HolderSet<Biome>> LIST_CODEC = RegistryCodecs.homogeneousList(Registry.BIOME_REGISTRY, DIRECT_CODEC);
    private static final PerlinSimplexNoise TEMPERATURE_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom(new LegacyRandomSource(1234L)), (List<Integer>)ImmutableList.of((Object)0));
    static final PerlinSimplexNoise FROZEN_TEMPERATURE_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom(new LegacyRandomSource(3456L)), (List<Integer>)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
    @Deprecated(forRemoval=true)
    public static final PerlinSimplexNoise BIOME_INFO_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom(new LegacyRandomSource(2345L)), (List<Integer>)ImmutableList.of((Object)0));
    private static final int TEMPERATURE_CACHE_SIZE = 1024;
    private final ClimateSettings climateSettings;
    private final BiomeGenerationSettings generationSettings;
    private final MobSpawnSettings mobSettings;
    private final BiomeCategory biomeCategory;
    private final BiomeSpecialEffects specialEffects;
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> temperatureCache = ThreadLocal.withInitial(() -> Util.make(() -> {
        Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int p_47580_) {
            }
        };
        long2floatlinkedopenhashmap.defaultReturnValue(Float.NaN);
        return long2floatlinkedopenhashmap;
    }));

    Biome(ClimateSettings p_186620_, BiomeCategory p_186621_, BiomeSpecialEffects p_186622_, BiomeGenerationSettings p_186623_, MobSpawnSettings p_186624_) {
        this.climateSettings = p_186620_;
        this.generationSettings = p_186623_;
        this.mobSettings = p_186624_;
        this.biomeCategory = p_186621_;
        this.specialEffects = p_186622_;
    }

    public int getSkyColor() {
        return this.specialEffects.getSkyColor();
    }

    public MobSpawnSettings getMobSettings() {
        return this.mobSettings;
    }

    public Precipitation getPrecipitation() {
        return this.climateSettings.precipitation;
    }

    public boolean isHumid() {
        return this.getDownfall() > 0.85f;
    }

    private float getHeightAdjustedTemperature(BlockPos pPos) {
        float f = this.climateSettings.temperatureModifier.modifyTemperature(pPos, this.getBaseTemperature());
        if (pPos.getY() > 80) {
            float f1 = (float)(TEMPERATURE_NOISE.getValue((float)pPos.getX() / 8.0f, (float)pPos.getZ() / 8.0f, false) * 8.0);
            return f - (f1 + (float)pPos.getY() - 80.0f) * 0.05f / 40.0f;
        }
        return f;
    }

    @Deprecated
    private float getTemperature(BlockPos pPos) {
        long i = pPos.asLong();
        Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = this.temperatureCache.get();
        float f = long2floatlinkedopenhashmap.get(i);
        if (!Float.isNaN(f)) {
            return f;
        }
        float f1 = this.getHeightAdjustedTemperature(pPos);
        if (long2floatlinkedopenhashmap.size() == 1024) {
            long2floatlinkedopenhashmap.removeFirstFloat();
        }
        long2floatlinkedopenhashmap.put(i, f1);
        return f1;
    }

    public boolean shouldFreeze(LevelReader pLevel, BlockPos pPos) {
        return this.shouldFreeze(pLevel, pPos, true);
    }

    public boolean shouldFreeze(LevelReader pLevel, BlockPos pWater, boolean pMustBeAtEdge) {
        if (this.warmEnoughToRain(pWater)) {
            return false;
        }
        if (pWater.getY() >= pLevel.getMinBuildHeight() && pWater.getY() < pLevel.getMaxBuildHeight() && pLevel.getBrightness(LightLayer.BLOCK, pWater) < 10) {
            BlockState blockstate = pLevel.getBlockState(pWater);
            FluidState fluidstate = pLevel.getFluidState(pWater);
            if (fluidstate.getType() == Fluids.WATER && blockstate.getBlock() instanceof LiquidBlock) {
                boolean flag;
                if (!pMustBeAtEdge) {
                    return true;
                }
                boolean bl = flag = pLevel.isWaterAt(pWater.west()) && pLevel.isWaterAt(pWater.east()) && pLevel.isWaterAt(pWater.north()) && pLevel.isWaterAt(pWater.south());
                if (!flag) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean coldEnoughToSnow(BlockPos p_198905_) {
        return !this.warmEnoughToRain(p_198905_);
    }

    public boolean warmEnoughToRain(BlockPos p_198907_) {
        return this.getTemperature(p_198907_) >= 0.15f;
    }

    public boolean shouldMeltFrozenOceanIcebergSlightly(BlockPos p_198909_) {
        return this.getTemperature(p_198909_) > 0.1f;
    }

    public boolean shouldSnowGolemBurn(BlockPos p_198911_) {
        return this.getTemperature(p_198911_) > 1.0f;
    }

    public boolean shouldSnow(LevelReader pLevel, BlockPos pPos) {
        BlockState blockstate;
        if (this.warmEnoughToRain(pPos)) {
            return false;
        }
        return pPos.getY() >= pLevel.getMinBuildHeight() && pPos.getY() < pLevel.getMaxBuildHeight() && pLevel.getBrightness(LightLayer.BLOCK, pPos) < 10 && (blockstate = pLevel.getBlockState(pPos)).isAir() && Blocks.SNOW.defaultBlockState().canSurvive(pLevel, pPos);
    }

    public BiomeGenerationSettings getGenerationSettings() {
        return this.generationSettings;
    }

    public int getFogColor() {
        return this.specialEffects.getFogColor();
    }

    public int getGrassColor(double pPosX, double p_47466_) {
        int i = this.specialEffects.getGrassColorOverride().orElseGet(this::getGrassColorFromTexture);
        return this.specialEffects.getGrassColorModifier().modifyColor(pPosX, p_47466_, i);
    }

    private int getGrassColorFromTexture() {
        double d0 = Mth.clamp(this.climateSettings.temperature, 0.0f, 1.0f);
        double d1 = Mth.clamp(this.climateSettings.downfall, 0.0f, 1.0f);
        return GrassColor.get(d0, d1);
    }

    public int getFoliageColor() {
        return this.specialEffects.getFoliageColorOverride().orElseGet(this::getFoliageColorFromTexture);
    }

    private int getFoliageColorFromTexture() {
        double d0 = Mth.clamp(this.climateSettings.temperature, 0.0f, 1.0f);
        double d1 = Mth.clamp(this.climateSettings.downfall, 0.0f, 1.0f);
        return FoliageColor.get(d0, d1);
    }

    public final float getDownfall() {
        return this.climateSettings.downfall;
    }

    public final float getBaseTemperature() {
        return this.climateSettings.temperature;
    }

    public BiomeSpecialEffects getSpecialEffects() {
        return this.specialEffects;
    }

    public final int getWaterColor() {
        return this.specialEffects.getWaterColor();
    }

    public final int getWaterFogColor() {
        return this.specialEffects.getWaterFogColor();
    }

    public Optional<AmbientParticleSettings> getAmbientParticle() {
        return this.specialEffects.getAmbientParticleSettings();
    }

    public Optional<SoundEvent> getAmbientLoop() {
        return this.specialEffects.getAmbientLoopSoundEvent();
    }

    public Optional<AmbientMoodSettings> getAmbientMood() {
        return this.specialEffects.getAmbientMoodSettings();
    }

    public Optional<AmbientAdditionsSettings> getAmbientAdditions() {
        return this.specialEffects.getAmbientAdditionsSettings();
    }

    public Optional<Music> getBackgroundMusic() {
        return this.specialEffects.getBackgroundMusic();
    }

    BiomeCategory getBiomeCategory() {
        return this.biomeCategory;
    }

    @Deprecated
    public static BiomeCategory getBiomeCategory(Holder<Biome> p_204184_) {
        return p_204184_.value().getBiomeCategory();
    }

    public static class BiomeBuilder {
        @Nullable
        private Precipitation precipitation;
        @Nullable
        private BiomeCategory biomeCategory;
        @Nullable
        private Float temperature;
        private TemperatureModifier temperatureModifier = TemperatureModifier.NONE;
        @Nullable
        private Float downfall;
        @Nullable
        private BiomeSpecialEffects specialEffects;
        @Nullable
        private MobSpawnSettings mobSpawnSettings;
        @Nullable
        private BiomeGenerationSettings generationSettings;

        public static BiomeBuilder from(Biome p_204186_) {
            return new BiomeBuilder().precipitation(p_204186_.getPrecipitation()).biomeCategory(p_204186_.getBiomeCategory()).temperature(p_204186_.getBaseTemperature()).downfall(p_204186_.getDownfall()).specialEffects(p_204186_.getSpecialEffects()).generationSettings(p_204186_.getGenerationSettings()).mobSpawnSettings(p_204186_.getMobSettings());
        }

        public BiomeBuilder precipitation(Precipitation pPrecipitation) {
            this.precipitation = pPrecipitation;
            return this;
        }

        public BiomeBuilder biomeCategory(BiomeCategory pBiomeCategory) {
            this.biomeCategory = pBiomeCategory;
            return this;
        }

        public BiomeBuilder temperature(float pTemperature) {
            this.temperature = Float.valueOf(pTemperature);
            return this;
        }

        public BiomeBuilder downfall(float pDownfall) {
            this.downfall = Float.valueOf(pDownfall);
            return this;
        }

        public BiomeBuilder specialEffects(BiomeSpecialEffects pEffects) {
            this.specialEffects = pEffects;
            return this;
        }

        public BiomeBuilder mobSpawnSettings(MobSpawnSettings pMobSpawnSettings) {
            this.mobSpawnSettings = pMobSpawnSettings;
            return this;
        }

        public BiomeBuilder generationSettings(BiomeGenerationSettings pGenerationSettings) {
            this.generationSettings = pGenerationSettings;
            return this;
        }

        public BiomeBuilder temperatureAdjustment(TemperatureModifier pTemperatureSettings) {
            this.temperatureModifier = pTemperatureSettings;
            return this;
        }

        public Biome build() {
            if (this.precipitation != null && this.biomeCategory != null && this.temperature != null && this.downfall != null && this.specialEffects != null && this.mobSpawnSettings != null && this.generationSettings != null) {
                return new Biome(new ClimateSettings(this.precipitation, this.temperature.floatValue(), this.temperatureModifier, this.downfall.floatValue()), this.biomeCategory, this.specialEffects, this.generationSettings, this.mobSpawnSettings);
            }
            throw new IllegalStateException("You are missing parameters to build a proper biome\n" + this);
        }

        public String toString() {
            return "BiomeBuilder{\nprecipitation=" + this.precipitation + ",\nbiomeCategory=" + this.biomeCategory + ",\ntemperature=" + this.temperature + ",\ntemperatureModifier=" + this.temperatureModifier + ",\ndownfall=" + this.downfall + ",\nspecialEffects=" + this.specialEffects + ",\nmobSpawnSettings=" + this.mobSpawnSettings + ",\ngenerationSettings=" + this.generationSettings + ",\n}";
        }
    }

    public static enum BiomeCategory implements StringRepresentable
    {
        NONE("none"),
        TAIGA("taiga"),
        EXTREME_HILLS("extreme_hills"),
        JUNGLE("jungle"),
        MESA("mesa"),
        PLAINS("plains"),
        SAVANNA("savanna"),
        ICY("icy"),
        THEEND("the_end"),
        BEACH("beach"),
        FOREST("forest"),
        OCEAN("ocean"),
        DESERT("desert"),
        RIVER("river"),
        SWAMP("swamp"),
        MUSHROOM("mushroom"),
        NETHER("nether"),
        UNDERGROUND("underground"),
        MOUNTAIN("mountain");

        public static final Codec<BiomeCategory> CODEC;
        private static final Map<String, BiomeCategory> BY_NAME;
        private final String name;

        static {
            CODEC = StringRepresentable.fromEnum(BiomeCategory::values, BiomeCategory::byName);
            BY_NAME = Arrays.stream(BiomeCategory.values()).collect(Collectors.toMap(BiomeCategory::getName, p_47642_ -> p_47642_));
        }

        private BiomeCategory(String p_47639_) {
            this.name = p_47639_;
        }

        public String getName() {
            return this.name;
        }

        public static BiomeCategory byName(String p_47644_) {
            return BY_NAME.get(p_47644_);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }
    }

    static class ClimateSettings {
        public static final MapCodec<ClimateSettings> CODEC = RecordCodecBuilder.mapCodec(p_47699_ -> p_47699_.group((App)Precipitation.CODEC.fieldOf("precipitation").forGetter(p_151739_ -> p_151739_.precipitation), (App)Codec.FLOAT.fieldOf("temperature").forGetter(p_151737_ -> Float.valueOf(p_151737_.temperature)), (App)TemperatureModifier.CODEC.optionalFieldOf("temperature_modifier", (Object)TemperatureModifier.NONE).forGetter(p_151735_ -> p_151735_.temperatureModifier), (App)Codec.FLOAT.fieldOf("downfall").forGetter(p_151733_ -> Float.valueOf(p_151733_.downfall))).apply((Applicative)p_47699_, ClimateSettings::new));
        final Precipitation precipitation;
        final float temperature;
        final TemperatureModifier temperatureModifier;
        final float downfall;

        ClimateSettings(Precipitation p_47686_, float p_47687_, TemperatureModifier p_47688_, float p_47689_) {
            this.precipitation = p_47686_;
            this.temperature = p_47687_;
            this.temperatureModifier = p_47688_;
            this.downfall = p_47689_;
        }
    }

    public static enum Precipitation implements StringRepresentable
    {
        NONE("none"),
        RAIN("rain"),
        SNOW("snow");

        public static final Codec<Precipitation> CODEC;
        private static final Map<String, Precipitation> BY_NAME;
        private final String name;

        static {
            CODEC = StringRepresentable.fromEnum(Precipitation::values, Precipitation::byName);
            BY_NAME = Arrays.stream(Precipitation.values()).collect(Collectors.toMap(Precipitation::getName, p_47728_ -> p_47728_));
        }

        private Precipitation(String p_47725_) {
            this.name = p_47725_;
        }

        public String getName() {
            return this.name;
        }

        public static Precipitation byName(String p_47730_) {
            return BY_NAME.get(p_47730_);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TemperatureModifier implements StringRepresentable
    {
        NONE("none"){

            @Override
            public float modifyTemperature(BlockPos p_47767_, float p_47768_) {
                return p_47768_;
            }
        }
        ,
        FROZEN("frozen"){

            @Override
            public float modifyTemperature(BlockPos p_47774_, float p_47775_) {
                double d3;
                double d1;
                double d0 = FROZEN_TEMPERATURE_NOISE.getValue((double)p_47774_.getX() * 0.05, (double)p_47774_.getZ() * 0.05, false) * 7.0;
                double d2 = d0 + (d1 = BIOME_INFO_NOISE.getValue((double)p_47774_.getX() * 0.2, (double)p_47774_.getZ() * 0.2, false));
                if (d2 < 0.3 && (d3 = BIOME_INFO_NOISE.getValue((double)p_47774_.getX() * 0.09, (double)p_47774_.getZ() * 0.09, false)) < 0.8) {
                    return 0.2f;
                }
                return p_47775_;
            }
        };

        private final String name;
        public static final Codec<TemperatureModifier> CODEC;
        private static final Map<String, TemperatureModifier> BY_NAME;

        static {
            CODEC = StringRepresentable.fromEnum(TemperatureModifier::values, TemperatureModifier::byName);
            BY_NAME = Arrays.stream(TemperatureModifier.values()).collect(Collectors.toMap(TemperatureModifier::getName, p_47753_ -> p_47753_));
        }

        public abstract float modifyTemperature(BlockPos var1, float var2);

        private TemperatureModifier(String p_47745_) {
            this.name = p_47745_;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public static TemperatureModifier byName(String p_47757_) {
            return BY_NAME.get(p_47757_);
        }
    }
}

