/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.hash.Hashing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;

public class BiomeManager {
    public static final int CHUNK_CENTER_QUART = QuartPos.fromBlock(8);
    private static final int ZOOM_BITS = 2;
    private static final int ZOOM = 4;
    private static final int ZOOM_MASK = 3;
    private final NoiseBiomeSource noiseBiomeSource;
    private final long biomeZoomSeed;

    public BiomeManager(NoiseBiomeSource p_186677_, long p_186678_) {
        this.noiseBiomeSource = p_186677_;
        this.biomeZoomSeed = p_186678_;
    }

    public static long obfuscateSeed(long pSeed) {
        return Hashing.sha256().hashLong(pSeed).asLong();
    }

    public BiomeManager withDifferentSource(NoiseBiomeSource p_186688_) {
        return new BiomeManager(p_186688_, this.biomeZoomSeed);
    }

    public Holder<Biome> getBiome(BlockPos pPos) {
        int i = pPos.getX() - 2;
        int j = pPos.getY() - 2;
        int k = pPos.getZ() - 2;
        int l = i >> 2;
        int i1 = j >> 2;
        int j1 = k >> 2;
        double d0 = (double)(i & 3) / 4.0;
        double d1 = (double)(j & 3) / 4.0;
        double d2 = (double)(k & 3) / 4.0;
        int k1 = 0;
        double d3 = Double.POSITIVE_INFINITY;
        int l1 = 0;
        while (l1 < 8) {
            double d6;
            double d5;
            double d4;
            boolean flag2;
            int k2;
            boolean flag1;
            int j2;
            boolean flag = (l1 & 4) == 0;
            int i2 = flag ? l : l + 1;
            double d7 = BiomeManager.getFiddledDistance(this.biomeZoomSeed, i2, j2 = (flag1 = (l1 & 2) == 0) ? i1 : i1 + 1, k2 = (flag2 = (l1 & 1) == 0) ? j1 : j1 + 1, d4 = flag ? d0 : d0 - 1.0, d5 = flag1 ? d1 : d1 - 1.0, d6 = flag2 ? d2 : d2 - 1.0);
            if (d3 > d7) {
                k1 = l1;
                d3 = d7;
            }
            ++l1;
        }
        int l2 = (k1 & 4) == 0 ? l : l + 1;
        int i3 = (k1 & 2) == 0 ? i1 : i1 + 1;
        int j3 = (k1 & 1) == 0 ? j1 : j1 + 1;
        return this.noiseBiomeSource.getNoiseBiome(l2, i3, j3);
    }

    public Holder<Biome> getNoiseBiomeAtPosition(double pX, double p_204208_, double pY) {
        int i = QuartPos.fromBlock(Mth.floor(pX));
        int j = QuartPos.fromBlock(Mth.floor(p_204208_));
        int k = QuartPos.fromBlock(Mth.floor(pY));
        return this.getNoiseBiomeAtQuart(i, j, k);
    }

    public Holder<Biome> getNoiseBiomeAtPosition(BlockPos pPos) {
        int i = QuartPos.fromBlock(pPos.getX());
        int j = QuartPos.fromBlock(pPos.getY());
        int k = QuartPos.fromBlock(pPos.getZ());
        return this.getNoiseBiomeAtQuart(i, j, k);
    }

    public Holder<Biome> getNoiseBiomeAtQuart(int pX, int pY, int pZ) {
        return this.noiseBiomeSource.getNoiseBiome(pX, pY, pZ);
    }

    private static double getFiddledDistance(long p_186680_, int p_186681_, int p_186682_, int p_186683_, double p_186684_, double p_186685_, double p_186686_) {
        long $$7 = LinearCongruentialGenerator.next(p_186680_, p_186681_);
        $$7 = LinearCongruentialGenerator.next($$7, p_186682_);
        $$7 = LinearCongruentialGenerator.next($$7, p_186683_);
        $$7 = LinearCongruentialGenerator.next($$7, p_186681_);
        $$7 = LinearCongruentialGenerator.next($$7, p_186682_);
        $$7 = LinearCongruentialGenerator.next($$7, p_186683_);
        double d0 = BiomeManager.getFiddle($$7);
        $$7 = LinearCongruentialGenerator.next($$7, p_186680_);
        double d1 = BiomeManager.getFiddle($$7);
        $$7 = LinearCongruentialGenerator.next($$7, p_186680_);
        double d2 = BiomeManager.getFiddle($$7);
        return Mth.square(p_186686_ + d2) + Mth.square(p_186685_ + d1) + Mth.square(p_186684_ + d0);
    }

    private static double getFiddle(long p_186690_) {
        double d0 = (double)Math.floorMod(p_186690_ >> 24, 1024) / 1024.0;
        return (d0 - 0.5) * 0.9;
    }

    public static interface NoiseBiomeSource {
        public Holder<Biome> getNoiseBiome(int var1, int var2, int var3);
    }
}

