/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import org.slf4j.Logger;

public class MobSpawnSettings {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float DEFAULT_CREATURE_SPAWN_PROBABILITY = 0.1f;
    public static final WeightedRandomList<SpawnerData> EMPTY_MOB_LIST = WeightedRandomList.create();
    public static final MobSpawnSettings EMPTY = new Builder().build();
    public static final MapCodec<MobSpawnSettings> CODEC = RecordCodecBuilder.mapCodec(p_187051_ -> p_187051_.group((App)Codec.floatRange((float)0.0f, (float)0.9999999f).optionalFieldOf("creature_spawn_probability", (Object)Float.valueOf(0.1f)).forGetter(p_187055_ -> Float.valueOf(p_187055_.creatureGenerationProbability)), (App)Codec.simpleMap(MobCategory.CODEC, (Codec)WeightedRandomList.codec(SpawnerData.CODEC).promotePartial(Util.prefix("Spawn data: ", arg_0 -> ((Logger)LOGGER).error(arg_0))), (Keyable)StringRepresentable.a(MobCategory.values())).fieldOf("spawners").forGetter(p_187053_ -> p_187053_.spawners), (App)Codec.simpleMap(Registry.ENTITY_TYPE.byNameCodec(), MobSpawnCost.CODEC, Registry.ENTITY_TYPE).fieldOf("spawn_costs").forGetter(p_187049_ -> p_187049_.mobSpawnCosts)).apply((Applicative)p_187051_, MobSpawnSettings::new));
    private final float creatureGenerationProbability;
    private final Map<MobCategory, WeightedRandomList<SpawnerData>> spawners;
    private final Map<EntityType<?>, MobSpawnCost> mobSpawnCosts;

    MobSpawnSettings(float p_196689_, Map<MobCategory, WeightedRandomList<SpawnerData>> p_196690_, Map<EntityType<?>, MobSpawnCost> p_196691_) {
        this.creatureGenerationProbability = p_196689_;
        this.spawners = ImmutableMap.copyOf(p_196690_);
        this.mobSpawnCosts = ImmutableMap.copyOf(p_196691_);
    }

    public WeightedRandomList<SpawnerData> getMobs(MobCategory pCategory) {
        return this.spawners.getOrDefault(pCategory, EMPTY_MOB_LIST);
    }

    @Nullable
    public MobSpawnCost getMobSpawnCost(EntityType<?> pEntityType) {
        return this.mobSpawnCosts.get(pEntityType);
    }

    public float getCreatureProbability() {
        return this.creatureGenerationProbability;
    }

    public static class Builder {
        private final Map<MobCategory, List<SpawnerData>> spawners = (Map)Stream.of(MobCategory.values()).collect(ImmutableMap.toImmutableMap(p_48383_ -> p_48383_, p_48375_ -> Lists.newArrayList()));
        private final Map<EntityType<?>, MobSpawnCost> mobSpawnCosts = Maps.newLinkedHashMap();
        private float creatureGenerationProbability = 0.1f;

        public Builder addSpawn(MobCategory pClassification, SpawnerData pSpawner) {
            this.spawners.get(pClassification).add(pSpawner);
            return this;
        }

        public Builder addMobCharge(EntityType<?> pEntityType, double pSpawnCostPerEntity, double p_48373_) {
            this.mobSpawnCosts.put(pEntityType, new MobSpawnCost(p_48373_, pSpawnCostPerEntity));
            return this;
        }

        public Builder creatureGenerationProbability(float pProbability) {
            this.creatureGenerationProbability = pProbability;
            return this;
        }

        public MobSpawnSettings build() {
            return new MobSpawnSettings(this.creatureGenerationProbability, (Map)this.spawners.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_151809_ -> WeightedRandomList.create((List)p_151809_.getValue()))), (Map<EntityType<?>, MobSpawnCost>)ImmutableMap.copyOf(this.mobSpawnCosts));
        }
    }

    public static class MobSpawnCost {
        public static final Codec<MobSpawnCost> CODEC = RecordCodecBuilder.create(p_48399_ -> p_48399_.group((App)Codec.DOUBLE.fieldOf("energy_budget").forGetter(p_151813_ -> p_151813_.energyBudget), (App)Codec.DOUBLE.fieldOf("charge").forGetter(p_151811_ -> p_151811_.charge)).apply((Applicative)p_48399_, MobSpawnCost::new));
        private final double energyBudget;
        private final double charge;

        MobSpawnCost(double p_48389_, double p_48390_) {
            this.energyBudget = p_48389_;
            this.charge = p_48390_;
        }

        public double getEnergyBudget() {
            return this.energyBudget;
        }

        public double getCharge() {
            return this.charge;
        }
    }

    public static class SpawnerData
    extends WeightedEntry.IntrusiveBase {
        public static final Codec<SpawnerData> CODEC = RecordCodecBuilder.create(p_151822_ -> p_151822_.group((App)Registry.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(p_151826_ -> p_151826_.type), (App)Weight.CODEC.fieldOf("weight").forGetter(WeightedEntry.IntrusiveBase::getWeight), (App)Codec.INT.fieldOf("minCount").forGetter(p_151824_ -> p_151824_.minCount), (App)Codec.INT.fieldOf("maxCount").forGetter(p_151820_ -> p_151820_.maxCount)).apply((Applicative)p_151822_, SpawnerData::new));
        public final EntityType<?> type;
        public final int minCount;
        public final int maxCount;

        public SpawnerData(EntityType<?> pType, int pWeight, int pMinCount, int pMaxCount) {
            this(pType, Weight.of(pWeight), pMinCount, pMaxCount);
        }

        public SpawnerData(EntityType<?> pType, Weight pWeight, int pMinCount, int pMaxCount) {
            super(pWeight);
            this.type = pType.getCategory() == MobCategory.MISC ? EntityType.PIG : pType;
            this.minCount = pMinCount;
            this.maxCount = pMaxCount;
        }

        public String toString() {
            return EntityType.getKey(this.type) + "*(" + this.minCount + "-" + this.maxCount + "):" + this.getWeight();
        }
    }
}

