/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.VisibleForTesting;

public record TerrainShaper(CubicSpline<Point> offsetSampler, CubicSpline<Point> factorSampler, CubicSpline<Point> jaggednessSampler) {
    private static final Codec<CubicSpline<Point>> SPLINE_CODEC = CubicSpline.codec(Coordinate.WIDE_CODEC);
    public static final Codec<CubicSpline<PointCustom>> SPLINE_CUSTOM_CODEC = CubicSpline.codec(CoordinateCustom.WIDE_CODEC);
    public static final Codec<TerrainShaper> CODEC = RecordCodecBuilder.create(p_187316_ -> p_187316_.group((App)SPLINE_CODEC.fieldOf("offset").forGetter(TerrainShaper::offsetSampler), (App)SPLINE_CODEC.fieldOf("factor").forGetter(TerrainShaper::factorSampler), (App)SPLINE_CODEC.fieldOf("jaggedness").forGetter(p_187314_ -> p_187314_.jaggednessSampler)).apply((Applicative)p_187316_, TerrainShaper::new));
    private static final float GLOBAL_OFFSET = -0.50375f;
    private static final ToFloatFunction<Float> NO_TRANSFORM = p_187318_ -> p_187318_.floatValue();

    private static float getAmplifiedOffset(float p_187325_) {
        return p_187325_ < 0.0f ? p_187325_ : p_187325_ * 2.0f;
    }

    private static float getAmplifiedFactor(float p_187338_) {
        return 1.25f - 6.25f / (p_187338_ + 5.0f);
    }

    private static float getAmplifiedJaggedness(float p_187342_) {
        return p_187342_ * 2.0f;
    }

    public static TerrainShaper overworld(boolean p_187322_) {
        ToFloatFunction<Float> tofloatfunction = p_187322_ ? TerrainShaper::getAmplifiedOffset : NO_TRANSFORM;
        ToFloatFunction<Float> tofloatfunction1 = p_187322_ ? TerrainShaper::getAmplifiedFactor : NO_TRANSFORM;
        ToFloatFunction<Float> tofloatfunction2 = p_187322_ ? TerrainShaper::getAmplifiedJaggedness : NO_TRANSFORM;
        CubicSpline<Point> cubicspline = TerrainShaper.buildErosionOffsetSpline(-0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, tofloatfunction);
        CubicSpline<Point> cubicspline1 = TerrainShaper.buildErosionOffsetSpline(-0.1f, 0.03f, 0.1f, 0.1f, 0.01f, -0.03f, false, false, tofloatfunction);
        CubicSpline<Point> cubicspline2 = TerrainShaper.buildErosionOffsetSpline(-0.1f, 0.03f, 0.1f, 0.7f, 0.01f, -0.03f, true, true, tofloatfunction);
        CubicSpline<Point> cubicspline3 = TerrainShaper.buildErosionOffsetSpline(-0.05f, 0.03f, 0.1f, 1.0f, 0.01f, 0.01f, true, true, tofloatfunction);
        float f = -0.51f;
        float f1 = -0.4f;
        float f2 = 0.1f;
        float f3 = -0.15f;
        CubicSpline<Point> cubicspline4 = CubicSpline.builder(Coordinate.CONTINENTS, tofloatfunction).addPoint(-1.1f, 0.044f, 0.0f).addPoint(-1.02f, -0.2222f, 0.0f).addPoint(-0.51f, -0.2222f, 0.0f).addPoint(-0.44f, -0.12f, 0.0f).addPoint(-0.18f, -0.12f, 0.0f).addPoint(-0.16f, cubicspline, 0.0f).addPoint(-0.15f, cubicspline, 0.0f).addPoint(-0.1f, cubicspline1, 0.0f).addPoint(0.25f, cubicspline2, 0.0f).addPoint(1.0f, cubicspline3, 0.0f).build();
        CubicSpline<Point> cubicspline5 = CubicSpline.builder(Coordinate.CONTINENTS, NO_TRANSFORM).addPoint(-0.19f, 3.95f, 0.0f).addPoint(-0.15f, TerrainShaper.getErosionFactor(6.25f, true, NO_TRANSFORM), 0.0f).addPoint(-0.1f, TerrainShaper.getErosionFactor(5.47f, true, tofloatfunction1), 0.0f).addPoint(0.03f, TerrainShaper.getErosionFactor(5.08f, true, tofloatfunction1), 0.0f).addPoint(0.06f, TerrainShaper.getErosionFactor(4.69f, false, tofloatfunction1), 0.0f).build();
        float f4 = 0.65f;
        CubicSpline<Point> cubicspline6 = CubicSpline.builder(Coordinate.CONTINENTS, tofloatfunction2).addPoint(-0.11f, 0.0f, 0.0f).addPoint(0.03f, TerrainShaper.buildErosionJaggednessSpline(1.0f, 0.5f, 0.0f, 0.0f, tofloatfunction2), 0.0f).addPoint(0.65f, TerrainShaper.buildErosionJaggednessSpline(1.0f, 1.0f, 1.0f, 0.0f, tofloatfunction2), 0.0f).build();
        return new TerrainShaper(cubicspline4, cubicspline5, cubicspline6);
    }

    private static CubicSpline<Point> buildErosionJaggednessSpline(float p_187295_, float p_187296_, float p_187297_, float p_187298_, ToFloatFunction<Float> p_187299_) {
        float f = -0.5775f;
        CubicSpline<Point> cubicspline = TerrainShaper.buildRidgeJaggednessSpline(p_187295_, p_187297_, p_187299_);
        CubicSpline<Point> cubicspline1 = TerrainShaper.buildRidgeJaggednessSpline(p_187296_, p_187298_, p_187299_);
        return CubicSpline.builder(Coordinate.EROSION, p_187299_).addPoint(-1.0f, cubicspline, 0.0f).addPoint(-0.78f, cubicspline1, 0.0f).addPoint(-0.5775f, cubicspline1, 0.0f).addPoint(-0.375f, 0.0f, 0.0f).build();
    }

    private static CubicSpline<Point> buildRidgeJaggednessSpline(float p_187301_, float p_187302_, ToFloatFunction<Float> p_187303_) {
        float f = TerrainShaper.peaksAndValleys(0.4f);
        float f1 = TerrainShaper.peaksAndValleys(0.56666666f);
        float f2 = (f + f1) / 2.0f;
        CubicSpline.Builder<Point> builder = CubicSpline.builder(Coordinate.RIDGES, p_187303_);
        builder.addPoint(f, 0.0f, 0.0f);
        if (p_187302_ > 0.0f) {
            builder.addPoint(f2, TerrainShaper.buildWeirdnessJaggednessSpline(p_187302_, p_187303_), 0.0f);
        } else {
            builder.addPoint(f2, 0.0f, 0.0f);
        }
        if (p_187301_ > 0.0f) {
            builder.addPoint(1.0f, TerrainShaper.buildWeirdnessJaggednessSpline(p_187301_, p_187303_), 0.0f);
        } else {
            builder.addPoint(1.0f, 0.0f, 0.0f);
        }
        return builder.build();
    }

    private static CubicSpline<Point> buildWeirdnessJaggednessSpline(float p_187305_, ToFloatFunction<Float> p_187306_) {
        float f = 0.63f * p_187305_;
        float f1 = 0.3f * p_187305_;
        return CubicSpline.builder(Coordinate.WEIRDNESS, p_187306_).addPoint(-0.01f, f, 0.0f).addPoint(0.01f, f1, 0.0f).build();
    }

    private static CubicSpline<Point> getErosionFactor(float p_187308_, boolean p_187309_, ToFloatFunction<Float> p_187310_) {
        CubicSpline<Point> cubicspline = CubicSpline.builder(Coordinate.WEIRDNESS, p_187310_).addPoint(-0.2f, 6.3f, 0.0f).addPoint(0.2f, p_187308_, 0.0f).build();
        CubicSpline.Builder<Point> builder = CubicSpline.builder(Coordinate.EROSION, p_187310_).addPoint(-0.6f, cubicspline, 0.0f).addPoint(-0.5f, CubicSpline.builder(Coordinate.WEIRDNESS, p_187310_).addPoint(-0.05f, 6.3f, 0.0f).addPoint(0.05f, 2.67f, 0.0f).build(), 0.0f).addPoint(-0.35f, cubicspline, 0.0f).addPoint(-0.25f, cubicspline, 0.0f).addPoint(-0.1f, CubicSpline.builder(Coordinate.WEIRDNESS, p_187310_).addPoint(-0.05f, 2.67f, 0.0f).addPoint(0.05f, 6.3f, 0.0f).build(), 0.0f).addPoint(0.03f, cubicspline, 0.0f);
        if (p_187309_) {
            CubicSpline<Point> cubicspline1 = CubicSpline.builder(Coordinate.WEIRDNESS, p_187310_).addPoint(0.0f, p_187308_, 0.0f).addPoint(0.1f, 0.625f, 0.0f).build();
            CubicSpline<Point> cubicspline2 = CubicSpline.builder(Coordinate.RIDGES, p_187310_).addPoint(-0.9f, p_187308_, 0.0f).addPoint(-0.69f, cubicspline1, 0.0f).build();
            builder.addPoint(0.35f, p_187308_, 0.0f).addPoint(0.45f, cubicspline2, 0.0f).addPoint(0.55f, cubicspline2, 0.0f).addPoint(0.62f, p_187308_, 0.0f);
        } else {
            CubicSpline<Point> cubicspline3 = CubicSpline.builder(Coordinate.RIDGES, p_187310_).addPoint(-0.7f, cubicspline, 0.0f).addPoint(-0.15f, 1.37f, 0.0f).build();
            CubicSpline<Point> cubicspline4 = CubicSpline.builder(Coordinate.RIDGES, p_187310_).addPoint(0.45f, cubicspline, 0.0f).addPoint(0.7f, 1.56f, 0.0f).build();
            builder.addPoint(0.05f, cubicspline4, 0.0f).addPoint(0.4f, cubicspline4, 0.0f).addPoint(0.45f, cubicspline3, 0.0f).addPoint(0.55f, cubicspline3, 0.0f).addPoint(0.58f, p_187308_, 0.0f);
        }
        return builder.build();
    }

    private static float calculateSlope(float p_187272_, float p_187273_, float p_187274_, float p_187275_) {
        return (p_187273_ - p_187272_) / (p_187275_ - p_187274_);
    }

    private static CubicSpline<Point> buildMountainRidgeSplineWithPoints(float p_187331_, boolean p_187332_, ToFloatFunction<Float> p_187333_) {
        CubicSpline.Builder<Point> builder = CubicSpline.builder(Coordinate.RIDGES, p_187333_);
        float f = -0.7f;
        float f1 = -1.0f;
        float f2 = TerrainShaper.mountainContinentalness(-1.0f, p_187331_, -0.7f);
        float f3 = 1.0f;
        float f4 = TerrainShaper.mountainContinentalness(1.0f, p_187331_, -0.7f);
        float f5 = TerrainShaper.calculateMountainRidgeZeroContinentalnessPoint(p_187331_);
        float f6 = -0.65f;
        if (-0.65f < f5 && f5 < 1.0f) {
            float f14 = TerrainShaper.mountainContinentalness(-0.65f, p_187331_, -0.7f);
            float f8 = -0.75f;
            float f9 = TerrainShaper.mountainContinentalness(-0.75f, p_187331_, -0.7f);
            float f10 = TerrainShaper.calculateSlope(f2, f9, -1.0f, -0.75f);
            builder.addPoint(-1.0f, f2, f10);
            builder.addPoint(-0.75f, f9, 0.0f);
            builder.addPoint(-0.65f, f14, 0.0f);
            float f11 = TerrainShaper.mountainContinentalness(f5, p_187331_, -0.7f);
            float f12 = TerrainShaper.calculateSlope(f11, f4, f5, 1.0f);
            float f13 = 0.01f;
            builder.addPoint(f5 - 0.01f, f11, 0.0f);
            builder.addPoint(f5, f11, f12);
            builder.addPoint(1.0f, f4, f12);
        } else {
            float f7 = TerrainShaper.calculateSlope(f2, f4, -1.0f, 1.0f);
            if (p_187332_) {
                builder.addPoint(-1.0f, Math.max(0.2f, f2), 0.0f);
                builder.addPoint(0.0f, Mth.lerp(0.5f, f2, f4), f7);
            } else {
                builder.addPoint(-1.0f, f2, f7);
            }
            builder.addPoint(1.0f, f4, f7);
        }
        return builder.build();
    }

    private static float mountainContinentalness(float p_187327_, float p_187328_, float p_187329_) {
        float f = 1.17f;
        float f1 = 0.46082947f;
        float f2 = 1.0f - (1.0f - p_187328_) * 0.5f;
        float f3 = 0.5f * (1.0f - p_187328_);
        float f4 = (p_187327_ + 1.17f) * 0.46082947f;
        float f5 = f4 * f2 - f3;
        return p_187327_ < p_187329_ ? Math.max(f5, -0.2222f) : Math.max(f5, 0.0f);
    }

    private static float calculateMountainRidgeZeroContinentalnessPoint(float p_187344_) {
        float f = 1.17f;
        float f1 = 0.46082947f;
        float f2 = 1.0f - (1.0f - p_187344_) * 0.5f;
        float f3 = 0.5f * (1.0f - p_187344_);
        return f3 / (0.46082947f * f2) - 1.17f;
    }

    private static CubicSpline<Point> buildErosionOffsetSpline(float p_187285_, float p_187286_, float p_187287_, float p_187288_, float p_187289_, float p_187290_, boolean p_187291_, boolean p_187292_, ToFloatFunction<Float> p_187293_) {
        float f = 0.6f;
        float f1 = 0.5f;
        float f2 = 0.5f;
        CubicSpline<Point> cubicspline = TerrainShaper.buildMountainRidgeSplineWithPoints(Mth.lerp(p_187288_, 0.6f, 1.5f), p_187292_, p_187293_);
        CubicSpline<Point> cubicspline1 = TerrainShaper.buildMountainRidgeSplineWithPoints(Mth.lerp(p_187288_, 0.6f, 1.0f), p_187292_, p_187293_);
        CubicSpline<Point> cubicspline2 = TerrainShaper.buildMountainRidgeSplineWithPoints(p_187288_, p_187292_, p_187293_);
        CubicSpline<Point> cubicspline3 = TerrainShaper.ridgeSpline(p_187285_ - 0.15f, 0.5f * p_187288_, Mth.lerp(0.5f, 0.5f, 0.5f) * p_187288_, 0.5f * p_187288_, 0.6f * p_187288_, 0.5f, p_187293_);
        CubicSpline<Point> cubicspline4 = TerrainShaper.ridgeSpline(p_187285_, p_187289_ * p_187288_, p_187286_ * p_187288_, 0.5f * p_187288_, 0.6f * p_187288_, 0.5f, p_187293_);
        CubicSpline<Point> cubicspline5 = TerrainShaper.ridgeSpline(p_187285_, p_187289_, p_187289_, p_187286_, p_187287_, 0.5f, p_187293_);
        CubicSpline<Point> cubicspline6 = TerrainShaper.ridgeSpline(p_187285_, p_187289_, p_187289_, p_187286_, p_187287_, 0.5f, p_187293_);
        CubicSpline<Point> cubicspline7 = CubicSpline.builder(Coordinate.RIDGES, p_187293_).addPoint(-1.0f, p_187285_, 0.0f).addPoint(-0.4f, cubicspline5, 0.0f).addPoint(0.0f, p_187287_ + 0.07f, 0.0f).build();
        CubicSpline<Point> cubicspline8 = TerrainShaper.ridgeSpline(-0.02f, p_187290_, p_187290_, p_187286_, p_187287_, 0.0f, p_187293_);
        CubicSpline.Builder<Point> builder = CubicSpline.builder(Coordinate.EROSION, p_187293_).addPoint(-0.85f, cubicspline, 0.0f).addPoint(-0.7f, cubicspline1, 0.0f).addPoint(-0.4f, cubicspline2, 0.0f).addPoint(-0.35f, cubicspline3, 0.0f).addPoint(-0.1f, cubicspline4, 0.0f).addPoint(0.2f, cubicspline5, 0.0f);
        if (p_187291_) {
            builder.addPoint(0.4f, cubicspline6, 0.0f).addPoint(0.45f, cubicspline7, 0.0f).addPoint(0.55f, cubicspline7, 0.0f).addPoint(0.58f, cubicspline6, 0.0f);
        }
        builder.addPoint(0.7f, cubicspline8, 0.0f);
        return builder.build();
    }

    private static CubicSpline<Point> ridgeSpline(float p_187277_, float p_187278_, float p_187279_, float p_187280_, float p_187281_, float p_187282_, ToFloatFunction<Float> p_187283_) {
        float f = Math.max(0.5f * (p_187278_ - p_187277_), p_187282_);
        float f1 = 5.0f * (p_187279_ - p_187278_);
        return CubicSpline.builder(Coordinate.RIDGES, p_187283_).addPoint(-1.0f, p_187277_, f).addPoint(-0.4f, p_187278_, Math.min(f, f1)).addPoint(0.0f, p_187279_, f1).addPoint(0.4f, p_187280_, 2.0f * (p_187280_ - p_187279_)).addPoint(1.0f, p_187281_, 0.7f * (p_187281_ - p_187280_)).build();
    }

    public void addDebugBiomesToVisualizeSplinePoints(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187320_) {
        Climate.Parameter climate$parameter = Climate.Parameter.span(-1.0f, 1.0f);
        p_187320_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters(climate$parameter, climate$parameter, climate$parameter, climate$parameter, Climate.Parameter.point(0.0f), climate$parameter, 0.01f), Biomes.PLAINS));
        CubicSpline.Multipoint multipoint = (CubicSpline.Multipoint)TerrainShaper.buildErosionOffsetSpline(-0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, NO_TRANSFORM);
        ResourceKey<Biome> resourcekey = Biomes.DESERT;
        float[] afloat = multipoint.locations();
        int i = afloat.length;
        int j = 0;
        while (j < i) {
            Float f = Float.valueOf(afloat[j]);
            p_187320_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters(climate$parameter, climate$parameter, climate$parameter, Climate.Parameter.point(f.floatValue()), Climate.Parameter.point(0.0f), climate$parameter, 0.0f), resourcekey));
            resourcekey = resourcekey == Biomes.DESERT ? Biomes.BADLANDS : Biomes.DESERT;
            ++j;
        }
        afloat = ((CubicSpline.Multipoint)this.offsetSampler).locations();
        i = afloat.length;
        int k = 0;
        while (k < i) {
            Float f1 = Float.valueOf(afloat[k]);
            p_187320_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters(climate$parameter, climate$parameter, Climate.Parameter.point(f1.floatValue()), climate$parameter, Climate.Parameter.point(0.0f), climate$parameter, 0.0f), Biomes.SNOWY_TAIGA));
            ++k;
        }
    }

    public float offset(Point p_187312_) {
        return this.offsetSampler.apply(p_187312_) + -0.50375f;
    }

    public float factor(Point p_187335_) {
        return this.factorSampler.apply(p_187335_);
    }

    public float jaggedness(Point p_187340_) {
        return this.jaggednessSampler.apply(p_187340_);
    }

    public static Point makePoint(float p_187268_, float p_187269_, float p_187270_) {
        return new Point(p_187268_, p_187269_, TerrainShaper.peaksAndValleys(p_187270_), p_187270_);
    }

    public static PointCustom makePoint(DensityFunction.FunctionContext p_211600_) {
        return new PointCustom(p_211600_);
    }

    public static float peaksAndValleys(float p_187266_) {
        return -(Math.abs(Math.abs(p_187266_) - 0.6666667f) - 0.33333334f) * 3.0f;
    }

    @VisibleForTesting
    protected static enum Coordinate implements StringRepresentable,
    ToFloatFunction<Point>
    {
        CONTINENTS(Point::continents, "continents"),
        EROSION(Point::erosion, "erosion"),
        WEIRDNESS(Point::weirdness, "weirdness"),
        RIDGES(Point::ridges, "ridges");

        private static final Map<String, Coordinate> BY_NAME;
        private static final Codec<Coordinate> CODEC;
        static final Codec<ToFloatFunction<Point>> WIDE_CODEC;
        private final ToFloatFunction<Point> reference;
        private final String name;

        static {
            BY_NAME = Arrays.stream(Coordinate.values()).collect(Collectors.toMap(Coordinate::getSerializedName, p_187371_ -> p_187371_));
            CODEC = StringRepresentable.fromEnum(Coordinate::values, BY_NAME::get);
            WIDE_CODEC = CODEC.flatComapMap(p_187365_ -> p_187365_, p_187363_ -> {
                DataResult dataresult;
                if (p_187363_ instanceof Coordinate) {
                    Coordinate terrainshaper$coordinate = (Coordinate)p_187363_;
                    dataresult = DataResult.success((Object)terrainshaper$coordinate);
                } else {
                    dataresult = DataResult.error((String)("Not a coordinate resolver: " + p_187363_));
                }
                return dataresult;
            });
        }

        private Coordinate(ToFloatFunction<Point> p_187359_, String p_187360_) {
            this.reference = p_187359_;
            this.name = p_187360_;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public float apply(Point p_187367_) {
            return this.reference.apply(p_187367_);
        }
    }

    public record CoordinateCustom(Holder<DensityFunction> function) implements ToFloatFunction<PointCustom>
    {
        static final Codec<ToFloatFunction<PointCustom>> WIDE_CODEC = DensityFunction.CODEC.flatComapMap(CoordinateCustom::new, p_211608_ -> {
            DataResult dataresult;
            if (p_211608_ instanceof CoordinateCustom) {
                CoordinateCustom terrainshaper$coordinatecustom = (CoordinateCustom)p_211608_;
                dataresult = DataResult.success(terrainshaper$coordinatecustom.function());
            } else {
                dataresult = DataResult.error((String)("Not a coordinate resolver: " + p_211608_));
            }
            return dataresult;
        });

        @Override
        public float apply(PointCustom p_211610_) {
            return (float)this.function.value().compute(p_211610_.context());
        }

        public CoordinateCustom mapAll(DensityFunction.Visitor p_211612_) {
            return new CoordinateCustom(new Holder.Direct<DensityFunction>(this.function.value().mapAll(p_211612_)));
        }
    }

    public record Point(float continents, float erosion, float ridges, float weirdness) {
    }

    public record PointCustom(DensityFunction.FunctionContext context) {
    }
}

