/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public class TheEndBiomeSource
extends BiomeSource {
    public static final Codec<TheEndBiomeSource> CODEC = RecordCodecBuilder.create(p_48644_ -> p_48644_.group((App)RegistryOps.retrieveRegistry(Registry.BIOME_REGISTRY).forGetter(p_151890_ -> null), (App)Codec.LONG.fieldOf("seed").stable().forGetter(p_151888_ -> p_151888_.seed)).apply((Applicative)p_48644_, p_48644_.stable(TheEndBiomeSource::new)));
    private static final float ISLAND_THRESHOLD = -0.9f;
    public static final int ISLAND_CHUNK_DISTANCE = 64;
    private static final long ISLAND_CHUNK_DISTANCE_SQR = 4096L;
    private final SimplexNoise islandNoise;
    private final long seed;
    private final Holder<Biome> end;
    private final Holder<Biome> highlands;
    private final Holder<Biome> midlands;
    private final Holder<Biome> islands;
    private final Holder<Biome> barrens;

    public TheEndBiomeSource(Registry<Biome> p_48628_, long p_48629_) {
        this(p_48629_, p_48628_.getOrCreateHolder(Biomes.THE_END), p_48628_.getOrCreateHolder(Biomes.END_HIGHLANDS), p_48628_.getOrCreateHolder(Biomes.END_MIDLANDS), p_48628_.getOrCreateHolder(Biomes.SMALL_END_ISLANDS), p_48628_.getOrCreateHolder(Biomes.END_BARRENS));
    }

    private TheEndBiomeSource(long p_204285_, Holder<Biome> p_204286_, Holder<Biome> p_204287_, Holder<Biome> p_204288_, Holder<Biome> p_204289_, Holder<Biome> p_204290_) {
        super((List<Holder<Biome>>)ImmutableList.of(p_204286_, p_204287_, p_204288_, p_204289_, p_204290_));
        this.seed = p_204285_;
        this.end = p_204286_;
        this.highlands = p_204287_;
        this.midlands = p_204288_;
        this.islands = p_204289_;
        this.barrens = p_204290_;
        WorldgenRandom worldgenrandom = new WorldgenRandom(new LegacyRandomSource(p_204285_));
        worldgenrandom.consumeCount(17292);
        this.islandNoise = new SimplexNoise(worldgenrandom);
    }

    @Override
    protected Codec<? extends BiomeSource> codec() {
        return CODEC;
    }

    @Override
    public BiomeSource withSeed(long pSeed) {
        return new TheEndBiomeSource(pSeed, this.end, this.highlands, this.midlands, this.islands, this.barrens);
    }

    @Override
    public Holder<Biome> getNoiseBiome(int p_204292_, int p_204293_, int p_204294_, Climate.Sampler p_204295_) {
        int i = p_204292_ >> 2;
        int j = p_204294_ >> 2;
        if ((long)i * (long)i + (long)j * (long)j <= 4096L) {
            return this.end;
        }
        float f = TheEndBiomeSource.getHeightValue(this.islandNoise, i * 2 + 1, j * 2 + 1);
        if (f > 40.0f) {
            return this.highlands;
        }
        if (f >= 0.0f) {
            return this.midlands;
        }
        return f < -20.0f ? this.islands : this.barrens;
    }

    public boolean stable(long pSeed) {
        return this.seed == pSeed;
    }

    public static float getHeightValue(SimplexNoise pNoise, int pX, int pZ) {
        int i = pX / 2;
        int j = pZ / 2;
        int k = pX % 2;
        int l = pZ % 2;
        float f = 100.0f - Mth.sqrt(pX * pX + pZ * pZ) * 8.0f;
        f = Mth.clamp(f, -100.0f, 80.0f);
        int i1 = -12;
        while (i1 <= 12) {
            int j1 = -12;
            while (j1 <= 12) {
                long k1 = i + i1;
                long l1 = j + j1;
                if (k1 * k1 + l1 * l1 > 4096L && pNoise.getValue(k1, l1) < (double)-0.9f) {
                    float f1 = (Mth.abs(k1) * 3439.0f + Mth.abs(l1) * 147.0f) % 13.0f + 9.0f;
                    float f2 = k - i1 * 2;
                    float f3 = l - j1 * 2;
                    float f4 = 100.0f - Mth.sqrt(f2 * f2 + f3 * f3) * f1;
                    f4 = Mth.clamp(f4, -100.0f, 80.0f);
                    f = Math.max(f, f4);
                }
                ++j1;
            }
            ++i1;
        }
        return f;
    }
}

