/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BaseFireBlock
extends Block {
    private static final int SECONDS_ON_FIRE = 8;
    private final float fireDamage;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final VoxelShape DOWN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);

    public BaseFireBlock(BlockBehaviour.Properties pProperties, float pFireDamage) {
        super(pProperties);
        this.fireDamage = pFireDamage;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return BaseFireBlock.getState(pContext.getLevel(), pContext.getClickedPos());
    }

    public static BlockState getState(BlockGetter pReader, BlockPos pPos) {
        BlockPos blockpos = pPos.below();
        BlockState blockstate = pReader.getBlockState(blockpos);
        return SoulFireBlock.canSurviveOnBlock(blockstate) ? Blocks.SOUL_FIRE.defaultBlockState() : ((FireBlock)Blocks.FIRE).getStateForPlacement(pReader, pPos);
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return DOWN_AABB;
    }

    @Override
    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, Random pRandom) {
        block12: {
            block11: {
                BlockPos blockpos;
                BlockState blockstate;
                if (pRandom.nextInt(24) == 0) {
                    pLevel.playLocalSound((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + pRandom.nextFloat(), pRandom.nextFloat() * 0.7f + 0.3f, false);
                }
                if (this.canBurn(blockstate = pLevel.getBlockState(blockpos = pPos.below())) || blockstate.isFaceSturdy(pLevel, blockpos, Direction.UP)) break block11;
                if (this.canBurn(pLevel.getBlockState(pPos.west()))) {
                    int j = 0;
                    while (j < 2) {
                        double d3 = (double)pPos.getX() + pRandom.nextDouble() * (double)0.1f;
                        double d8 = (double)pPos.getY() + pRandom.nextDouble();
                        double d13 = (double)pPos.getZ() + pRandom.nextDouble();
                        pLevel.addParticle(ParticleTypes.LARGE_SMOKE, d3, d8, d13, 0.0, 0.0, 0.0);
                        ++j;
                    }
                }
                if (this.canBurn(pLevel.getBlockState(pPos.east()))) {
                    int k = 0;
                    while (k < 2) {
                        double d4 = (double)(pPos.getX() + 1) - pRandom.nextDouble() * (double)0.1f;
                        double d9 = (double)pPos.getY() + pRandom.nextDouble();
                        double d14 = (double)pPos.getZ() + pRandom.nextDouble();
                        pLevel.addParticle(ParticleTypes.LARGE_SMOKE, d4, d9, d14, 0.0, 0.0, 0.0);
                        ++k;
                    }
                }
                if (this.canBurn(pLevel.getBlockState(pPos.north()))) {
                    int l = 0;
                    while (l < 2) {
                        double d5 = (double)pPos.getX() + pRandom.nextDouble();
                        double d10 = (double)pPos.getY() + pRandom.nextDouble();
                        double d15 = (double)pPos.getZ() + pRandom.nextDouble() * (double)0.1f;
                        pLevel.addParticle(ParticleTypes.LARGE_SMOKE, d5, d10, d15, 0.0, 0.0, 0.0);
                        ++l;
                    }
                }
                if (this.canBurn(pLevel.getBlockState(pPos.south()))) {
                    int i1 = 0;
                    while (i1 < 2) {
                        double d6 = (double)pPos.getX() + pRandom.nextDouble();
                        double d11 = (double)pPos.getY() + pRandom.nextDouble();
                        double d16 = (double)(pPos.getZ() + 1) - pRandom.nextDouble() * (double)0.1f;
                        pLevel.addParticle(ParticleTypes.LARGE_SMOKE, d6, d11, d16, 0.0, 0.0, 0.0);
                        ++i1;
                    }
                }
                if (!this.canBurn(pLevel.getBlockState(pPos.above()))) break block12;
                int j1 = 0;
                while (j1 < 2) {
                    double d7 = (double)pPos.getX() + pRandom.nextDouble();
                    double d12 = (double)(pPos.getY() + 1) - pRandom.nextDouble() * (double)0.1f;
                    double d17 = (double)pPos.getZ() + pRandom.nextDouble();
                    pLevel.addParticle(ParticleTypes.LARGE_SMOKE, d7, d12, d17, 0.0, 0.0, 0.0);
                    ++j1;
                }
                break block12;
            }
            int i = 0;
            while (i < 3) {
                double d0 = (double)pPos.getX() + pRandom.nextDouble();
                double d1 = (double)pPos.getY() + pRandom.nextDouble() * 0.5 + 0.5;
                double d2 = (double)pPos.getZ() + pRandom.nextDouble();
                pLevel.addParticle(ParticleTypes.LARGE_SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
                ++i;
            }
        }
    }

    protected abstract boolean canBurn(BlockState var1);

    @Override
    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pEntity.fireImmune()) {
            pEntity.setRemainingFireTicks(pEntity.getRemainingFireTicks() + 1);
            if (pEntity.getRemainingFireTicks() == 0) {
                pEntity.setSecondsOnFire(8);
            }
            pEntity.hurt(DamageSource.IN_FIRE, this.fireDamage);
        }
        super.entityInside(pState, pLevel, pPos, pEntity);
    }

    @Override
    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.is(pState.getBlock())) {
            Optional<PortalShape> optional;
            if (BaseFireBlock.inPortalDimension(pLevel) && (optional = PortalShape.findEmptyPortalShape(pLevel, pPos, Direction.Axis.X)).isPresent()) {
                optional.get().createPortalBlocks();
                return;
            }
            if (!pState.canSurvive(pLevel, pPos)) {
                pLevel.removeBlock(pPos, false);
            }
        }
    }

    private static boolean inPortalDimension(Level pLevel) {
        return pLevel.dimension() == Level.OVERWORLD || pLevel.dimension() == Level.NETHER;
    }

    @Override
    protected void spawnDestroyParticles(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState) {
    }

    @Override
    public void playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.isClientSide()) {
            pLevel.levelEvent(null, 1009, pPos, 0);
        }
        super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    public static boolean canBePlacedAt(Level pLevel, BlockPos pPos, Direction pDirection) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        if (!blockstate.isAir()) {
            return false;
        }
        return BaseFireBlock.getState(pLevel, pPos).canSurvive(pLevel, pPos) || BaseFireBlock.isPortal(pLevel, pPos, pDirection);
    }

    private static boolean isPortal(Level pLevel, BlockPos pPos, Direction pDirection) {
        if (!BaseFireBlock.inPortalDimension(pLevel)) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.mutable();
        boolean flag = false;
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            if (pLevel.getBlockState(blockpos$mutableblockpos.set(pPos).move(direction)).is(Blocks.OBSIDIAN)) {
                flag = true;
                break;
            }
            ++n2;
        }
        if (!flag) {
            return false;
        }
        Direction.Axis direction$axis = pDirection.getAxis().isHorizontal() ? pDirection.getCounterClockWise().getAxis() : Direction.Plane.HORIZONTAL.getRandomAxis(pLevel.random);
        return PortalShape.findEmptyPortalShape(pLevel, pPos, direction$axis).isPresent();
    }
}

