/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RailState;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BaseRailBlock
extends Block
implements SimpleWaterloggedBlock {
    protected static final VoxelShape FLAT_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    protected static final VoxelShape HALF_BLOCK_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final boolean isStraight;

    public static boolean isRail(Level pLevel, BlockPos pPos) {
        return BaseRailBlock.isRail(pLevel.getBlockState(pPos));
    }

    public static boolean isRail(BlockState pState) {
        return pState.is(BlockTags.RAILS) && pState.getBlock() instanceof BaseRailBlock;
    }

    protected BaseRailBlock(boolean pIsStraight, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.isStraight = pIsStraight;
    }

    public boolean isStraight() {
        return this.isStraight;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        RailShape railshape = pState.is(this) ? pState.getValue(this.getShapeProperty()) : null;
        return railshape != null && railshape.isAscending() ? HALF_BLOCK_AABB : FLAT_AABB;
    }

    @Override
    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return BaseRailBlock.canSupportRigidBlock(pLevel, pPos.below());
    }

    @Override
    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.is(pState.getBlock())) {
            this.updateState(pState, pLevel, pPos, pIsMoving);
        }
    }

    protected BlockState updateState(BlockState pState, Level pLevel, BlockPos pPos, boolean pBlock) {
        pState = this.updateDir(pLevel, pPos, pState, true);
        if (this.isStraight) {
            pState.neighborChanged(pLevel, pPos, this, pPos, pBlock);
        }
        return pState;
    }

    @Override
    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (!pLevel.isClientSide && pLevel.getBlockState(pPos).is(this)) {
            RailShape railshape = pState.getValue(this.getShapeProperty());
            if (BaseRailBlock.shouldBeRemoved(pPos, pLevel, railshape)) {
                BaseRailBlock.dropResources(pState, pLevel, pPos);
                pLevel.removeBlock(pPos, pIsMoving);
            } else {
                this.updateState(pState, pLevel, pPos, pBlock);
            }
        }
    }

    private static boolean shouldBeRemoved(BlockPos pPos, Level pLevel, RailShape pRailShape) {
        if (!BaseRailBlock.canSupportRigidBlock(pLevel, pPos.below())) {
            return true;
        }
        switch (pRailShape) {
            case ASCENDING_EAST: {
                return !BaseRailBlock.canSupportRigidBlock(pLevel, pPos.east());
            }
            case ASCENDING_WEST: {
                return !BaseRailBlock.canSupportRigidBlock(pLevel, pPos.west());
            }
            case ASCENDING_NORTH: {
                return !BaseRailBlock.canSupportRigidBlock(pLevel, pPos.north());
            }
            case ASCENDING_SOUTH: {
                return !BaseRailBlock.canSupportRigidBlock(pLevel, pPos.south());
            }
        }
        return false;
    }

    protected void updateState(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock) {
    }

    protected BlockState updateDir(Level pLevel, BlockPos pPos, BlockState pState, boolean pPlacing) {
        if (pLevel.isClientSide) {
            return pState;
        }
        RailShape railshape = pState.getValue(this.getShapeProperty());
        return new RailState(pLevel, pPos, pState).place(pLevel.hasNeighborSignal(pPos), pPlacing, railshape).getState();
    }

    @Override
    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.NORMAL;
    }

    @Override
    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pIsMoving) {
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
            if (pState.getValue(this.getShapeProperty()).isAscending()) {
                pLevel.updateNeighborsAt(pPos.above(), this);
            }
            if (this.isStraight) {
                pLevel.updateNeighborsAt(pPos, this);
                pLevel.updateNeighborsAt(pPos.below(), this);
            }
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        BlockState blockstate = super.defaultBlockState();
        Direction direction = pContext.getHorizontalDirection();
        boolean flag1 = direction == Direction.EAST || direction == Direction.WEST;
        return (BlockState)((BlockState)blockstate.setValue(this.getShapeProperty(), flag1 ? RailShape.EAST_WEST : RailShape.NORTH_SOUTH)).setValue(WATERLOGGED, flag);
    }

    public abstract Property<RailShape> getShapeProperty();

    @Override
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pState.getValue(WATERLOGGED).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, Fluids.WATER, Fluids.WATER.getTickDelay(pLevel));
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    @Override
    public FluidState getFluidState(BlockState pState) {
        return pState.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }
}

