/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface CaveVines {
    public static final VoxelShape SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);
    public static final BooleanProperty BERRIES = BlockStateProperties.BERRIES;

    public static InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos) {
        if (pState.getValue(BERRIES).booleanValue()) {
            Block.popResource(pLevel, pPos, new ItemStack(Items.GLOW_BERRIES, 1));
            float f = Mth.randomBetween(pLevel.random, 0.8f, 1.2f);
            pLevel.playSound(null, pPos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, f);
            pLevel.setBlock(pPos, (BlockState)pState.setValue(BERRIES, false), 2);
            return InteractionResult.sidedSuccess(pLevel.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static boolean hasGlowBerries(BlockState pState) {
        return pState.hasProperty(BERRIES) && pState.getValue(BERRIES) != false;
    }

    public static ToIntFunction<BlockState> emission(int p_181218_) {
        return p_181216_ -> p_181216_.getValue(BlockStateProperties.BERRIES) != false ? p_181218_ : 0;
    }
}

