/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public interface ChangeOverTimeBlock<T extends Enum<T>> {
    public static final int SCAN_DISTANCE = 4;

    public Optional<BlockState> getNext(BlockState var1);

    public float getChanceModifier();

    default public void onRandomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRandom) {
        float f = 0.05688889f;
        if (pRandom.nextFloat() < 0.05688889f) {
            this.applyChangeOverTime(pState, pLevel, pPos, pRandom);
        }
    }

    public T getAge();

    default public void applyChangeOverTime(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRandom) {
        int i = ((Enum)this.getAge()).ordinal();
        int j = 0;
        int k = 0;
        for (BlockPos blockpos : BlockPos.withinManhattan(pPos, 4, 4, 4)) {
            BlockState blockstate;
            Block block;
            int l = blockpos.distManhattan(pPos);
            if (l > 4) break;
            if (blockpos.equals(pPos) || !((block = (blockstate = pLevel.getBlockState(blockpos)).getBlock()) instanceof ChangeOverTimeBlock)) continue;
            T oenum = ((ChangeOverTimeBlock)((Object)block)).getAge();
            if (this.getAge().getClass() != oenum.getClass()) continue;
            int i1 = ((Enum)oenum).ordinal();
            if (i1 < i) {
                return;
            }
            if (i1 > i) {
                ++k;
                continue;
            }
            ++j;
        }
        float f = (float)(k + 1) / (float)(k + j + 1);
        float f1 = f * f * this.getChanceModifier();
        if (pRandom.nextFloat() < f1) {
            this.getNext(pState).ifPresent(p_153039_ -> pLevel.setBlockAndUpdate(pPos, (BlockState)p_153039_));
        }
    }
}

