/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.BlockHitResult;

public class ChorusFlowerBlock
extends Block {
    public static final int DEAD_AGE = 5;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_5;
    private final ChorusPlantBlock plant;

    protected ChorusFlowerBlock(ChorusPlantBlock pPlant, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.plant = pPlant;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRand) {
        if (!pState.canSurvive(pLevel, pPos)) {
            pLevel.destroyBlock(pPos, true);
        }
    }

    @Override
    public boolean isRandomlyTicking(BlockState pState) {
        return pState.getValue(AGE) < 5;
    }

    @Override
    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRandom) {
        int i;
        BlockPos blockpos = pPos.above();
        if (pLevel.isEmptyBlock(blockpos) && blockpos.getY() < pLevel.getMaxBuildHeight() && (i = pState.getValue(AGE).intValue()) < 5) {
            boolean flag = false;
            boolean flag1 = false;
            BlockState blockstate = pLevel.getBlockState(pPos.below());
            if (blockstate.is(Blocks.END_STONE)) {
                flag = true;
            } else if (blockstate.is(this.plant)) {
                int j = 1;
                int k = 0;
                while (k < 4) {
                    BlockState blockstate1 = pLevel.getBlockState(pPos.below(j + 1));
                    if (!blockstate1.is(this.plant)) {
                        if (!blockstate1.is(Blocks.END_STONE)) break;
                        flag1 = true;
                        break;
                    }
                    ++j;
                    ++k;
                }
                if (j < 2 || j <= pRandom.nextInt(flag1 ? 5 : 4)) {
                    flag = true;
                }
            } else if (blockstate.isAir()) {
                flag = true;
            }
            if (flag && ChorusFlowerBlock.allNeighborsEmpty(pLevel, blockpos, null) && pLevel.isEmptyBlock(pPos.above(2))) {
                pLevel.setBlock(pPos, this.plant.getStateForPlacement(pLevel, pPos), 2);
                this.placeGrownFlower(pLevel, blockpos, i);
            } else if (i < 4) {
                int l = pRandom.nextInt(4);
                if (flag1) {
                    ++l;
                }
                boolean flag2 = false;
                int i1 = 0;
                while (i1 < l) {
                    Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(pRandom);
                    BlockPos blockpos1 = pPos.relative(direction);
                    if (pLevel.isEmptyBlock(blockpos1) && pLevel.isEmptyBlock(blockpos1.below()) && ChorusFlowerBlock.allNeighborsEmpty(pLevel, blockpos1, direction.getOpposite())) {
                        this.placeGrownFlower(pLevel, blockpos1, i + 1);
                        flag2 = true;
                    }
                    ++i1;
                }
                if (flag2) {
                    pLevel.setBlock(pPos, this.plant.getStateForPlacement(pLevel, pPos), 2);
                } else {
                    this.placeDeadFlower(pLevel, pPos);
                }
            } else {
                this.placeDeadFlower(pLevel, pPos);
            }
        }
    }

    private void placeGrownFlower(Level pLevel, BlockPos pPos, int pAge) {
        pLevel.setBlock(pPos, (BlockState)this.defaultBlockState().setValue(AGE, pAge), 2);
        pLevel.levelEvent(1033, pPos, 0);
    }

    private void placeDeadFlower(Level pLevel, BlockPos pPos) {
        pLevel.setBlock(pPos, (BlockState)this.defaultBlockState().setValue(AGE, 5), 2);
        pLevel.levelEvent(1034, pPos, 0);
    }

    private static boolean allNeighborsEmpty(LevelReader pLevel, BlockPos pPos, @Nullable Direction pExcludingSide) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (direction == pExcludingSide || pLevel.isEmptyBlock(pPos.relative(direction))) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing != Direction.UP && !pState.canSurvive(pLevel, pCurrentPos)) {
            pLevel.scheduleTick(pCurrentPos, this, 1);
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @Override
    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.getBlockState(pPos.below());
        if (!blockstate.is(this.plant) && !blockstate.is(Blocks.END_STONE)) {
            if (!blockstate.isAir()) {
                return false;
            }
            boolean flag = false;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockstate1 = pLevel.getBlockState(pPos.relative(direction));
                if (blockstate1.is(this.plant)) {
                    if (flag) {
                        return false;
                    }
                    flag = true;
                    continue;
                }
                if (blockstate1.isAir()) continue;
                return false;
            }
            return flag;
        }
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.a(AGE);
    }

    public static void generatePlant(LevelAccessor pLevel, BlockPos pPos, Random pRand, int pMaxHorizontalDistance) {
        pLevel.setBlock(pPos, ((ChorusPlantBlock)Blocks.CHORUS_PLANT).getStateForPlacement(pLevel, pPos), 2);
        ChorusFlowerBlock.growTreeRecursive(pLevel, pPos, pRand, pPos, pMaxHorizontalDistance, 0);
    }

    private static void growTreeRecursive(LevelAccessor pLevel, BlockPos pBranchPos, Random pRand, BlockPos pOriginalBranchPos, int pMaxHorizontalDistance, int pIterations) {
        ChorusPlantBlock chorusplantblock = (ChorusPlantBlock)Blocks.CHORUS_PLANT;
        int i = pRand.nextInt(4) + 1;
        if (pIterations == 0) {
            ++i;
        }
        int j = 0;
        while (j < i) {
            BlockPos blockpos = pBranchPos.above(j + 1);
            if (!ChorusFlowerBlock.allNeighborsEmpty(pLevel, blockpos, null)) {
                return;
            }
            pLevel.setBlock(blockpos, chorusplantblock.getStateForPlacement(pLevel, blockpos), 2);
            pLevel.setBlock(blockpos.below(), chorusplantblock.getStateForPlacement(pLevel, blockpos.below()), 2);
            ++j;
        }
        boolean flag = false;
        if (pIterations < 4) {
            int l = pRand.nextInt(4);
            if (pIterations == 0) {
                ++l;
            }
            int k = 0;
            while (k < l) {
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(pRand);
                BlockPos blockpos1 = pBranchPos.above(i).relative(direction);
                if (Math.abs(blockpos1.getX() - pOriginalBranchPos.getX()) < pMaxHorizontalDistance && Math.abs(blockpos1.getZ() - pOriginalBranchPos.getZ()) < pMaxHorizontalDistance && pLevel.isEmptyBlock(blockpos1) && pLevel.isEmptyBlock(blockpos1.below()) && ChorusFlowerBlock.allNeighborsEmpty(pLevel, blockpos1, direction.getOpposite())) {
                    flag = true;
                    pLevel.setBlock(blockpos1, chorusplantblock.getStateForPlacement(pLevel, blockpos1), 2);
                    pLevel.setBlock(blockpos1.relative(direction.getOpposite()), chorusplantblock.getStateForPlacement(pLevel, blockpos1.relative(direction.getOpposite())), 2);
                    ChorusFlowerBlock.growTreeRecursive(pLevel, blockpos1, pRand, pOriginalBranchPos, pMaxHorizontalDistance, pIterations + 1);
                }
                ++k;
            }
        }
        if (!flag) {
            pLevel.setBlock(pBranchPos.above(i), (BlockState)Blocks.CHORUS_FLOWER.defaultBlockState().setValue(AGE, 5), 2);
        }
    }

    @Override
    public void onProjectileHit(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        BlockPos blockpos = pHit.getBlockPos();
        if (!pLevel.isClientSide && pProjectile.mayInteract(pLevel, blockpos) && pProjectile.getType().is(EntityTypeTags.IMPACT_PROJECTILES)) {
            pLevel.destroyBlock(blockpos, true, pProjectile);
        }
    }
}

