/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class ConcretePowderBlock
extends FallingBlock {
    private final BlockState concrete;

    public ConcretePowderBlock(Block pConcrete, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.concrete = pConcrete.defaultBlockState();
    }

    @Override
    public void onLand(Level p_52068_, BlockPos p_52069_, BlockState p_52070_, BlockState p_52071_, FallingBlockEntity p_52072_) {
        if (ConcretePowderBlock.shouldSolidify(p_52068_, p_52069_, p_52071_)) {
            p_52068_.setBlock(p_52069_, this.concrete, 3);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState blockstate;
        BlockPos blockpos;
        Level blockgetter = pContext.getLevel();
        return ConcretePowderBlock.shouldSolidify(blockgetter, blockpos = pContext.getClickedPos(), blockstate = blockgetter.getBlockState(blockpos)) ? this.concrete : super.getStateForPlacement(pContext);
    }

    private static boolean shouldSolidify(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return ConcretePowderBlock.canSolidify(pState) || ConcretePowderBlock.touchesLiquid(pLevel, pPos);
    }

    private static boolean touchesLiquid(BlockGetter pLevel, BlockPos pPos) {
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.mutable();
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            BlockState blockstate = pLevel.getBlockState(blockpos$mutableblockpos);
            if (direction != Direction.DOWN || ConcretePowderBlock.canSolidify(blockstate)) {
                blockpos$mutableblockpos.setWithOffset((Vec3i)pPos, direction);
                blockstate = pLevel.getBlockState(blockpos$mutableblockpos);
                if (ConcretePowderBlock.canSolidify(blockstate) && !blockstate.isFaceSturdy(pLevel, pPos, direction.getOpposite())) {
                    flag = true;
                    break;
                }
            }
            ++n2;
        }
        return flag;
    }

    private static boolean canSolidify(BlockState pState) {
        return pState.getFluidState().is(FluidTags.WATER);
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return ConcretePowderBlock.touchesLiquid(pLevel, pCurrentPos) ? this.concrete : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @Override
    public int getDustColor(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return pState.getMapColor((BlockGetter)pReader, (BlockPos)pPos).col;
    }
}

