/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrossCollisionBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(p_52346_ -> ((Direction)p_52346_.getKey()).getAxis().isHorizontal()).collect(Util.toMap());
    protected final VoxelShape[] collisionShapeByIndex;
    protected final VoxelShape[] shapeByIndex;
    private final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();

    protected CrossCollisionBlock(float p_52320_, float p_52321_, float p_52322_, float p_52323_, float p_52324_, BlockBehaviour.Properties p_52325_) {
        super(p_52325_);
        this.collisionShapeByIndex = this.makeShapes(p_52320_, p_52321_, p_52324_, 0.0f, p_52324_);
        this.shapeByIndex = this.makeShapes(p_52320_, p_52321_, p_52322_, 0.0f, p_52323_);
        for (BlockState blockstate : this.stateDefinition.getPossibleStates()) {
            this.getAABBIndex(blockstate);
        }
    }

    protected VoxelShape[] makeShapes(float pNodeWidth, float pExtensionWidth, float pNodeHeight, float pExtensionBottom, float pExtensionHeight) {
        float f = 8.0f - pNodeWidth;
        float f1 = 8.0f + pNodeWidth;
        float f2 = 8.0f - pExtensionWidth;
        float f3 = 8.0f + pExtensionWidth;
        VoxelShape voxelshape = Block.box(f, 0.0, f, f1, pNodeHeight, f1);
        VoxelShape voxelshape1 = Block.box(f2, pExtensionBottom, 0.0, f3, pExtensionHeight, f3);
        VoxelShape voxelshape2 = Block.box(f2, pExtensionBottom, f2, f3, pExtensionHeight, 16.0);
        VoxelShape voxelshape3 = Block.box(0.0, pExtensionBottom, f2, f3, pExtensionHeight, f3);
        VoxelShape voxelshape4 = Block.box(f2, pExtensionBottom, f2, 16.0, pExtensionHeight, f3);
        VoxelShape voxelshape5 = Shapes.or(voxelshape1, voxelshape4);
        VoxelShape voxelshape6 = Shapes.or(voxelshape2, voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{Shapes.empty(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, Shapes.or(voxelshape2, voxelshape1), Shapes.or(voxelshape3, voxelshape1), Shapes.or(voxelshape6, voxelshape1), voxelshape4, Shapes.or(voxelshape2, voxelshape4), Shapes.or(voxelshape3, voxelshape4), Shapes.or(voxelshape6, voxelshape4), voxelshape5, Shapes.or(voxelshape2, voxelshape5), Shapes.or(voxelshape3, voxelshape5), Shapes.or(voxelshape6, voxelshape5)};
        int i = 0;
        while (i < 16) {
            avoxelshape[i] = Shapes.or(voxelshape, avoxelshape[i]);
            ++i;
        }
        return avoxelshape;
    }

    @Override
    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return pState.getValue(WATERLOGGED) == false;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeByIndex[this.getAABBIndex(pState)];
    }

    @Override
    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.collisionShapeByIndex[this.getAABBIndex(pState)];
    }

    private static int indexFor(Direction pFacing) {
        return 1 << pFacing.get2DDataValue();
    }

    protected int getAABBIndex(BlockState pState) {
        return this.stateToIndex.computeIntIfAbsent((Object)pState, p_52366_ -> {
            int i = 0;
            if (p_52366_.getValue(NORTH).booleanValue()) {
                i |= CrossCollisionBlock.indexFor(Direction.NORTH);
            }
            if (p_52366_.getValue(EAST).booleanValue()) {
                i |= CrossCollisionBlock.indexFor(Direction.EAST);
            }
            if (p_52366_.getValue(SOUTH).booleanValue()) {
                i |= CrossCollisionBlock.indexFor(Direction.SOUTH);
            }
            if (p_52366_.getValue(WEST).booleanValue()) {
                i |= CrossCollisionBlock.indexFor(Direction.WEST);
            }
            return i;
        });
    }

    @Override
    public FluidState getFluidState(BlockState pState) {
        return pState.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    @Override
    public boolean isPathfindable(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRot) {
        switch (pRot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(SOUTH))).setValue(EAST, pState.getValue(WEST))).setValue(SOUTH, pState.getValue(NORTH))).setValue(WEST, pState.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(EAST))).setValue(EAST, pState.getValue(SOUTH))).setValue(SOUTH, pState.getValue(WEST))).setValue(WEST, pState.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(WEST))).setValue(EAST, pState.getValue(NORTH))).setValue(SOUTH, pState.getValue(EAST))).setValue(WEST, pState.getValue(SOUTH));
            }
        }
        return pState;
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        switch (pMirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(SOUTH))).setValue(SOUTH, pState.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)pState.setValue(EAST, pState.getValue(WEST))).setValue(WEST, pState.getValue(EAST));
            }
        }
        return super.mirror(pState, pMirror);
    }
}

