/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;

public abstract class DiodeBlock
extends HorizontalDirectionalBlock {
    protected static final VoxelShape SHAPE = Block.box(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    protected DiodeBlock(BlockBehaviour.Properties p_52499_) {
        super(p_52499_);
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Override
    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return DiodeBlock.canSupportRigidBlock(pLevel, pPos.below());
    }

    @Override
    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRand) {
        if (!this.isLocked(pLevel, pPos, pState)) {
            boolean flag = pState.getValue(POWERED);
            boolean flag1 = this.shouldTurnOn(pLevel, pPos, pState);
            if (flag && !flag1) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue(POWERED, false), 2);
            } else if (!flag) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue(POWERED, true), 2);
                if (!flag1) {
                    pLevel.scheduleTick(pPos, this, this.getDelay(pState), TickPriority.VERY_HIGH);
                }
            }
        }
    }

    @Override
    public int getDirectSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return pBlockState.getSignal(pBlockAccess, pPos, pSide);
    }

    @Override
    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        if (!pBlockState.getValue(POWERED).booleanValue()) {
            return 0;
        }
        return pBlockState.getValue(FACING) == pSide ? this.getOutputSignal(pBlockAccess, pPos, pBlockState) : 0;
    }

    @Override
    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (pState.canSurvive(pLevel, pPos)) {
            this.checkTickOnNeighbor(pLevel, pPos, pState);
        } else {
            BlockEntity blockentity = pState.hasBlockEntity() ? pLevel.getBlockEntity(pPos) : null;
            DiodeBlock.dropResources(pState, pLevel, pPos, blockentity);
            pLevel.removeBlock(pPos, false);
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Direction direction = directionArray[n2];
                pLevel.updateNeighborsAt(pPos.relative(direction), this);
                ++n2;
            }
        }
    }

    protected void checkTickOnNeighbor(Level pLevel, BlockPos pPos, BlockState pState) {
        boolean flag1;
        boolean flag;
        if (!this.isLocked(pLevel, pPos, pState) && (flag = pState.getValue(POWERED).booleanValue()) != (flag1 = this.shouldTurnOn(pLevel, pPos, pState)) && !pLevel.getBlockTicks().willTickThisTick(pPos, this)) {
            TickPriority tickpriority = TickPriority.HIGH;
            if (this.shouldPrioritize(pLevel, pPos, pState)) {
                tickpriority = TickPriority.EXTREMELY_HIGH;
            } else if (flag) {
                tickpriority = TickPriority.VERY_HIGH;
            }
            pLevel.scheduleTick(pPos, this, this.getDelay(pState), tickpriority);
        }
    }

    public boolean isLocked(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return false;
    }

    protected boolean shouldTurnOn(Level pLevel, BlockPos pPos, BlockState pState) {
        return this.getInputSignal(pLevel, pPos, pState) > 0;
    }

    protected int getInputSignal(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction direction = pState.getValue(FACING);
        BlockPos blockpos = pPos.relative(direction);
        int i = pLevel.getSignal(blockpos, direction);
        if (i >= 15) {
            return i;
        }
        BlockState blockstate = pLevel.getBlockState(blockpos);
        return Math.max(i, blockstate.is(Blocks.REDSTONE_WIRE) ? blockstate.getValue(RedStoneWireBlock.POWER) : 0);
    }

    protected int getAlternateSignal(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        Direction direction = pState.getValue(FACING);
        Direction direction1 = direction.getClockWise();
        Direction direction2 = direction.getCounterClockWise();
        return Math.max(this.getAlternateSignalAt(pLevel, pPos.relative(direction1), direction1), this.getAlternateSignalAt(pLevel, pPos.relative(direction2), direction2));
    }

    protected int getAlternateSignalAt(LevelReader pLevel, BlockPos pPos, Direction pSide) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        if (this.isAlternateInput(blockstate)) {
            if (blockstate.is(Blocks.REDSTONE_BLOCK)) {
                return 15;
            }
            return blockstate.is(Blocks.REDSTONE_WIRE) ? blockstate.getValue(RedStoneWireBlock.POWER).intValue() : pLevel.getDirectSignal(pPos, pSide);
        }
        return 0;
    }

    @Override
    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue(FACING, pContext.getHorizontalDirection().getOpposite());
    }

    @Override
    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        if (this.shouldTurnOn(pLevel, pPos, pState)) {
            pLevel.scheduleTick(pPos, this, 1);
        }
    }

    @Override
    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        this.updateNeighborsInFront(pLevel, pPos, pState);
    }

    @Override
    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pIsMoving && !pState.is(pNewState.getBlock())) {
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
            this.updateNeighborsInFront(pLevel, pPos, pState);
        }
    }

    protected void updateNeighborsInFront(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction direction = pState.getValue(FACING);
        BlockPos blockpos = pPos.relative(direction.getOpposite());
        pLevel.neighborChanged(blockpos, this, pPos);
        pLevel.updateNeighborsAtExceptFromFacing(blockpos, this, direction);
    }

    protected boolean isAlternateInput(BlockState pState) {
        return pState.isSignalSource();
    }

    protected int getOutputSignal(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return 15;
    }

    public static boolean isDiode(BlockState pState) {
        return pState.getBlock() instanceof DiodeBlock;
    }

    public boolean shouldPrioritize(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        Direction direction = pState.getValue(FACING).getOpposite();
        BlockState blockstate = pLevel.getBlockState(pPos.relative(direction));
        return DiodeBlock.isDiode(blockstate) && blockstate.getValue(FACING) != direction;
    }

    protected abstract int getDelay(BlockState var1);
}

