/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.PositionImpl;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.DropperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class DispenserBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    private static final Map<Item, DispenseItemBehavior> DISPENSER_REGISTRY = (Map)Util.make(new Object2ObjectOpenHashMap(), p_52723_ -> p_52723_.defaultReturnValue((Object)new DefaultDispenseItemBehavior()));
    private static final int TRIGGER_DURATION = 4;

    public static void registerBehavior(ItemLike pItem, DispenseItemBehavior pBehavior) {
        DISPENSER_REGISTRY.put(pItem.asItem(), pBehavior);
    }

    protected DispenserBlock(BlockBehaviour.Properties p_52664_) {
        super(p_52664_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(TRIGGERED, false));
    }

    @Override
    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof DispenserBlockEntity) {
            pPlayer.openMenu((DispenserBlockEntity)blockentity);
            if (blockentity instanceof DropperBlockEntity) {
                pPlayer.awardStat(Stats.INSPECT_DROPPER);
            } else {
                pPlayer.awardStat(Stats.INSPECT_DISPENSER);
            }
        }
        return InteractionResult.CONSUME;
    }

    protected void dispenseFrom(ServerLevel pLevel, BlockPos pPos) {
        BlockSourceImpl blocksourceimpl = new BlockSourceImpl(pLevel, pPos);
        DispenserBlockEntity dispenserblockentity = (DispenserBlockEntity)blocksourceimpl.getEntity();
        int i = dispenserblockentity.getRandomSlot();
        if (i < 0) {
            pLevel.levelEvent(1001, pPos, 0);
            pLevel.gameEvent(GameEvent.DISPENSE_FAIL, pPos);
        } else {
            ItemStack itemstack = dispenserblockentity.getItem(i);
            DispenseItemBehavior dispenseitembehavior = this.getDispenseMethod(itemstack);
            if (dispenseitembehavior != DispenseItemBehavior.NOOP) {
                dispenserblockentity.setItem(i, dispenseitembehavior.dispense(blocksourceimpl, itemstack));
            }
        }
    }

    protected DispenseItemBehavior getDispenseMethod(ItemStack pStack) {
        return DISPENSER_REGISTRY.get(pStack.getItem());
    }

    @Override
    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean flag = pLevel.hasNeighborSignal(pPos) || pLevel.hasNeighborSignal(pPos.above());
        boolean flag1 = pState.getValue(TRIGGERED);
        if (flag && !flag1) {
            pLevel.scheduleTick(pPos, this, 4);
            pLevel.setBlock(pPos, (BlockState)pState.setValue(TRIGGERED, true), 4);
        } else if (!flag && flag1) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue(TRIGGERED, false), 4);
        }
    }

    @Override
    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRandom) {
        this.dispenseFrom(pLevel, pPos);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new DispenserBlockEntity(pPos, pState);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue(FACING, pContext.getNearestLookingDirection().getOpposite());
    }

    @Override
    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockentity;
        if (pStack.hasCustomHoverName() && (blockentity = pLevel.getBlockEntity(pPos)) instanceof DispenserBlockEntity) {
            ((DispenserBlockEntity)blockentity).setCustomName(pStack.getHoverName());
        }
    }

    @Override
    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.is(pNewState.getBlock())) {
            BlockEntity blockentity = pLevel.getBlockEntity(pPos);
            if (blockentity instanceof DispenserBlockEntity) {
                Containers.dropContents(pLevel, pPos, (Container)((DispenserBlockEntity)blockentity));
                pLevel.updateNeighbourForOutputSignal(pPos, this);
            }
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public static Position getDispensePosition(BlockSource pBlockSource) {
        Direction direction = pBlockSource.getBlockState().getValue(FACING);
        double d0 = pBlockSource.x() + 0.7 * (double)direction.getStepX();
        double d1 = pBlockSource.y() + 0.7 * (double)direction.getStepY();
        double d2 = pBlockSource.z() + 0.7 * (double)direction.getStepZ();
        return new PositionImpl(d0, d1, d2);
    }

    @Override
    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    @Override
    public int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity(pLevel.getBlockEntity(pPos));
    }

    @Override
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue(FACING, pRotation.rotate(pState.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation(pState.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.a(FACING, TRIGGERED);
    }
}

