/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class GrassBlock
extends SpreadingSnowyDirtBlock
implements BonemealableBlock {
    public GrassBlock(BlockBehaviour.Properties p_53685_) {
        super(p_53685_);
    }

    @Override
    public boolean isValidBonemealTarget(BlockGetter pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return pLevel.getBlockState(pPos.above()).isAir();
    }

    @Override
    public boolean isBonemealSuccess(Level pLevel, Random pRand, BlockPos pPos, BlockState pState) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel pLevel, Random pRand, BlockPos pPos, BlockState pState) {
        BlockPos blockpos = pPos.above();
        BlockState blockstate = Blocks.GRASS.defaultBlockState();
        int i = 0;
        while (i < 128) {
            block4: {
                Holder<PlacedFeature> holder;
                BlockPos blockpos1;
                block6: {
                    block5: {
                        blockpos1 = blockpos;
                        int j = 0;
                        while (j < i / 16) {
                            if (pLevel.getBlockState((blockpos1 = blockpos1.offset(pRand.nextInt(3) - 1, (pRand.nextInt(3) - 1) * pRand.nextInt(3) / 2, pRand.nextInt(3) - 1)).below()).is(this) && !pLevel.getBlockState(blockpos1).isCollisionShapeFullBlock(pLevel, blockpos1)) {
                                ++j;
                                continue;
                            }
                            break block4;
                        }
                        BlockState blockstate1 = pLevel.getBlockState(blockpos1);
                        if (blockstate1.is(blockstate.getBlock()) && pRand.nextInt(10) == 0) {
                            ((BonemealableBlock)((Object)blockstate.getBlock())).performBonemeal(pLevel, pRand, blockpos1, blockstate1);
                        }
                        if (!blockstate1.isAir()) break block4;
                        if (pRand.nextInt(8) != 0) break block5;
                        List<ConfiguredFeature<?, ?>> list = pLevel.getBiome(blockpos1).value().getGenerationSettings().getFlowerFeatures();
                        if (list.isEmpty()) break block4;
                        holder = ((RandomPatchConfiguration)list.get(0).config()).feature();
                        break block6;
                    }
                    holder = VegetationPlacements.GRASS_BONEMEAL;
                }
                holder.value().place(pLevel, pLevel.getChunkSource().getGenerator(), pRand, blockpos1);
            }
            ++i;
        }
    }
}

