/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HoneyBlock
extends HalfTransparentBlock {
    private static final double SLIDE_STARTS_WHEN_VERTICAL_SPEED_IS_AT_LEAST = 0.13;
    private static final double MIN_FALL_SPEED_TO_BE_CONSIDERED_SLIDING = 0.08;
    private static final double THROTTLE_SLIDE_SPEED_TO = 0.05;
    private static final int SLIDE_ADVANCEMENT_CHECK_INTERVAL = 20;
    protected static final VoxelShape SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 15.0, 15.0);

    public HoneyBlock(BlockBehaviour.Properties p_53985_) {
        super(p_53985_);
    }

    private static boolean doesEntityDoHoneyBlockSlideEffects(Entity pEntity) {
        return pEntity instanceof LivingEntity || pEntity instanceof AbstractMinecart || pEntity instanceof PrimedTnt || pEntity instanceof Boat;
    }

    @Override
    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Override
    public void fallOn(Level p_153372_, BlockState p_153373_, BlockPos p_153374_, Entity p_153375_, float p_153376_) {
        p_153375_.playSound(SoundEvents.HONEY_BLOCK_SLIDE, 1.0f, 1.0f);
        if (!p_153372_.isClientSide) {
            p_153372_.broadcastEntityEvent(p_153375_, (byte)54);
        }
        if (p_153375_.causeFallDamage(p_153376_, 0.2f, DamageSource.FALL)) {
            p_153375_.playSound(this.soundType.getFallSound(), this.soundType.getVolume() * 0.5f, this.soundType.getPitch() * 0.75f);
        }
    }

    @Override
    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (this.isSlidingDown(pPos, pEntity)) {
            this.maybeDoSlideAchievement(pEntity, pPos);
            this.doSlideMovement(pEntity);
            this.maybeDoSlideEffects(pLevel, pEntity);
        }
        super.entityInside(pState, pLevel, pPos, pEntity);
    }

    private boolean isSlidingDown(BlockPos pPos, Entity pEntity) {
        if (pEntity.isOnGround()) {
            return false;
        }
        if (pEntity.getY() > (double)pPos.getY() + 0.9375 - 1.0E-7) {
            return false;
        }
        if (pEntity.getDeltaMovement().y >= -0.08) {
            return false;
        }
        double d0 = Math.abs((double)pPos.getX() + 0.5 - pEntity.getX());
        double d1 = Math.abs((double)pPos.getZ() + 0.5 - pEntity.getZ());
        double d2 = 0.4375 + (double)(pEntity.getBbWidth() / 2.0f);
        return d0 + 1.0E-7 > d2 || d1 + 1.0E-7 > d2;
    }

    private void maybeDoSlideAchievement(Entity pEntity, BlockPos pPos) {
        if (pEntity instanceof ServerPlayer && pEntity.level.getGameTime() % 20L == 0L) {
            CriteriaTriggers.HONEY_BLOCK_SLIDE.trigger((ServerPlayer)pEntity, pEntity.level.getBlockState(pPos));
        }
    }

    private void doSlideMovement(Entity pEntity) {
        Vec3 vec3 = pEntity.getDeltaMovement();
        if (vec3.y < -0.13) {
            double d0 = -0.05 / vec3.y;
            pEntity.setDeltaMovement(new Vec3(vec3.x * d0, -0.05, vec3.z * d0));
        } else {
            pEntity.setDeltaMovement(new Vec3(vec3.x, -0.05, vec3.z));
        }
        pEntity.resetFallDistance();
    }

    private void maybeDoSlideEffects(Level pLevel, Entity pEntity) {
        if (HoneyBlock.doesEntityDoHoneyBlockSlideEffects(pEntity)) {
            if (pLevel.random.nextInt(5) == 0) {
                pEntity.playSound(SoundEvents.HONEY_BLOCK_SLIDE, 1.0f, 1.0f);
            }
            if (!pLevel.isClientSide && pLevel.random.nextInt(5) == 0) {
                pLevel.broadcastEntityEvent(pEntity, (byte)53);
            }
        }
    }

    public static void showSlideParticles(Entity pEntity) {
        HoneyBlock.showParticles(pEntity, 5);
    }

    public static void showJumpParticles(Entity pEntity) {
        HoneyBlock.showParticles(pEntity, 10);
    }

    private static void showParticles(Entity pEntity, int pParticleCount) {
        if (pEntity.level.isClientSide) {
            BlockState blockstate = Blocks.HONEY_BLOCK.defaultBlockState();
            int i = 0;
            while (i < pParticleCount) {
                pEntity.level.addParticle(new BlockParticleOption(ParticleTypes.BLOCK, blockstate), pEntity.getX(), pEntity.getY(), pEntity.getZ(), 0.0, 0.0, 0.0);
                ++i;
            }
        }
    }
}

