/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;

public class HugeMushroomBlock
extends Block {
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty DOWN = PipeBlock.DOWN;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION;

    public HugeMushroomBlock(BlockBehaviour.Properties p_54136_) {
        super(p_54136_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(NORTH, true)).setValue(EAST, true)).setValue(SOUTH, true)).setValue(WEST, true)).setValue(UP, true)).setValue(DOWN, true));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level blockgetter = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(DOWN, !blockgetter.getBlockState(blockpos.below()).is(this))).setValue(UP, !blockgetter.getBlockState(blockpos.above()).is(this))).setValue(NORTH, !blockgetter.getBlockState(blockpos.north()).is(this))).setValue(EAST, !blockgetter.getBlockState(blockpos.east()).is(this))).setValue(SOUTH, !blockgetter.getBlockState(blockpos.south()).is(this))).setValue(WEST, !blockgetter.getBlockState(blockpos.west()).is(this));
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacingState.is(this) ? (BlockState)pState.setValue(PROPERTY_BY_DIRECTION.get(pFacing), false) : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(PROPERTY_BY_DIRECTION.get(pRot.rotate(Direction.NORTH)), pState.getValue(NORTH))).setValue(PROPERTY_BY_DIRECTION.get(pRot.rotate(Direction.SOUTH)), pState.getValue(SOUTH))).setValue(PROPERTY_BY_DIRECTION.get(pRot.rotate(Direction.EAST)), pState.getValue(EAST))).setValue(PROPERTY_BY_DIRECTION.get(pRot.rotate(Direction.WEST)), pState.getValue(WEST))).setValue(PROPERTY_BY_DIRECTION.get(pRot.rotate(Direction.UP)), pState.getValue(UP))).setValue(PROPERTY_BY_DIRECTION.get(pRot.rotate(Direction.DOWN)), pState.getValue(DOWN));
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(PROPERTY_BY_DIRECTION.get(pMirror.mirror(Direction.NORTH)), pState.getValue(NORTH))).setValue(PROPERTY_BY_DIRECTION.get(pMirror.mirror(Direction.SOUTH)), pState.getValue(SOUTH))).setValue(PROPERTY_BY_DIRECTION.get(pMirror.mirror(Direction.EAST)), pState.getValue(EAST))).setValue(PROPERTY_BY_DIRECTION.get(pMirror.mirror(Direction.WEST)), pState.getValue(WEST))).setValue(PROPERTY_BY_DIRECTION.get(pMirror.mirror(Direction.UP)), pState.getValue(UP))).setValue(PROPERTY_BY_DIRECTION.get(pMirror.mirror(Direction.DOWN)), pState.getValue(DOWN));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.a(UP, DOWN, NORTH, EAST, SOUTH, WEST);
    }
}

