/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.BlockHitResult;

public class JukeboxBlock
extends BaseEntityBlock {
    public static final BooleanProperty HAS_RECORD = BlockStateProperties.HAS_RECORD;

    protected JukeboxBlock(BlockBehaviour.Properties p_54257_) {
        super(p_54257_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(HAS_RECORD, false));
    }

    @Override
    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        CompoundTag compoundtag = BlockItem.getBlockEntityData(pStack);
        if (compoundtag != null && compoundtag.contains("RecordItem")) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue(HAS_RECORD, true), 2);
        }
    }

    @Override
    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pState.getValue(HAS_RECORD).booleanValue()) {
            this.dropRecording(pLevel, pPos);
            pState = (BlockState)pState.setValue(HAS_RECORD, false);
            pLevel.setBlock(pPos, pState, 2);
            return InteractionResult.sidedSuccess(pLevel.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void setRecord(LevelAccessor pLevel, BlockPos pPos, BlockState pState, ItemStack pRecordStack) {
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof JukeboxBlockEntity) {
            ((JukeboxBlockEntity)blockentity).setRecord(pRecordStack.copy());
            pLevel.setBlock(pPos, (BlockState)pState.setValue(HAS_RECORD, true), 2);
        }
    }

    private void dropRecording(Level pLevel, BlockPos pPos) {
        JukeboxBlockEntity jukeboxblockentity;
        ItemStack itemstack;
        BlockEntity blockentity;
        if (!pLevel.isClientSide && (blockentity = pLevel.getBlockEntity(pPos)) instanceof JukeboxBlockEntity && !(itemstack = (jukeboxblockentity = (JukeboxBlockEntity)blockentity).getRecord()).isEmpty()) {
            pLevel.levelEvent(1010, pPos, 0);
            jukeboxblockentity.clearContent();
            float f = 0.7f;
            double d0 = (double)(pLevel.random.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(pLevel.random.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(pLevel.random.nextFloat() * 0.7f) + (double)0.15f;
            ItemStack itemstack1 = itemstack.copy();
            ItemEntity itementity = new ItemEntity(pLevel, (double)pPos.getX() + d0, (double)pPos.getY() + d1, (double)pPos.getZ() + d2, itemstack1);
            itementity.setDefaultPickUpDelay();
            pLevel.addFreshEntity(itementity);
        }
    }

    @Override
    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.is(pNewState.getBlock())) {
            this.dropRecording(pLevel, pPos);
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new JukeboxBlockEntity(pPos, pState);
    }

    @Override
    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    @Override
    public int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        Item item;
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof JukeboxBlockEntity && (item = ((JukeboxBlockEntity)blockentity).getRecord().getItem()) instanceof RecordItem) {
            return ((RecordItem)item).getAnalogOutput();
        }
        return 0;
    }

    @Override
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.a(HAS_RECORD);
    }
}

