/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MultifaceBlock
extends Block {
    private static final float AABB_OFFSET = 1.0f;
    private static final VoxelShape UP_AABB = Block.box(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape DOWN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape WEST_AABB = Block.box(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape EAST_AABB = Block.box(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION;
    private static final Map<Direction, VoxelShape> SHAPE_BY_DIRECTION = Util.make(Maps.newEnumMap(Direction.class), p_153923_ -> {
        p_153923_.put(Direction.NORTH, NORTH_AABB);
        p_153923_.put(Direction.EAST, EAST_AABB);
        p_153923_.put(Direction.SOUTH, SOUTH_AABB);
        p_153923_.put(Direction.WEST, WEST_AABB);
        p_153923_.put(Direction.UP, UP_AABB);
        p_153923_.put(Direction.DOWN, DOWN_AABB);
    });
    protected static final Direction[] DIRECTIONS = Direction.values();
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;
    private final boolean canRotate;
    private final boolean canMirrorX;
    private final boolean canMirrorZ;

    public MultifaceBlock(BlockBehaviour.Properties p_153822_) {
        super(p_153822_);
        this.registerDefaultState(MultifaceBlock.getDefaultMultifaceState(this.stateDefinition));
        this.shapesCache = this.getShapeForEachState(MultifaceBlock::calculateMultifaceShape);
        this.canRotate = Direction.Plane.HORIZONTAL.stream().allMatch(this::isFaceSupported);
        this.canMirrorX = Direction.Plane.HORIZONTAL.stream().filter(Direction.Axis.X).filter(this::isFaceSupported).count() % 2L == 0L;
        this.canMirrorZ = Direction.Plane.HORIZONTAL.stream().filter(Direction.Axis.Z).filter(this::isFaceSupported).count() % 2L == 0L;
    }

    protected boolean isFaceSupported(Direction p_153921_) {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        Direction[] directionArray = DIRECTIONS;
        int n = DIRECTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            if (this.isFaceSupported(direction)) {
                pBuilder.a(MultifaceBlock.getFaceProperty(direction));
            }
            ++n2;
        }
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (!MultifaceBlock.hasAnyFace(pState)) {
            return Blocks.AIR.defaultBlockState();
        }
        return MultifaceBlock.hasFace(pState, pDirection) && !MultifaceBlock.canAttachTo(pLevel, pDirection, pNeighborPos, pNeighborState) ? MultifaceBlock.removeFace(pState, MultifaceBlock.getFaceProperty(pDirection)) : pState;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (VoxelShape)this.shapesCache.get((Object)pState);
    }

    @Override
    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        boolean flag = false;
        Direction[] directionArray = DIRECTIONS;
        int n = DIRECTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            if (MultifaceBlock.hasFace(pState, direction)) {
                BlockPos blockpos = pPos.relative(direction);
                if (!MultifaceBlock.canAttachTo(pLevel, direction, blockpos, pLevel.getBlockState(blockpos))) {
                    return false;
                }
                flag = true;
            }
            ++n2;
        }
        return flag;
    }

    @Override
    public boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        return MultifaceBlock.hasAnyVacantFace(pState);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level level = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        return Arrays.stream(pContext.getNearestLookingDirections()).map(p_153865_ -> this.getStateForPlacement(blockstate, level, blockpos, (Direction)p_153865_)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockState pCurrentState, BlockGetter pLevel, BlockPos pPos, Direction pLookingDirection) {
        BlockState blockstate;
        if (!this.isFaceSupported(pLookingDirection)) {
            return null;
        }
        if (pCurrentState.is(this)) {
            if (MultifaceBlock.hasFace(pCurrentState, pLookingDirection)) {
                return null;
            }
            blockstate = pCurrentState;
        } else {
            blockstate = this.isWaterloggable() && pCurrentState.getFluidState().isSourceOfType(Fluids.WATER) ? (BlockState)this.defaultBlockState().setValue(BlockStateProperties.WATERLOGGED, true) : this.defaultBlockState();
        }
        BlockPos blockpos = pPos.relative(pLookingDirection);
        return MultifaceBlock.canAttachTo(pLevel, pLookingDirection, blockpos, pLevel.getBlockState(blockpos)) ? (BlockState)blockstate.setValue(MultifaceBlock.getFaceProperty(pLookingDirection), true) : null;
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return !this.canRotate ? pState : this.mapDirections(pState, pRotation::rotate);
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        if (pMirror == Mirror.FRONT_BACK && !this.canMirrorX) {
            return pState;
        }
        return pMirror == Mirror.LEFT_RIGHT && !this.canMirrorZ ? pState : this.mapDirections(pState, pMirror::mirror);
    }

    private BlockState mapDirections(BlockState p_153911_, Function<Direction, Direction> p_153912_) {
        BlockState blockstate = p_153911_;
        Direction[] directionArray = DIRECTIONS;
        int n = DIRECTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            if (this.isFaceSupported(direction)) {
                blockstate = (BlockState)blockstate.setValue(MultifaceBlock.getFaceProperty(p_153912_.apply(direction)), p_153911_.getValue(MultifaceBlock.getFaceProperty(direction)));
            }
            ++n2;
        }
        return blockstate;
    }

    public boolean spreadFromRandomFaceTowardRandomDirection(BlockState p_153936_, ServerLevel p_153937_, BlockPos p_153938_, Random p_153939_) {
        ArrayList list = Lists.newArrayList((Object[])DIRECTIONS);
        Collections.shuffle(list);
        return list.stream().filter(p_153955_ -> MultifaceBlock.hasFace(p_153936_, p_153955_)).anyMatch(p_153846_ -> this.spreadFromFaceTowardRandomDirection(p_153936_, p_153937_, p_153938_, (Direction)p_153846_, p_153939_, false));
    }

    public boolean spreadFromFaceTowardRandomDirection(BlockState p_153874_, LevelAccessor p_153875_, BlockPos p_153876_, Direction p_153877_, Random p_153878_, boolean p_153879_) {
        List<Direction> list = Arrays.asList(DIRECTIONS);
        Collections.shuffle(list, p_153878_);
        return list.stream().anyMatch(p_153886_ -> this.spreadFromFaceTowardDirection(p_153874_, p_153875_, p_153876_, p_153877_, (Direction)p_153886_, p_153879_));
    }

    public boolean spreadFromFaceTowardDirection(BlockState p_153867_, LevelAccessor p_153868_, BlockPos p_153869_, Direction p_153870_, Direction p_153871_, boolean p_153872_) {
        Optional<Pair<BlockPos, Direction>> optional = this.getSpreadFromFaceTowardDirection(p_153867_, p_153868_, p_153869_, p_153870_, p_153871_);
        if (optional.isPresent()) {
            Pair<BlockPos, Direction> pair = optional.get();
            return this.spreadToFace(p_153868_, (BlockPos)pair.getFirst(), (Direction)pair.getSecond(), p_153872_);
        }
        return false;
    }

    protected boolean canSpread(BlockState p_153949_, BlockGetter p_153950_, BlockPos p_153951_, Direction p_153952_) {
        return Stream.of(DIRECTIONS).anyMatch(p_153929_ -> this.getSpreadFromFaceTowardDirection(p_153949_, p_153950_, p_153951_, p_153952_, (Direction)p_153929_).isPresent());
    }

    private Optional<Pair<BlockPos, Direction>> getSpreadFromFaceTowardDirection(BlockState p_153856_, BlockGetter p_153857_, BlockPos p_153858_, Direction p_153859_, Direction p_153860_) {
        if (p_153860_.getAxis() != p_153859_.getAxis() && MultifaceBlock.hasFace(p_153856_, p_153859_) && !MultifaceBlock.hasFace(p_153856_, p_153860_)) {
            Direction direction;
            if (this.canSpreadToFace(p_153857_, p_153858_, p_153860_)) {
                return Optional.of(Pair.of((Object)p_153858_, (Object)p_153860_));
            }
            BlockPos blockpos = p_153858_.relative(p_153860_);
            if (this.canSpreadToFace(p_153857_, blockpos, p_153859_)) {
                return Optional.of(Pair.of((Object)blockpos, (Object)p_153859_));
            }
            BlockPos blockpos1 = blockpos.relative(p_153859_);
            return this.canSpreadToFace(p_153857_, blockpos1, direction = p_153860_.getOpposite()) ? Optional.of(Pair.of((Object)blockpos1, (Object)direction)) : Optional.empty();
        }
        return Optional.empty();
    }

    private boolean canSpreadToFace(BlockGetter p_153826_, BlockPos p_153827_, Direction p_153828_) {
        BlockState blockstate = p_153826_.getBlockState(p_153827_);
        if (!this.canSpreadInto(blockstate)) {
            return false;
        }
        BlockState blockstate1 = this.getStateForPlacement(blockstate, p_153826_, p_153827_, p_153828_);
        return blockstate1 != null;
    }

    private boolean spreadToFace(LevelAccessor p_153835_, BlockPos p_153836_, Direction p_153837_, boolean p_153838_) {
        BlockState blockstate = p_153835_.getBlockState(p_153836_);
        BlockState blockstate1 = this.getStateForPlacement(blockstate, p_153835_, p_153836_, p_153837_);
        if (blockstate1 != null) {
            if (p_153838_) {
                p_153835_.getChunk(p_153836_).markPosForPostprocessing(p_153836_);
            }
            return p_153835_.setBlock(p_153836_, blockstate1, 2);
        }
        return false;
    }

    private boolean canSpreadInto(BlockState p_153957_) {
        return p_153957_.isAir() || p_153957_.is(this) || p_153957_.is(Blocks.WATER) && p_153957_.getFluidState().isSource();
    }

    private static boolean hasFace(BlockState p_153901_, Direction p_153902_) {
        BooleanProperty booleanproperty = MultifaceBlock.getFaceProperty(p_153902_);
        return p_153901_.hasProperty(booleanproperty) && p_153901_.getValue(booleanproperty) != false;
    }

    private static boolean canAttachTo(BlockGetter p_153830_, Direction p_153831_, BlockPos p_153832_, BlockState p_153833_) {
        return Block.isFaceFull(p_153833_.getCollisionShape(p_153830_, p_153832_), p_153831_.getOpposite());
    }

    private boolean isWaterloggable() {
        return this.stateDefinition.getProperties().contains(BlockStateProperties.WATERLOGGED);
    }

    private static BlockState removeFace(BlockState p_153898_, BooleanProperty p_153899_) {
        BlockState blockstate = (BlockState)p_153898_.setValue(p_153899_, false);
        return MultifaceBlock.hasAnyFace(blockstate) ? blockstate : Blocks.AIR.defaultBlockState();
    }

    public static BooleanProperty getFaceProperty(Direction p_153934_) {
        return PROPERTY_BY_DIRECTION.get(p_153934_);
    }

    private static BlockState getDefaultMultifaceState(StateDefinition<Block, BlockState> p_153919_) {
        BlockState blockstate = p_153919_.any();
        for (BooleanProperty booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!blockstate.hasProperty(booleanproperty)) continue;
            blockstate = (BlockState)blockstate.setValue(booleanproperty, false);
        }
        return blockstate;
    }

    private static VoxelShape calculateMultifaceShape(BlockState p_153959_) {
        VoxelShape voxelshape = Shapes.empty();
        Direction[] directionArray = DIRECTIONS;
        int n = DIRECTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            if (MultifaceBlock.hasFace(p_153959_, direction)) {
                voxelshape = Shapes.or(voxelshape, SHAPE_BY_DIRECTION.get(direction));
            }
            ++n2;
        }
        return voxelshape.isEmpty() ? Shapes.block() : voxelshape;
    }

    protected static boolean hasAnyFace(BlockState p_153961_) {
        return Arrays.stream(DIRECTIONS).anyMatch(p_153947_ -> MultifaceBlock.hasFace(p_153961_, p_153947_));
    }

    private static boolean hasAnyVacantFace(BlockState p_153963_) {
        return Arrays.stream(DIRECTIONS).anyMatch(p_153932_ -> !MultifaceBlock.hasFace(p_153963_, p_153932_));
    }
}

