/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PipeBlock
extends Block {
    private static final Direction[] DIRECTIONS = Direction.values();
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Util.make(Maps.newEnumMap(Direction.class), p_55164_ -> {
        p_55164_.put(Direction.NORTH, NORTH);
        p_55164_.put(Direction.EAST, EAST);
        p_55164_.put(Direction.SOUTH, SOUTH);
        p_55164_.put(Direction.WEST, WEST);
        p_55164_.put(Direction.UP, UP);
        p_55164_.put(Direction.DOWN, DOWN);
    }));
    protected final VoxelShape[] shapeByIndex;

    protected PipeBlock(float p_55159_, BlockBehaviour.Properties p_55160_) {
        super(p_55160_);
        this.shapeByIndex = this.makeShapes(p_55159_);
    }

    private VoxelShape[] makeShapes(float pApothem) {
        float f = 0.5f - pApothem;
        float f1 = 0.5f + pApothem;
        VoxelShape voxelshape = Block.box(f * 16.0f, f * 16.0f, f * 16.0f, f1 * 16.0f, f1 * 16.0f, f1 * 16.0f);
        VoxelShape[] avoxelshape = new VoxelShape[DIRECTIONS.length];
        int i = 0;
        while (i < DIRECTIONS.length) {
            Direction direction = DIRECTIONS[i];
            avoxelshape[i] = Shapes.box(0.5 + Math.min((double)(-pApothem), (double)direction.getStepX() * 0.5), 0.5 + Math.min((double)(-pApothem), (double)direction.getStepY() * 0.5), 0.5 + Math.min((double)(-pApothem), (double)direction.getStepZ() * 0.5), 0.5 + Math.max((double)pApothem, (double)direction.getStepX() * 0.5), 0.5 + Math.max((double)pApothem, (double)direction.getStepY() * 0.5), 0.5 + Math.max((double)pApothem, (double)direction.getStepZ() * 0.5));
            ++i;
        }
        VoxelShape[] avoxelshape1 = new VoxelShape[64];
        int k = 0;
        while (k < 64) {
            VoxelShape voxelshape1 = voxelshape;
            int j = 0;
            while (j < DIRECTIONS.length) {
                if ((k & 1 << j) != 0) {
                    voxelshape1 = Shapes.or(voxelshape1, avoxelshape[j]);
                }
                ++j;
            }
            avoxelshape1[k] = voxelshape1;
            ++k;
        }
        return avoxelshape1;
    }

    @Override
    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return false;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeByIndex[this.getAABBIndex(pState)];
    }

    protected int getAABBIndex(BlockState pState) {
        int i = 0;
        int j = 0;
        while (j < DIRECTIONS.length) {
            if (((Boolean)pState.getValue(PROPERTY_BY_DIRECTION.get(DIRECTIONS[j]))).booleanValue()) {
                i |= 1 << j;
            }
            ++j;
        }
        return i;
    }
}

