/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.StringUtils;

public class PlayerHeadBlock
extends SkullBlock {
    protected PlayerHeadBlock(BlockBehaviour.Properties p_55177_) {
        super(SkullBlock.Types.PLAYER, p_55177_);
    }

    @Override
    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof SkullBlockEntity) {
            SkullBlockEntity skullblockentity = (SkullBlockEntity)blockentity;
            GameProfile gameprofile = null;
            if (pStack.hasTag()) {
                CompoundTag compoundtag = pStack.getTag();
                if (compoundtag.contains("SkullOwner", 10)) {
                    gameprofile = NbtUtils.readGameProfile(compoundtag.getCompound("SkullOwner"));
                } else if (compoundtag.contains("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)compoundtag.getString("SkullOwner"))) {
                    gameprofile = new GameProfile(null, compoundtag.getString("SkullOwner"));
                }
            }
            skullblockentity.setOwner(gameprofile);
        }
    }
}

