/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.math.Vector3f;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RedStoneWireBlock
extends Block {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.NORTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.EAST_REDSTONE;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.SOUTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.WEST_REDSTONE;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final Map<Direction, EnumProperty<RedstoneSide>> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    protected static final int H = 1;
    protected static final int W = 3;
    protected static final int E = 13;
    protected static final int N = 3;
    protected static final int S = 13;
    private static final VoxelShape SHAPE_DOT = Block.box(3.0, 0.0, 3.0, 13.0, 1.0, 13.0);
    private static final Map<Direction, VoxelShape> SHAPES_FLOOR = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), (Object)Direction.SOUTH, (Object)Block.box(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), (Object)Direction.EAST, (Object)Block.box(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), (Object)Direction.WEST, (Object)Block.box(0.0, 0.0, 3.0, 13.0, 1.0, 13.0)));
    private static final Map<Direction, VoxelShape> SHAPES_UP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.NORTH), Block.box(3.0, 0.0, 0.0, 13.0, 16.0, 1.0)), (Object)Direction.SOUTH, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.SOUTH), Block.box(3.0, 0.0, 15.0, 13.0, 16.0, 16.0)), (Object)Direction.EAST, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.EAST), Block.box(15.0, 0.0, 3.0, 16.0, 16.0, 13.0)), (Object)Direction.WEST, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.WEST), Block.box(0.0, 0.0, 3.0, 1.0, 16.0, 13.0))));
    private static final Map<BlockState, VoxelShape> SHAPES_CACHE = Maps.newHashMap();
    private static final Vec3[] COLORS = Util.make(new Vec3[16], p_154319_ -> {
        int i = 0;
        while (i <= 15) {
            float f;
            float f1 = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f2 = Mth.clamp(f * f * 0.7f - 0.5f, 0.0f, 1.0f);
            float f3 = Mth.clamp(f * f * 0.6f - 0.7f, 0.0f, 1.0f);
            p_154319_[i] = new Vec3(f1, f2, f3);
            ++i;
        }
    });
    private static final float PARTICLE_DENSITY = 0.2f;
    private final BlockState crossState;
    private boolean shouldSignal = true;

    public RedStoneWireBlock(BlockBehaviour.Properties p_55511_) {
        super(p_55511_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(NORTH, RedstoneSide.NONE)).setValue(EAST, RedstoneSide.NONE)).setValue(SOUTH, RedstoneSide.NONE)).setValue(WEST, RedstoneSide.NONE)).setValue(POWER, 0));
        this.crossState = (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, RedstoneSide.SIDE)).setValue(EAST, RedstoneSide.SIDE)).setValue(SOUTH, RedstoneSide.SIDE)).setValue(WEST, RedstoneSide.SIDE);
        for (BlockState blockstate : this.getStateDefinition().getPossibleStates()) {
            if (blockstate.getValue(POWER) != 0) continue;
            SHAPES_CACHE.put(blockstate, this.calculateShape(blockstate));
        }
    }

    private VoxelShape calculateShape(BlockState pState) {
        VoxelShape voxelshape = SHAPE_DOT;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)pState.getValue(PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == RedstoneSide.SIDE) {
                voxelshape = Shapes.or(voxelshape, SHAPES_FLOOR.get(direction));
                continue;
            }
            if (redstoneside != RedstoneSide.UP) continue;
            voxelshape = Shapes.or(voxelshape, SHAPES_UP.get(direction));
        }
        return voxelshape;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES_CACHE.get(pState.setValue(POWER, 0));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return this.getConnectionState(pContext.getLevel(), this.crossState, pContext.getClickedPos());
    }

    private BlockState getConnectionState(BlockGetter pLevel, BlockState pState, BlockPos pPos) {
        boolean flag6;
        boolean flag = RedStoneWireBlock.isDot(pState);
        pState = this.getMissingConnections(pLevel, (BlockState)this.defaultBlockState().setValue(POWER, pState.getValue(POWER)), pPos);
        if (flag && RedStoneWireBlock.isDot(pState)) {
            return pState;
        }
        boolean flag1 = pState.getValue(NORTH).isConnected();
        boolean flag2 = pState.getValue(SOUTH).isConnected();
        boolean flag3 = pState.getValue(EAST).isConnected();
        boolean flag4 = pState.getValue(WEST).isConnected();
        boolean flag5 = !flag1 && !flag2;
        boolean bl = flag6 = !flag3 && !flag4;
        if (!flag4 && flag5) {
            pState = (BlockState)pState.setValue(WEST, RedstoneSide.SIDE);
        }
        if (!flag3 && flag5) {
            pState = (BlockState)pState.setValue(EAST, RedstoneSide.SIDE);
        }
        if (!flag1 && flag6) {
            pState = (BlockState)pState.setValue(NORTH, RedstoneSide.SIDE);
        }
        if (!flag2 && flag6) {
            pState = (BlockState)pState.setValue(SOUTH, RedstoneSide.SIDE);
        }
        return pState;
    }

    private BlockState getMissingConnections(BlockGetter pLevel, BlockState pState, BlockPos pPos) {
        boolean flag = !pLevel.getBlockState(pPos.above()).isRedstoneConductor(pLevel, pPos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)pState.getValue(PROPERTY_BY_DIRECTION.get(direction))).isConnected()) continue;
            RedstoneSide redstoneside = this.getConnectingSide(pLevel, pPos, direction, flag);
            pState = (BlockState)pState.setValue(PROPERTY_BY_DIRECTION.get(direction), redstoneside);
        }
        return pState;
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == Direction.DOWN) {
            return pState;
        }
        if (pFacing == Direction.UP) {
            return this.getConnectionState(pLevel, pState, pCurrentPos);
        }
        RedstoneSide redstoneside = this.getConnectingSide(pLevel, pCurrentPos, pFacing);
        return redstoneside.isConnected() == ((RedstoneSide)pState.getValue(PROPERTY_BY_DIRECTION.get(pFacing))).isConnected() && !RedStoneWireBlock.isCross(pState) ? (BlockState)pState.setValue(PROPERTY_BY_DIRECTION.get(pFacing), redstoneside) : this.getConnectionState(pLevel, (BlockState)((BlockState)this.crossState.setValue(POWER, pState.getValue(POWER))).setValue(PROPERTY_BY_DIRECTION.get(pFacing), redstoneside), pCurrentPos);
    }

    private static boolean isCross(BlockState pState) {
        return pState.getValue(NORTH).isConnected() && pState.getValue(SOUTH).isConnected() && pState.getValue(EAST).isConnected() && pState.getValue(WEST).isConnected();
    }

    private static boolean isDot(BlockState pState) {
        return !pState.getValue(NORTH).isConnected() && !pState.getValue(SOUTH).isConnected() && !pState.getValue(EAST).isConnected() && !pState.getValue(WEST).isConnected();
    }

    @Override
    public void updateIndirectNeighbourShapes(BlockState pState, LevelAccessor pLevel, BlockPos pPos, int pFlags, int pRecursionLeft) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)pState.getValue(PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == RedstoneSide.NONE || pLevel.getBlockState(blockpos$mutableblockpos.setWithOffset((Vec3i)pPos, direction)).is(this)) continue;
            blockpos$mutableblockpos.move(Direction.DOWN);
            BlockState blockstate = pLevel.getBlockState(blockpos$mutableblockpos);
            if (!blockstate.is(Blocks.OBSERVER)) {
                BlockPos blockpos = blockpos$mutableblockpos.relative(direction.getOpposite());
                BlockState blockstate1 = blockstate.updateShape(direction.getOpposite(), pLevel.getBlockState(blockpos), pLevel, blockpos$mutableblockpos, blockpos);
                RedStoneWireBlock.updateOrDestroy(blockstate, blockstate1, pLevel, blockpos$mutableblockpos, pFlags, pRecursionLeft);
            }
            blockpos$mutableblockpos.setWithOffset((Vec3i)pPos, direction).move(Direction.UP);
            BlockState blockstate3 = pLevel.getBlockState(blockpos$mutableblockpos);
            if (blockstate3.is(Blocks.OBSERVER)) continue;
            BlockPos blockpos1 = blockpos$mutableblockpos.relative(direction.getOpposite());
            BlockState blockstate2 = blockstate3.updateShape(direction.getOpposite(), pLevel.getBlockState(blockpos1), pLevel, blockpos$mutableblockpos, blockpos1);
            RedStoneWireBlock.updateOrDestroy(blockstate3, blockstate2, pLevel, blockpos$mutableblockpos, pFlags, pRecursionLeft);
        }
    }

    private RedstoneSide getConnectingSide(BlockGetter pLevel, BlockPos pPos, Direction pFace) {
        return this.getConnectingSide(pLevel, pPos, pFace, !pLevel.getBlockState(pPos.above()).isRedstoneConductor(pLevel, pPos));
    }

    private RedstoneSide getConnectingSide(BlockGetter pLevel, BlockPos pPos, Direction pDirection, boolean pNonNormalCubeAbove) {
        boolean flag;
        BlockPos blockpos = pPos.relative(pDirection);
        BlockState blockstate = pLevel.getBlockState(blockpos);
        if (pNonNormalCubeAbove && (flag = this.canSurviveOn(pLevel, blockpos, blockstate)) && RedStoneWireBlock.shouldConnectTo(pLevel.getBlockState(blockpos.above()))) {
            if (blockstate.isFaceSturdy(pLevel, blockpos, pDirection.getOpposite())) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        return !RedStoneWireBlock.shouldConnectTo(blockstate, pDirection) && (blockstate.isRedstoneConductor(pLevel, blockpos) || !RedStoneWireBlock.shouldConnectTo(pLevel.getBlockState(blockpos.below()))) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    @Override
    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.below();
        BlockState blockstate = pLevel.getBlockState(blockpos);
        return this.canSurviveOn(pLevel, blockpos, blockstate);
    }

    private boolean canSurviveOn(BlockGetter pReader, BlockPos pPos, BlockState pState) {
        return pState.isFaceSturdy(pReader, pPos, Direction.UP) || pState.is(Blocks.HOPPER);
    }

    private void updatePowerStrength(Level pLevel, BlockPos pPos, BlockState pState) {
        int i = this.calculateTargetStrength(pLevel, pPos);
        if (pState.getValue(POWER) != i) {
            if (pLevel.getBlockState(pPos) == pState) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue(POWER, i), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(pPos);
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Direction direction = directionArray[n2];
                set.add(pPos.relative(direction));
                ++n2;
            }
            for (BlockPos blockpos : set) {
                pLevel.updateNeighborsAt(blockpos, this);
            }
        }
    }

    private int calculateTargetStrength(Level pLevel, BlockPos pPos) {
        this.shouldSignal = false;
        int i = pLevel.getBestNeighborSignal(pPos);
        this.shouldSignal = true;
        int j = 0;
        if (i < 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pPos.relative(direction);
                BlockState blockstate = pLevel.getBlockState(blockpos);
                j = Math.max(j, this.getWireSignal(blockstate));
                BlockPos blockpos1 = pPos.above();
                if (blockstate.isRedstoneConductor(pLevel, blockpos) && !pLevel.getBlockState(blockpos1).isRedstoneConductor(pLevel, blockpos1)) {
                    j = Math.max(j, this.getWireSignal(pLevel.getBlockState(blockpos.above())));
                    continue;
                }
                if (blockstate.isRedstoneConductor(pLevel, blockpos)) continue;
                j = Math.max(j, this.getWireSignal(pLevel.getBlockState(blockpos.below())));
            }
        }
        return Math.max(i, j - 1);
    }

    private int getWireSignal(BlockState pState) {
        return pState.is(this) ? pState.getValue(POWER) : 0;
    }

    private void checkCornerChangeAt(Level pLevel, BlockPos pPos) {
        if (pLevel.getBlockState(pPos).is(this)) {
            pLevel.updateNeighborsAt(pPos, this);
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Direction direction = directionArray[n2];
                pLevel.updateNeighborsAt(pPos.relative(direction), this);
                ++n2;
            }
        }
    }

    @Override
    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.is(pState.getBlock()) && !pLevel.isClientSide) {
            this.updatePowerStrength(pLevel, pPos, pState);
            for (Direction direction : Direction.Plane.VERTICAL) {
                pLevel.updateNeighborsAt(pPos.relative(direction), this);
            }
            this.updateNeighborsOfNeighboringWires(pLevel, pPos);
        }
    }

    @Override
    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pIsMoving && !pState.is(pNewState.getBlock())) {
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
            if (!pLevel.isClientSide) {
                Direction[] directionArray = Direction.values();
                int n = directionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Direction direction = directionArray[n2];
                    pLevel.updateNeighborsAt(pPos.relative(direction), this);
                    ++n2;
                }
                this.updatePowerStrength(pLevel, pPos, pState);
                this.updateNeighborsOfNeighboringWires(pLevel, pPos);
            }
        }
    }

    private void updateNeighborsOfNeighboringWires(Level pLevel, BlockPos pPos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(pLevel, pPos.relative(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pPos.relative(direction1);
            if (pLevel.getBlockState(blockpos).isRedstoneConductor(pLevel, blockpos)) {
                this.checkCornerChangeAt(pLevel, blockpos.above());
                continue;
            }
            this.checkCornerChangeAt(pLevel, blockpos.below());
        }
    }

    @Override
    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (!pLevel.isClientSide) {
            if (pState.canSurvive(pLevel, pPos)) {
                this.updatePowerStrength(pLevel, pPos, pState);
            } else {
                RedStoneWireBlock.dropResources(pState, pLevel, pPos);
                pLevel.removeBlock(pPos, false);
            }
        }
    }

    @Override
    public int getDirectSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return !this.shouldSignal ? 0 : pBlockState.getSignal(pBlockAccess, pPos, pSide);
    }

    @Override
    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        if (this.shouldSignal && pSide != Direction.DOWN) {
            int i = pBlockState.getValue(POWER);
            if (i == 0) {
                return 0;
            }
            return pSide != Direction.UP && !((RedstoneSide)this.getConnectionState(pBlockAccess, pBlockState, pPos).getValue(PROPERTY_BY_DIRECTION.get(pSide.getOpposite()))).isConnected() ? 0 : i;
        }
        return 0;
    }

    protected static boolean shouldConnectTo(BlockState pState) {
        return RedStoneWireBlock.shouldConnectTo(pState, null);
    }

    protected static boolean shouldConnectTo(BlockState pState, @Nullable Direction pDirection) {
        if (pState.is(Blocks.REDSTONE_WIRE)) {
            return true;
        }
        if (pState.is(Blocks.REPEATER)) {
            Direction direction = pState.getValue(RepeaterBlock.FACING);
            return direction == pDirection || direction.getOpposite() == pDirection;
        }
        if (pState.is(Blocks.OBSERVER)) {
            return pDirection == pState.getValue(ObserverBlock.FACING);
        }
        return pState.isSignalSource() && pDirection != null;
    }

    @Override
    public boolean isSignalSource(BlockState pState) {
        return this.shouldSignal;
    }

    public static int getColorForPower(int pPower) {
        Vec3 vec3 = COLORS[pPower];
        return Mth.color((float)vec3.x(), (float)vec3.y(), (float)vec3.z());
    }

    private void spawnParticlesAlongLine(Level p_154310_, Random p_154311_, BlockPos p_154312_, Vec3 p_154313_, Direction p_154314_, Direction p_154315_, float p_154316_, float p_154317_) {
        float f = p_154317_ - p_154316_;
        if (!(p_154311_.nextFloat() >= 0.2f * f)) {
            float f1 = 0.4375f;
            float f2 = p_154316_ + f * p_154311_.nextFloat();
            double d0 = 0.5 + (double)(0.4375f * (float)p_154314_.getStepX()) + (double)(f2 * (float)p_154315_.getStepX());
            double d1 = 0.5 + (double)(0.4375f * (float)p_154314_.getStepY()) + (double)(f2 * (float)p_154315_.getStepY());
            double d2 = 0.5 + (double)(0.4375f * (float)p_154314_.getStepZ()) + (double)(f2 * (float)p_154315_.getStepZ());
            p_154310_.addParticle(new DustParticleOptions(new Vector3f(p_154313_), 1.0f), (double)p_154312_.getX() + d0, (double)p_154312_.getY() + d1, (double)p_154312_.getZ() + d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, Random pRandom) {
        int i = pState.getValue(POWER);
        if (i != 0) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)pState.getValue(PROPERTY_BY_DIRECTION.get(direction));
                switch (redstoneside) {
                    case UP: {
                        this.spawnParticlesAlongLine(pLevel, pRandom, pPos, COLORS[i], direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.spawnParticlesAlongLine(pLevel, pRandom, pPos, COLORS[i], Direction.DOWN, direction, 0.0f, 0.5f);
                        break;
                    }
                    default: {
                        this.spawnParticlesAlongLine(pLevel, pRandom, pPos, COLORS[i], Direction.DOWN, direction, 0.0f, 0.3f);
                    }
                }
            }
        }
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        switch (pRotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(SOUTH))).setValue(EAST, pState.getValue(WEST))).setValue(SOUTH, pState.getValue(NORTH))).setValue(WEST, pState.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(EAST))).setValue(EAST, pState.getValue(SOUTH))).setValue(SOUTH, pState.getValue(WEST))).setValue(WEST, pState.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(WEST))).setValue(EAST, pState.getValue(NORTH))).setValue(SOUTH, pState.getValue(EAST))).setValue(WEST, pState.getValue(SOUTH));
            }
        }
        return pState;
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        switch (pMirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(SOUTH))).setValue(SOUTH, pState.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)pState.setValue(EAST, pState.getValue(WEST))).setValue(WEST, pState.getValue(EAST));
            }
        }
        return super.mirror(pState, pMirror);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.a(NORTH, EAST, SOUTH, WEST, POWER);
    }

    @Override
    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pPlayer.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        if (RedStoneWireBlock.isCross(pState) || RedStoneWireBlock.isDot(pState)) {
            BlockState blockstate = RedStoneWireBlock.isCross(pState) ? this.defaultBlockState() : this.crossState;
            blockstate = (BlockState)blockstate.setValue(POWER, pState.getValue(POWER));
            if ((blockstate = this.getConnectionState(pLevel, blockstate, pPos)) != pState) {
                pLevel.setBlock(pPos, blockstate, 3);
                this.updatesOnShapeChange(pLevel, pPos, pState, blockstate);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void updatesOnShapeChange(Level pLevel, BlockPos pPos, BlockState pOldState, BlockState pNewState) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pPos.relative(direction);
            if (((RedstoneSide)pOldState.getValue(PROPERTY_BY_DIRECTION.get(direction))).isConnected() == ((RedstoneSide)pNewState.getValue(PROPERTY_BY_DIRECTION.get(direction))).isConnected() || !pLevel.getBlockState(blockpos).isRedstoneConductor(pLevel, blockpos)) continue;
            pLevel.updateNeighborsAtExceptFromFacing(blockpos, pNewState.getBlock(), direction.getOpposite());
        }
    }
}

