/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;

public class RedstoneTorchBlock
extends TorchBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private static final Map<BlockGetter, List<Toggle>> RECENT_TOGGLES = new WeakHashMap<BlockGetter, List<Toggle>>();
    public static final int RECENT_TOGGLE_TIMER = 60;
    public static final int MAX_RECENT_TOGGLES = 8;
    public static final int RESTART_DELAY = 160;
    private static final int TOGGLE_DELAY = 2;

    protected RedstoneTorchBlock(BlockBehaviour.Properties p_55678_) {
        super(p_55678_, DustParticleOptions.REDSTONE);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(LIT, true));
    }

    @Override
    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            pLevel.updateNeighborsAt(pPos.relative(direction), this);
            ++n2;
        }
    }

    @Override
    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pIsMoving) {
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Direction direction = directionArray[n2];
                pLevel.updateNeighborsAt(pPos.relative(direction), this);
                ++n2;
            }
        }
    }

    @Override
    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return pBlockState.getValue(LIT) != false && Direction.UP != pSide ? 15 : 0;
    }

    protected boolean hasNeighborSignal(Level pLevel, BlockPos pPos, BlockState pState) {
        return pLevel.hasSignal(pPos.below(), Direction.DOWN);
    }

    @Override
    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRand) {
        boolean flag = this.hasNeighborSignal(pLevel, pPos, pState);
        List<Toggle> list = RECENT_TOGGLES.get(pLevel);
        while (list != null && !list.isEmpty() && pLevel.getGameTime() - list.get((int)0).when > 60L) {
            list.remove(0);
        }
        if (pState.getValue(LIT).booleanValue()) {
            if (flag) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue(LIT, false), 3);
                if (RedstoneTorchBlock.isToggledTooFrequently(pLevel, pPos, true)) {
                    pLevel.levelEvent(1502, pPos, 0);
                    pLevel.scheduleTick(pPos, pLevel.getBlockState(pPos).getBlock(), 160);
                }
            }
        } else if (!flag && !RedstoneTorchBlock.isToggledTooFrequently(pLevel, pPos, false)) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue(LIT, true), 3);
        }
    }

    @Override
    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (pState.getValue(LIT).booleanValue() == this.hasNeighborSignal(pLevel, pPos, pState) && !pLevel.getBlockTicks().willTickThisTick(pPos, this)) {
            pLevel.scheduleTick(pPos, this, 2);
        }
    }

    @Override
    public int getDirectSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return pSide == Direction.DOWN ? pBlockState.getSignal(pBlockAccess, pPos, pSide) : 0;
    }

    @Override
    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    @Override
    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, Random pRand) {
        if (pState.getValue(LIT).booleanValue()) {
            double d0 = (double)pPos.getX() + 0.5 + (pRand.nextDouble() - 0.5) * 0.2;
            double d1 = (double)pPos.getY() + 0.7 + (pRand.nextDouble() - 0.5) * 0.2;
            double d2 = (double)pPos.getZ() + 0.5 + (pRand.nextDouble() - 0.5) * 0.2;
            pLevel.addParticle(this.flameParticle, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.a(LIT);
    }

    private static boolean isToggledTooFrequently(Level p_55685_, BlockPos p_55686_, boolean p_55687_) {
        List list = RECENT_TOGGLES.computeIfAbsent(p_55685_, p_55680_ -> Lists.newArrayList());
        if (p_55687_) {
            list.add(new Toggle(p_55686_.immutable(), p_55685_.getGameTime()));
        }
        int i = 0;
        int j = 0;
        while (j < list.size()) {
            Toggle redstonetorchblock$toggle = (Toggle)list.get(j);
            if (redstonetorchblock$toggle.pos.equals(p_55686_) && ++i >= 8) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public static class Toggle {
        final BlockPos pos;
        final long when;

        public Toggle(BlockPos pPos, long pWhen) {
            this.pos = pPos;
            this.when = pWhen;
        }
    }
}

