/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.BlockHitResult;

public class RepeaterBlock
extends DiodeBlock {
    public static final BooleanProperty LOCKED = BlockStateProperties.LOCKED;
    public static final IntegerProperty DELAY = BlockStateProperties.DELAY;

    protected RepeaterBlock(BlockBehaviour.Properties p_55801_) {
        super(p_55801_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(DELAY, 1)).setValue(LOCKED, false)).setValue(POWERED, false));
    }

    @Override
    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pPlayer.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        pLevel.setBlock(pPos, (BlockState)pState.cycle(DELAY), 3);
        return InteractionResult.sidedSuccess(pLevel.isClientSide);
    }

    @Override
    protected int getDelay(BlockState pState) {
        return pState.getValue(DELAY) * 2;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState blockstate = super.getStateForPlacement(pContext);
        return (BlockState)blockstate.setValue(LOCKED, this.isLocked(pContext.getLevel(), pContext.getClickedPos(), blockstate));
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return !pLevel.isClientSide() && pFacing.getAxis() != pState.getValue(FACING).getAxis() ? (BlockState)pState.setValue(LOCKED, this.isLocked(pLevel, pCurrentPos, pState)) : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @Override
    public boolean isLocked(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return this.getAlternateSignal(pLevel, pPos, pState) > 0;
    }

    @Override
    protected boolean isAlternateInput(BlockState pState) {
        return RepeaterBlock.isDiode(pState);
    }

    @Override
    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, Random pRandom) {
        if (pState.getValue(POWERED).booleanValue()) {
            Direction direction = pState.getValue(FACING);
            double d0 = (double)pPos.getX() + 0.5 + (pRandom.nextDouble() - 0.5) * 0.2;
            double d1 = (double)pPos.getY() + 0.4 + (pRandom.nextDouble() - 0.5) * 0.2;
            double d2 = (double)pPos.getZ() + 0.5 + (pRandom.nextDouble() - 0.5) * 0.2;
            float f = -5.0f;
            if (pRandom.nextBoolean()) {
                f = pState.getValue(DELAY) * 2 - 1;
            }
            double d3 = (f /= 16.0f) * (float)direction.getStepX();
            double d4 = f * (float)direction.getStepZ();
            pLevel.addParticle(DustParticleOptions.REDSTONE, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.a(FACING, DELAY, LOCKED, POWERED);
    }
}

