/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SculkSensorBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final int ACTIVE_TICKS = 40;
    public static final int COOLDOWN_TICKS = 1;
    public static final Object2IntMap<GameEvent> VIBRATION_STRENGTH_FOR_EVENT = Object2IntMaps.unmodifiable((Object2IntMap)((Object2IntMap)Util.make(new Object2IntOpenHashMap(), p_154469_ -> {
        p_154469_.put((Object)GameEvent.STEP, 1);
        p_154469_.put((Object)GameEvent.FLAP, 2);
        p_154469_.put((Object)GameEvent.SWIM, 3);
        p_154469_.put((Object)GameEvent.ELYTRA_FREE_FALL, 4);
        p_154469_.put((Object)GameEvent.HIT_GROUND, 5);
        p_154469_.put((Object)GameEvent.SPLASH, 6);
        p_154469_.put((Object)GameEvent.WOLF_SHAKING, 6);
        p_154469_.put((Object)GameEvent.MINECART_MOVING, 6);
        p_154469_.put((Object)GameEvent.RING_BELL, 6);
        p_154469_.put((Object)GameEvent.BLOCK_CHANGE, 6);
        p_154469_.put((Object)GameEvent.PROJECTILE_SHOOT, 7);
        p_154469_.put((Object)GameEvent.DRINKING_FINISH, 7);
        p_154469_.put((Object)GameEvent.PRIME_FUSE, 7);
        p_154469_.put((Object)GameEvent.PROJECTILE_LAND, 8);
        p_154469_.put((Object)GameEvent.EAT, 8);
        p_154469_.put((Object)GameEvent.MOB_INTERACT, 8);
        p_154469_.put((Object)GameEvent.ENTITY_DAMAGED, 8);
        p_154469_.put((Object)GameEvent.EQUIP, 9);
        p_154469_.put((Object)GameEvent.SHEAR, 9);
        p_154469_.put((Object)GameEvent.RAVAGER_ROAR, 9);
        p_154469_.put((Object)GameEvent.BLOCK_CLOSE, 10);
        p_154469_.put((Object)GameEvent.BLOCK_UNSWITCH, 10);
        p_154469_.put((Object)GameEvent.BLOCK_UNPRESS, 10);
        p_154469_.put((Object)GameEvent.BLOCK_DETACH, 10);
        p_154469_.put((Object)GameEvent.DISPENSE_FAIL, 10);
        p_154469_.put((Object)GameEvent.BLOCK_OPEN, 11);
        p_154469_.put((Object)GameEvent.BLOCK_SWITCH, 11);
        p_154469_.put((Object)GameEvent.BLOCK_PRESS, 11);
        p_154469_.put((Object)GameEvent.BLOCK_ATTACH, 11);
        p_154469_.put((Object)GameEvent.ENTITY_PLACE, 12);
        p_154469_.put((Object)GameEvent.BLOCK_PLACE, 12);
        p_154469_.put((Object)GameEvent.FLUID_PLACE, 12);
        p_154469_.put((Object)GameEvent.ENTITY_KILLED, 13);
        p_154469_.put((Object)GameEvent.BLOCK_DESTROY, 13);
        p_154469_.put((Object)GameEvent.FLUID_PICKUP, 13);
        p_154469_.put((Object)GameEvent.FISHING_ROD_REEL_IN, 14);
        p_154469_.put((Object)GameEvent.CONTAINER_CLOSE, 14);
        p_154469_.put((Object)GameEvent.PISTON_CONTRACT, 14);
        p_154469_.put((Object)GameEvent.SHULKER_CLOSE, 14);
        p_154469_.put((Object)GameEvent.PISTON_EXTEND, 15);
        p_154469_.put((Object)GameEvent.CONTAINER_OPEN, 15);
        p_154469_.put((Object)GameEvent.FISHING_ROD_CAST, 15);
        p_154469_.put((Object)GameEvent.EXPLODE, 15);
        p_154469_.put((Object)GameEvent.LIGHTNING_STRIKE, 15);
        p_154469_.put((Object)GameEvent.SHULKER_OPEN, 15);
    })));
    public static final EnumProperty<SculkSensorPhase> PHASE = BlockStateProperties.SCULK_SENSOR_PHASE;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE = Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private final int listenerRange;

    public SculkSensorBlock(BlockBehaviour.Properties pProperties, int pListenerRange) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PHASE, SculkSensorPhase.INACTIVE)).setValue(POWER, 0)).setValue(WATERLOGGED, false));
        this.listenerRange = pListenerRange;
    }

    public int getListenerRange() {
        return this.listenerRange;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.getClickedPos();
        FluidState fluidstate = pContext.getLevel().getFluidState(blockpos);
        return (BlockState)this.defaultBlockState().setValue(WATERLOGGED, fluidstate.getType() == Fluids.WATER);
    }

    @Override
    public FluidState getFluidState(BlockState pState) {
        return pState.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    @Override
    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRandom) {
        if (SculkSensorBlock.getPhase(pState) != SculkSensorPhase.ACTIVE) {
            if (SculkSensorBlock.getPhase(pState) == SculkSensorPhase.COOLDOWN) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue(PHASE, SculkSensorPhase.INACTIVE), 3);
            }
        } else {
            SculkSensorBlock.deactivate(pLevel, pPos, pState);
        }
    }

    @Override
    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pLevel.isClientSide() && !pState.is(pOldState.getBlock())) {
            if (pState.getValue(POWER) > 0 && !pLevel.getBlockTicks().hasScheduledTick(pPos, this)) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue(POWER, 0), 18);
            }
            pLevel.scheduleTick(new BlockPos(pPos), pState.getBlock(), 1);
        }
    }

    @Override
    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.is(pNewState.getBlock())) {
            if (SculkSensorBlock.getPhase(pState) == SculkSensorPhase.ACTIVE) {
                SculkSensorBlock.updateNeighbours(pLevel, pPos);
            }
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pState.getValue(WATERLOGGED).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, Fluids.WATER, Fluids.WATER.getTickDelay(pLevel));
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    private static void updateNeighbours(Level pLevel, BlockPos pPos) {
        pLevel.updateNeighborsAt(pPos, Blocks.SCULK_SENSOR);
        pLevel.updateNeighborsAt(pPos.relative(Direction.UP.getOpposite()), Blocks.SCULK_SENSOR);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new SculkSensorBlockEntity(pPos, pState);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> GameEventListener getListener(Level pLevel, T pBlockEntity) {
        return pBlockEntity instanceof SculkSensorBlockEntity ? ((SculkSensorBlockEntity)pBlockEntity).getListener() : null;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.isClientSide ? SculkSensorBlock.createTickerHelper(pBlockEntityType, BlockEntityType.SCULK_SENSOR, (p_154417_, p_154418_, p_154419_, p_154420_) -> p_154420_.getListener().tick(p_154417_)) : null;
    }

    @Override
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Override
    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    @Override
    public int getSignal(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        return pState.getValue(POWER);
    }

    public static SculkSensorPhase getPhase(BlockState pState) {
        return pState.getValue(PHASE);
    }

    public static boolean canActivate(BlockState pState) {
        return SculkSensorBlock.getPhase(pState) == SculkSensorPhase.INACTIVE;
    }

    public static void deactivate(Level pLevel, BlockPos pPos, BlockState pState) {
        pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue(PHASE, SculkSensorPhase.COOLDOWN)).setValue(POWER, 0), 3);
        pLevel.scheduleTick(new BlockPos(pPos), pState.getBlock(), 1);
        if (!pState.getValue(WATERLOGGED).booleanValue()) {
            pLevel.playSound(null, pPos, SoundEvents.SCULK_CLICKING_STOP, SoundSource.BLOCKS, 1.0f, pLevel.random.nextFloat() * 0.2f + 0.8f);
        }
        SculkSensorBlock.updateNeighbours(pLevel, pPos);
    }

    public static void activate(Level pLevel, BlockPos pPos, BlockState pState, int pPower) {
        pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue(PHASE, SculkSensorPhase.ACTIVE)).setValue(POWER, pPower), 3);
        pLevel.scheduleTick(new BlockPos(pPos), pState.getBlock(), 40);
        SculkSensorBlock.updateNeighbours(pLevel, pPos);
        if (!pState.getValue(WATERLOGGED).booleanValue()) {
            pLevel.playSound(null, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, SoundEvents.SCULK_CLICKING, SoundSource.BLOCKS, 1.0f, pLevel.random.nextFloat() * 0.2f + 0.8f);
        }
    }

    @Override
    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, Random pRandom) {
        Direction direction;
        if (SculkSensorBlock.getPhase(pState) == SculkSensorPhase.ACTIVE && (direction = Direction.getRandom(pRandom)) != Direction.UP && direction != Direction.DOWN) {
            double d0 = (double)pPos.getX() + 0.5 + (direction.getStepX() == 0 ? 0.5 - pRandom.nextDouble() : (double)direction.getStepX() * 0.6);
            double d1 = (double)pPos.getY() + 0.25;
            double d2 = (double)pPos.getZ() + 0.5 + (direction.getStepZ() == 0 ? 0.5 - pRandom.nextDouble() : (double)direction.getStepZ() * 0.6);
            double d3 = (double)pRandom.nextFloat() * 0.04;
            pLevel.addParticle(DustColorTransitionOptions.SCULK_TO_REDSTONE, d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.a(PHASE, POWER, WATERLOGGED);
    }

    @Override
    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    @Override
    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof SculkSensorBlockEntity) {
            SculkSensorBlockEntity sculksensorblockentity = (SculkSensorBlockEntity)blockentity;
            return SculkSensorBlock.getPhase(pState) == SculkSensorPhase.ACTIVE ? sculksensorblockentity.getLastVibrationFrequency() : 0;
        }
        return 0;
    }

    @Override
    public boolean isPathfindable(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Override
    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }
}

