/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BigDripleafBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SmallDripleafBlock
extends DoublePlantBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.box(2.0, 0.0, 2.0, 14.0, 13.0, 14.0);

    public SmallDripleafBlock(BlockBehaviour.Properties p_154583_) {
        super(p_154583_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, DoubleBlockHalf.LOWER)).setValue(WATERLOGGED, false)).setValue(FACING, Direction.NORTH));
    }

    @Override
    public VoxelShape getShape(BlockState p_154610_, BlockGetter p_154611_, BlockPos p_154612_, CollisionContext p_154613_) {
        return SHAPE;
    }

    @Override
    protected boolean mayPlaceOn(BlockState p_154636_, BlockGetter p_154637_, BlockPos p_154638_) {
        return p_154636_.is(BlockTags.SMALL_DRIPLEAF_PLACEABLE) || p_154637_.getFluidState(p_154638_.above()).isSourceOfType(Fluids.WATER) && super.mayPlaceOn(p_154636_, p_154637_, p_154638_);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_154592_) {
        BlockState blockstate = super.getStateForPlacement(p_154592_);
        return blockstate != null ? SmallDripleafBlock.copyWaterloggedFrom(p_154592_.getLevel(), p_154592_.getClickedPos(), (BlockState)blockstate.setValue(FACING, p_154592_.getHorizontalDirection().getOpposite())) : null;
    }

    @Override
    public void setPlacedBy(Level p_154599_, BlockPos p_154600_, BlockState p_154601_, LivingEntity p_154602_, ItemStack p_154603_) {
        if (!p_154599_.isClientSide()) {
            BlockPos blockpos = p_154600_.above();
            BlockState blockstate = DoublePlantBlock.copyWaterloggedFrom(p_154599_, blockpos, (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, DoubleBlockHalf.UPPER)).setValue(FACING, p_154601_.getValue(FACING)));
            p_154599_.setBlock(blockpos, blockstate, 3);
        }
    }

    @Override
    public FluidState getFluidState(BlockState p_154634_) {
        return p_154634_.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_154634_);
    }

    @Override
    public boolean canSurvive(BlockState p_154615_, LevelReader p_154616_, BlockPos p_154617_) {
        if (p_154615_.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return super.canSurvive(p_154615_, p_154616_, p_154617_);
        }
        BlockPos blockpos = p_154617_.below();
        BlockState blockstate = p_154616_.getBlockState(blockpos);
        return this.mayPlaceOn(blockstate, p_154616_, blockpos);
    }

    @Override
    public BlockState updateShape(BlockState p_154625_, Direction p_154626_, BlockState p_154627_, LevelAccessor p_154628_, BlockPos p_154629_, BlockPos p_154630_) {
        if (p_154625_.getValue(WATERLOGGED).booleanValue()) {
            p_154628_.scheduleTick(p_154629_, Fluids.WATER, Fluids.WATER.getTickDelay(p_154628_));
        }
        return super.updateShape(p_154625_, p_154626_, p_154627_, p_154628_, p_154629_, p_154630_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_154632_) {
        p_154632_.a(HALF, WATERLOGGED, FACING);
    }

    @Override
    public boolean isValidBonemealTarget(BlockGetter p_154594_, BlockPos p_154595_, BlockState p_154596_, boolean p_154597_) {
        return true;
    }

    @Override
    public boolean isBonemealSuccess(Level p_154605_, Random p_154606_, BlockPos p_154607_, BlockState p_154608_) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel p_154587_, Random p_154588_, BlockPos p_154589_, BlockState p_154590_) {
        if (p_154590_.getValue(DoublePlantBlock.HALF) == DoubleBlockHalf.LOWER) {
            BlockPos blockpos = p_154589_.above();
            p_154587_.setBlock(blockpos, p_154587_.getFluidState(blockpos).createLegacyBlock(), 18);
            BigDripleafBlock.placeWithRandomHeight(p_154587_, p_154588_, p_154589_, p_154590_.getValue(FACING));
        } else {
            BlockPos blockpos1 = p_154589_.below();
            this.performBonemeal(p_154587_, p_154588_, blockpos1, p_154587_.getBlockState(blockpos1));
        }
    }

    @Override
    public BlockState rotate(BlockState p_154622_, Rotation p_154623_) {
        return (BlockState)p_154622_.setValue(FACING, p_154623_.rotate(p_154622_.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState p_154619_, Mirror p_154620_) {
        return p_154619_.rotate(p_154620_.getRotation(p_154619_.getValue(FACING)));
    }

    @Override
    public BlockBehaviour.OffsetType getOffsetType() {
        return BlockBehaviour.OffsetType.XYZ;
    }

    @Override
    public float getMaxVerticalOffset() {
        return 0.1f;
    }
}

