/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class TargetBlock
extends Block {
    private static final IntegerProperty OUTPUT_POWER = BlockStateProperties.POWER;
    private static final int ACTIVATION_TICKS_ARROWS = 20;
    private static final int ACTIVATION_TICKS_OTHER = 8;

    public TargetBlock(BlockBehaviour.Properties p_57379_) {
        super(p_57379_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(OUTPUT_POWER, 0));
    }

    @Override
    public void onProjectileHit(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        int i = TargetBlock.updateRedstoneOutput(pLevel, pState, pHit, pProjectile);
        Entity entity = pProjectile.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.awardStat(Stats.TARGET_HIT);
            CriteriaTriggers.TARGET_BLOCK_HIT.trigger(serverplayer, pProjectile, pHit.getLocation(), i);
        }
    }

    private static int updateRedstoneOutput(LevelAccessor pLevel, BlockState pState, BlockHitResult pHit, Entity pProjectile) {
        int j;
        int i = TargetBlock.getRedstoneStrength(pHit, pHit.getLocation());
        int n = j = pProjectile instanceof AbstractArrow ? 20 : 8;
        if (!pLevel.getBlockTicks().hasScheduledTick(pHit.getBlockPos(), pState.getBlock())) {
            TargetBlock.setOutputPower(pLevel, pState, i, pHit.getBlockPos(), j);
        }
        return i;
    }

    private static int getRedstoneStrength(BlockHitResult pHit, Vec3 pHitLocation) {
        Direction direction = pHit.getDirection();
        double d0 = Math.abs(Mth.frac(pHitLocation.x) - 0.5);
        double d1 = Math.abs(Mth.frac(pHitLocation.y) - 0.5);
        double d2 = Math.abs(Mth.frac(pHitLocation.z) - 0.5);
        Direction.Axis direction$axis = direction.getAxis();
        double d3 = direction$axis == Direction.Axis.Y ? Math.max(d0, d2) : (direction$axis == Direction.Axis.Z ? Math.max(d0, d1) : Math.max(d1, d2));
        return Math.max(1, Mth.ceil(15.0 * Mth.clamp((0.5 - d3) / 0.5, 0.0, 1.0)));
    }

    private static void setOutputPower(LevelAccessor pLevel, BlockState pState, int pPower, BlockPos pPos, int pWaitTime) {
        pLevel.setBlock(pPos, (BlockState)pState.setValue(OUTPUT_POWER, pPower), 3);
        pLevel.scheduleTick(pPos, pState.getBlock(), pWaitTime);
    }

    @Override
    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRand) {
        if (pState.getValue(OUTPUT_POWER) != 0) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue(OUTPUT_POWER, 0), 3);
        }
    }

    @Override
    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return pBlockState.getValue(OUTPUT_POWER);
    }

    @Override
    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.a(OUTPUT_POWER);
    }

    @Override
    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!(pLevel.isClientSide() || pState.is(pOldState.getBlock()) || pState.getValue(OUTPUT_POWER) <= 0 || pLevel.getBlockTicks().hasScheduledTick(pPos, this))) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue(OUTPUT_POWER, 0), 18);
        }
    }
}

