/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TripWireBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    public static final BooleanProperty DISARMED = BlockStateProperties.DISARMED;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = CrossCollisionBlock.PROPERTY_BY_DIRECTION;
    protected static final VoxelShape AABB = Block.box(0.0, 1.0, 0.0, 16.0, 2.5, 16.0);
    protected static final VoxelShape NOT_ATTACHED_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private static final int RECHECK_PERIOD = 10;
    private final TripWireHookBlock hook;

    public TripWireBlock(TripWireHookBlock pHook, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(POWERED, false)).setValue(ATTACHED, false)).setValue(DISARMED, false)).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false));
        this.hook = pHook;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return pState.getValue(ATTACHED) != false ? AABB : NOT_ATTACHED_AABB;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level blockgetter = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, this.shouldConnectTo(blockgetter.getBlockState(blockpos.north()), Direction.NORTH))).setValue(EAST, this.shouldConnectTo(blockgetter.getBlockState(blockpos.east()), Direction.EAST))).setValue(SOUTH, this.shouldConnectTo(blockgetter.getBlockState(blockpos.south()), Direction.SOUTH))).setValue(WEST, this.shouldConnectTo(blockgetter.getBlockState(blockpos.west()), Direction.WEST));
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing.getAxis().isHorizontal() ? (BlockState)pState.setValue(PROPERTY_BY_DIRECTION.get(pFacing), this.shouldConnectTo(pFacingState, pFacing)) : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @Override
    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.is(pState.getBlock())) {
            this.updateSource(pLevel, pPos, pState);
        }
    }

    @Override
    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pIsMoving && !pState.is(pNewState.getBlock())) {
            this.updateSource(pLevel, pPos, (BlockState)pState.setValue(POWERED, true));
        }
    }

    @Override
    public void playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.isClientSide && !pPlayer.getMainHandItem().isEmpty() && pPlayer.getMainHandItem().is(Items.SHEARS)) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue(DISARMED, true), 4);
            pLevel.gameEvent((Entity)pPlayer, GameEvent.SHEAR, pPos);
        }
        super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    private void updateSource(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction[] directionArray = new Direction[]{Direction.SOUTH, Direction.WEST};
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            int i = 1;
            while (i < 42) {
                BlockPos blockpos = pPos.relative(direction, i);
                BlockState blockstate = pLevel.getBlockState(blockpos);
                if (blockstate.is(this.hook)) {
                    if (blockstate.getValue(TripWireHookBlock.FACING) != direction.getOpposite()) break;
                    this.hook.calculateState(pLevel, blockpos, blockstate, false, true, i, pState);
                    break;
                }
                if (!blockstate.is(this)) break;
                ++i;
            }
            ++n2;
        }
    }

    @Override
    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pLevel.isClientSide && !pState.getValue(POWERED).booleanValue()) {
            this.checkPressed(pLevel, pPos);
        }
    }

    @Override
    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRand) {
        if (pLevel.getBlockState(pPos).getValue(POWERED).booleanValue()) {
            this.checkPressed(pLevel, pPos);
        }
    }

    private void checkPressed(Level pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        boolean flag = blockstate.getValue(POWERED);
        boolean flag1 = false;
        List<Entity> list = pLevel.getEntities(null, blockstate.getShape(pLevel, pPos).bounds().move(pPos));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.isIgnoringBlockTriggers()) continue;
                flag1 = true;
                break;
            }
        }
        if (flag1 != flag) {
            blockstate = (BlockState)blockstate.setValue(POWERED, flag1);
            pLevel.setBlock(pPos, blockstate, 3);
            this.updateSource(pLevel, pPos, blockstate);
        }
        if (flag1) {
            pLevel.scheduleTick(new BlockPos(pPos), this, 10);
        }
    }

    public boolean shouldConnectTo(BlockState pState, Direction pDirection) {
        if (pState.is(this.hook)) {
            return pState.getValue(TripWireHookBlock.FACING) == pDirection.getOpposite();
        }
        return pState.is(this);
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRot) {
        switch (pRot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(SOUTH))).setValue(EAST, pState.getValue(WEST))).setValue(SOUTH, pState.getValue(NORTH))).setValue(WEST, pState.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(EAST))).setValue(EAST, pState.getValue(SOUTH))).setValue(SOUTH, pState.getValue(WEST))).setValue(WEST, pState.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(WEST))).setValue(EAST, pState.getValue(NORTH))).setValue(SOUTH, pState.getValue(EAST))).setValue(WEST, pState.getValue(SOUTH));
            }
        }
        return pState;
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        switch (pMirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(SOUTH))).setValue(SOUTH, pState.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)pState.setValue(EAST, pState.getValue(WEST))).setValue(WEST, pState.getValue(EAST));
            }
        }
        return super.mirror(pState, pMirror);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.a(POWERED, ATTACHED, DISARMED, NORTH, EAST, WEST, SOUTH);
    }
}

