/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.base.MoreObjects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TripWireHookBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    protected static final int WIRE_DIST_MIN = 1;
    protected static final int WIRE_DIST_MAX = 42;
    private static final int RECHECK_PERIOD = 10;
    protected static final int AABB_OFFSET = 3;
    protected static final VoxelShape NORTH_AABB = Block.box(5.0, 0.0, 10.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box(5.0, 0.0, 0.0, 11.0, 10.0, 6.0);
    protected static final VoxelShape WEST_AABB = Block.box(10.0, 0.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape EAST_AABB = Block.box(0.0, 0.0, 5.0, 6.0, 10.0, 11.0);

    public TripWireHookBlock(BlockBehaviour.Properties p_57676_) {
        super(p_57676_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(POWERED, false)).setValue(ATTACHED, false));
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch (pState.getValue(FACING)) {
            default: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: 
        }
        return NORTH_AABB;
    }

    @Override
    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = pState.getValue(FACING);
        BlockPos blockpos = pPos.relative(direction.getOpposite());
        BlockState blockstate = pLevel.getBlockState(blockpos);
        return direction.getAxis().isHorizontal() && blockstate.isFaceSturdy(pLevel, blockpos, direction);
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing.getOpposite() == pState.getValue(FACING) && !pState.canSurvive(pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction[] adirection;
        BlockState blockstate = (BlockState)((BlockState)this.defaultBlockState().setValue(POWERED, false)).setValue(ATTACHED, false);
        Level levelreader = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        Direction[] directionArray = adirection = pContext.getNearestLookingDirections();
        int n = adirection.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction1;
            Direction direction = directionArray[n2];
            if (direction.getAxis().isHorizontal() && (blockstate = (BlockState)blockstate.setValue(FACING, direction1 = direction.getOpposite())).canSurvive(levelreader, blockpos)) {
                return blockstate;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        this.calculateState(pLevel, pPos, pState, false, false, -1, null);
    }

    public void calculateState(Level pLevel, BlockPos pPos, BlockState pHookState, boolean pAttaching, boolean pShouldNotifyNeighbours, int pSearchRange, @Nullable BlockState pState) {
        Direction direction = pHookState.getValue(FACING);
        boolean flag = pHookState.getValue(ATTACHED);
        boolean flag1 = pHookState.getValue(POWERED);
        boolean flag2 = !pAttaching;
        boolean flag3 = false;
        int i = 0;
        BlockState[] ablockstate = new BlockState[42];
        int j = 1;
        while (j < 42) {
            BlockPos blockpos = pPos.relative(direction, j);
            BlockState blockstate = pLevel.getBlockState(blockpos);
            if (blockstate.is(Blocks.TRIPWIRE_HOOK)) {
                if (blockstate.getValue(FACING) != direction.getOpposite()) break;
                i = j;
                break;
            }
            if (!blockstate.is(Blocks.TRIPWIRE) && j != pSearchRange) {
                ablockstate[j] = null;
                flag2 = false;
            } else {
                if (j == pSearchRange) {
                    blockstate = (BlockState)MoreObjects.firstNonNull((Object)pState, (Object)blockstate);
                }
                boolean flag4 = blockstate.getValue(TripWireBlock.DISARMED) == false;
                boolean flag5 = blockstate.getValue(TripWireBlock.POWERED);
                flag3 |= flag4 && flag5;
                ablockstate[j] = blockstate;
                if (j == pSearchRange) {
                    pLevel.scheduleTick(pPos, this, 10);
                    flag2 &= flag4;
                }
            }
            ++j;
        }
        BlockState blockstate1 = (BlockState)((BlockState)this.defaultBlockState().setValue(ATTACHED, flag2)).setValue(POWERED, flag3 &= (flag2 &= i > 1));
        if (i > 0) {
            BlockPos blockpos1 = pPos.relative(direction, i);
            Direction direction1 = direction.getOpposite();
            pLevel.setBlock(blockpos1, (BlockState)blockstate1.setValue(FACING, direction1), 3);
            this.notifyNeighbors(pLevel, blockpos1, direction1);
            this.playSound(pLevel, blockpos1, flag2, flag3, flag, flag1);
        }
        this.playSound(pLevel, pPos, flag2, flag3, flag, flag1);
        if (!pAttaching) {
            pLevel.setBlock(pPos, (BlockState)blockstate1.setValue(FACING, direction), 3);
            if (pShouldNotifyNeighbours) {
                this.notifyNeighbors(pLevel, pPos, direction);
            }
        }
        if (flag != flag2) {
            int k = 1;
            while (k < i) {
                BlockPos blockpos2 = pPos.relative(direction, k);
                BlockState blockstate2 = ablockstate[k];
                if (blockstate2 != null) {
                    pLevel.setBlock(blockpos2, (BlockState)blockstate2.setValue(ATTACHED, flag2), 3);
                    pLevel.getBlockState(blockpos2).isAir();
                }
                ++k;
            }
        }
    }

    @Override
    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRandom) {
        this.calculateState(pLevel, pPos, pState, false, true, -1, null);
    }

    private void playSound(Level pLevel, BlockPos pPos, boolean pAttaching, boolean pActivated, boolean pDetaching, boolean pDeactivating) {
        if (pActivated && !pDeactivating) {
            pLevel.playSound(null, pPos, SoundEvents.TRIPWIRE_CLICK_ON, SoundSource.BLOCKS, 0.4f, 0.6f);
            pLevel.gameEvent(GameEvent.BLOCK_PRESS, pPos);
        } else if (!pActivated && pDeactivating) {
            pLevel.playSound(null, pPos, SoundEvents.TRIPWIRE_CLICK_OFF, SoundSource.BLOCKS, 0.4f, 0.5f);
            pLevel.gameEvent(GameEvent.BLOCK_UNPRESS, pPos);
        } else if (pAttaching && !pDetaching) {
            pLevel.playSound(null, pPos, SoundEvents.TRIPWIRE_ATTACH, SoundSource.BLOCKS, 0.4f, 0.7f);
            pLevel.gameEvent(GameEvent.BLOCK_ATTACH, pPos);
        } else if (!pAttaching && pDetaching) {
            pLevel.playSound(null, pPos, SoundEvents.TRIPWIRE_DETACH, SoundSource.BLOCKS, 0.4f, 1.2f / (pLevel.random.nextFloat() * 0.2f + 0.9f));
            pLevel.gameEvent(GameEvent.BLOCK_DETACH, pPos);
        }
    }

    private void notifyNeighbors(Level pLevel, BlockPos pPos, Direction pDirection) {
        pLevel.updateNeighborsAt(pPos, this);
        pLevel.updateNeighborsAt(pPos.relative(pDirection.getOpposite()), this);
    }

    @Override
    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pIsMoving && !pState.is(pNewState.getBlock())) {
            boolean flag = pState.getValue(ATTACHED);
            boolean flag1 = pState.getValue(POWERED);
            if (flag || flag1) {
                this.calculateState(pLevel, pPos, pState, true, false, -1, null);
            }
            if (flag1) {
                pLevel.updateNeighborsAt(pPos, this);
                pLevel.updateNeighborsAt(pPos.relative(pState.getValue(FACING).getOpposite()), this);
            }
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    @Override
    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return pBlockState.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    public int getDirectSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        if (!pBlockState.getValue(POWERED).booleanValue()) {
            return 0;
        }
        return pBlockState.getValue(FACING) == pSide ? 15 : 0;
    }

    @Override
    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue(FACING, pRotation.rotate(pState.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation(pState.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.a(FACING, POWERED, ATTACHED);
    }
}

