/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VineBlock
extends Block {
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(p_57886_ -> p_57886_.getKey() != Direction.DOWN).collect(Util.toMap());
    protected static final float AABB_OFFSET = 1.0f;
    private static final VoxelShape UP_AABB = Block.box(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape WEST_AABB = Block.box(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape EAST_AABB = Block.box(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public VineBlock(BlockBehaviour.Properties p_57847_) {
        super(p_57847_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(UP, false)).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false));
        this.shapesCache = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), VineBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState p_57906_) {
        VoxelShape voxelshape = Shapes.empty();
        if (p_57906_.getValue(UP).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (p_57906_.getValue(NORTH).booleanValue()) {
            voxelshape = Shapes.or(voxelshape, NORTH_AABB);
        }
        if (p_57906_.getValue(SOUTH).booleanValue()) {
            voxelshape = Shapes.or(voxelshape, SOUTH_AABB);
        }
        if (p_57906_.getValue(EAST).booleanValue()) {
            voxelshape = Shapes.or(voxelshape, EAST_AABB);
        }
        if (p_57906_.getValue(WEST).booleanValue()) {
            voxelshape = Shapes.or(voxelshape, WEST_AABB);
        }
        return voxelshape.isEmpty() ? Shapes.block() : voxelshape;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapesCache.get(pState);
    }

    @Override
    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    @Override
    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return this.hasFaces(this.getUpdatedState(pState, pLevel, pPos));
    }

    private boolean hasFaces(BlockState pState) {
        return this.countFaces(pState) > 0;
    }

    private int countFaces(BlockState pState) {
        int i = 0;
        for (BooleanProperty booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!pState.getValue(booleanproperty).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean canSupportAtFace(BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        if (pDirection == Direction.DOWN) {
            return false;
        }
        BlockPos blockpos = pPos.relative(pDirection);
        if (VineBlock.isAcceptableNeighbour(pLevel, blockpos, pDirection)) {
            return true;
        }
        if (pDirection.getAxis() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(pDirection);
        BlockState blockstate = pLevel.getBlockState(pPos.above());
        return blockstate.is(this) && blockstate.getValue(booleanproperty) != false;
    }

    public static boolean isAcceptableNeighbour(BlockGetter pBlockReader, BlockPos pLevel, Direction pNeighborPos) {
        BlockState blockstate = pBlockReader.getBlockState(pLevel);
        return Block.isFaceFull(blockstate.getCollisionShape(pBlockReader, pLevel), pNeighborPos.getOpposite());
    }

    private BlockState getUpdatedState(BlockState p_57902_, BlockGetter p_57903_, BlockPos p_57904_) {
        BlockPos blockpos = p_57904_.above();
        if (p_57902_.getValue(UP).booleanValue()) {
            p_57902_ = (BlockState)p_57902_.setValue(UP, VineBlock.isAcceptableNeighbour(p_57903_, blockpos, Direction.DOWN));
        }
        BlockBehaviour.BlockStateBase blockstate = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = VineBlock.getPropertyForFace(direction);
            if (!p_57902_.getValue(booleanproperty).booleanValue()) continue;
            boolean flag = this.canSupportAtFace(p_57903_, p_57904_, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = p_57903_.getBlockState(blockpos);
                }
                flag = blockstate.is(this) && blockstate.getValue(booleanproperty) != false;
            }
            p_57902_ = (BlockState)p_57902_.setValue(booleanproperty, flag);
        }
        return p_57902_;
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == Direction.DOWN) {
            return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        BlockState blockstate = this.getUpdatedState(pState, pLevel, pCurrentPos);
        return !this.hasFaces(blockstate) ? Blocks.AIR.defaultBlockState() : blockstate;
    }

    @Override
    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRandom) {
        if (pRandom.nextInt(4) == 0) {
            Direction direction = Direction.getRandom(pRandom);
            BlockPos blockpos = pPos.above();
            if (direction.getAxis().isHorizontal() && !pState.getValue(VineBlock.getPropertyForFace(direction)).booleanValue()) {
                if (this.canSpread(pLevel, pPos)) {
                    BlockPos blockpos4 = pPos.relative(direction);
                    BlockState blockstate4 = pLevel.getBlockState(blockpos4);
                    if (blockstate4.isAir()) {
                        Direction direction3 = direction.getClockWise();
                        Direction direction4 = direction.getCounterClockWise();
                        boolean flag = pState.getValue(VineBlock.getPropertyForFace(direction3));
                        boolean flag1 = pState.getValue(VineBlock.getPropertyForFace(direction4));
                        BlockPos blockpos2 = blockpos4.relative(direction3);
                        BlockPos blockpos3 = blockpos4.relative(direction4);
                        if (flag && VineBlock.isAcceptableNeighbour(pLevel, blockpos2, direction3)) {
                            pLevel.setBlock(blockpos4, (BlockState)this.defaultBlockState().setValue(VineBlock.getPropertyForFace(direction3), true), 2);
                        } else if (flag1 && VineBlock.isAcceptableNeighbour(pLevel, blockpos3, direction4)) {
                            pLevel.setBlock(blockpos4, (BlockState)this.defaultBlockState().setValue(VineBlock.getPropertyForFace(direction4), true), 2);
                        } else {
                            Direction direction1 = direction.getOpposite();
                            if (flag && pLevel.isEmptyBlock(blockpos2) && VineBlock.isAcceptableNeighbour(pLevel, pPos.relative(direction3), direction1)) {
                                pLevel.setBlock(blockpos2, (BlockState)this.defaultBlockState().setValue(VineBlock.getPropertyForFace(direction1), true), 2);
                            } else if (flag1 && pLevel.isEmptyBlock(blockpos3) && VineBlock.isAcceptableNeighbour(pLevel, pPos.relative(direction4), direction1)) {
                                pLevel.setBlock(blockpos3, (BlockState)this.defaultBlockState().setValue(VineBlock.getPropertyForFace(direction1), true), 2);
                            } else if ((double)pRandom.nextFloat() < 0.05 && VineBlock.isAcceptableNeighbour(pLevel, blockpos4.above(), Direction.UP)) {
                                pLevel.setBlock(blockpos4, (BlockState)this.defaultBlockState().setValue(UP, true), 2);
                            }
                        }
                    } else if (VineBlock.isAcceptableNeighbour(pLevel, blockpos4, direction)) {
                        pLevel.setBlock(pPos, (BlockState)pState.setValue(VineBlock.getPropertyForFace(direction), true), 2);
                    }
                }
            } else {
                BlockState blockstate2;
                BlockState blockstate1;
                BlockPos blockpos1;
                BlockState blockstate;
                if (direction == Direction.UP && pPos.getY() < pLevel.getMaxBuildHeight() - 1) {
                    if (this.canSupportAtFace(pLevel, pPos, direction)) {
                        pLevel.setBlock(pPos, (BlockState)pState.setValue(UP, true), 2);
                        return;
                    }
                    if (pLevel.isEmptyBlock(blockpos)) {
                        if (!this.canSpread(pLevel, pPos)) {
                            return;
                        }
                        BlockState blockstate3 = pState;
                        for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                            if (!pRandom.nextBoolean() && VineBlock.isAcceptableNeighbour(pLevel, blockpos.relative(direction2), direction2)) continue;
                            blockstate3 = (BlockState)blockstate3.setValue(VineBlock.getPropertyForFace(direction2), false);
                        }
                        if (this.hasHorizontalConnection(blockstate3)) {
                            pLevel.setBlock(blockpos, blockstate3, 2);
                        }
                        return;
                    }
                }
                if (pPos.getY() > pLevel.getMinBuildHeight() && ((blockstate = pLevel.getBlockState(blockpos1 = pPos.below())).isAir() || blockstate.is(this)) && (blockstate1 = blockstate.isAir() ? this.defaultBlockState() : blockstate) != (blockstate2 = this.copyRandomFaces(pState, blockstate1, pRandom)) && this.hasHorizontalConnection(blockstate2)) {
                    pLevel.setBlock(blockpos1, blockstate2, 2);
                }
            }
        }
    }

    private BlockState copyRandomFaces(BlockState p_57871_, BlockState p_57872_, Random p_57873_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty;
            if (!p_57873_.nextBoolean() || !p_57871_.getValue(booleanproperty = VineBlock.getPropertyForFace(direction)).booleanValue()) continue;
            p_57872_ = (BlockState)p_57872_.setValue(booleanproperty, true);
        }
        return p_57872_;
    }

    private boolean hasHorizontalConnection(BlockState pState) {
        return pState.getValue(NORTH) != false || pState.getValue(EAST) != false || pState.getValue(SOUTH) != false || pState.getValue(WEST) != false;
    }

    private boolean canSpread(BlockGetter pBlockReader, BlockPos pPos) {
        int i = 4;
        Iterable<BlockPos> iterable = BlockPos.betweenClosed(pPos.getX() - 4, pPos.getY() - 1, pPos.getZ() - 4, pPos.getX() + 4, pPos.getY() + 1, pPos.getZ() + 4);
        int j = 5;
        for (BlockPos blockpos : iterable) {
            if (!pBlockReader.getBlockState(blockpos).is(this) || --j > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        BlockState blockstate = pUseContext.getLevel().getBlockState(pUseContext.getClickedPos());
        if (blockstate.is(this)) {
            return this.countFaces(blockstate) < PROPERTY_BY_DIRECTION.size();
        }
        return super.canBeReplaced(pState, pUseContext);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState blockstate = pContext.getLevel().getBlockState(pContext.getClickedPos());
        boolean flag = blockstate.is(this);
        BlockState blockstate1 = flag ? blockstate : this.defaultBlockState();
        Direction[] directionArray = pContext.getNearestLookingDirections();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            if (direction != Direction.DOWN) {
                boolean flag1;
                BooleanProperty booleanproperty = VineBlock.getPropertyForFace(direction);
                boolean bl = flag1 = flag && blockstate.getValue(booleanproperty) != false;
                if (!flag1 && this.canSupportAtFace(pContext.getLevel(), pContext.getClickedPos(), direction)) {
                    return (BlockState)blockstate1.setValue(booleanproperty, true);
                }
            }
            ++n2;
        }
        return flag ? blockstate1 : null;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.a(UP, NORTH, EAST, SOUTH, WEST);
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRotate) {
        switch (pRotate) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(SOUTH))).setValue(EAST, pState.getValue(WEST))).setValue(SOUTH, pState.getValue(NORTH))).setValue(WEST, pState.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(EAST))).setValue(EAST, pState.getValue(SOUTH))).setValue(SOUTH, pState.getValue(WEST))).setValue(WEST, pState.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(WEST))).setValue(EAST, pState.getValue(NORTH))).setValue(SOUTH, pState.getValue(EAST))).setValue(WEST, pState.getValue(SOUTH));
            }
        }
        return pState;
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        switch (pMirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)pState.setValue(NORTH, pState.getValue(SOUTH))).setValue(SOUTH, pState.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)pState.setValue(EAST, pState.getValue(WEST))).setValue(WEST, pState.getValue(EAST));
            }
        }
        return super.mirror(pState, pMirror);
    }

    public static BooleanProperty getPropertyForFace(Direction pFace) {
        return PROPERTY_BY_DIRECTION.get(pFace);
    }
}

