/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final EnumProperty<WallSide> EAST_WALL = BlockStateProperties.EAST_WALL;
    public static final EnumProperty<WallSide> NORTH_WALL = BlockStateProperties.NORTH_WALL;
    public static final EnumProperty<WallSide> SOUTH_WALL = BlockStateProperties.SOUTH_WALL;
    public static final EnumProperty<WallSide> WEST_WALL = BlockStateProperties.WEST_WALL;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;
    private static final int WALL_WIDTH = 3;
    private static final int WALL_HEIGHT = 14;
    private static final int POST_WIDTH = 4;
    private static final int POST_COVER_WIDTH = 1;
    private static final int WALL_COVER_START = 7;
    private static final int WALL_COVER_END = 9;
    private static final VoxelShape POST_TEST = Block.box(7.0, 0.0, 7.0, 9.0, 16.0, 9.0);
    private static final VoxelShape NORTH_TEST = Block.box(7.0, 0.0, 0.0, 9.0, 16.0, 9.0);
    private static final VoxelShape SOUTH_TEST = Block.box(7.0, 0.0, 7.0, 9.0, 16.0, 16.0);
    private static final VoxelShape WEST_TEST = Block.box(0.0, 0.0, 7.0, 9.0, 16.0, 9.0);
    private static final VoxelShape EAST_TEST = Block.box(7.0, 0.0, 7.0, 16.0, 16.0, 9.0);

    public WallBlock(BlockBehaviour.Properties p_57964_) {
        super(p_57964_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(UP, true)).setValue(NORTH_WALL, WallSide.NONE)).setValue(EAST_WALL, WallSide.NONE)).setValue(SOUTH_WALL, WallSide.NONE)).setValue(WEST_WALL, WallSide.NONE)).setValue(WATERLOGGED, false));
        this.shapeByIndex = this.makeShapes(4.0f, 3.0f, 16.0f, 0.0f, 14.0f, 16.0f);
        this.collisionShapeByIndex = this.makeShapes(4.0f, 3.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    private static VoxelShape applyWallShape(VoxelShape pBaseShape, WallSide pHeight, VoxelShape pLowShape, VoxelShape pTallShape) {
        if (pHeight == WallSide.TALL) {
            return Shapes.or(pBaseShape, pTallShape);
        }
        return pHeight == WallSide.LOW ? Shapes.or(pBaseShape, pLowShape) : pBaseShape;
    }

    private Map<BlockState, VoxelShape> makeShapes(float p_57966_, float p_57967_, float p_57968_, float p_57969_, float p_57970_, float p_57971_) {
        float f = 8.0f - p_57966_;
        float f1 = 8.0f + p_57966_;
        float f2 = 8.0f - p_57967_;
        float f3 = 8.0f + p_57967_;
        VoxelShape voxelshape = Block.box(f, 0.0, f, f1, p_57968_, f1);
        VoxelShape voxelshape1 = Block.box(f2, p_57969_, 0.0, f3, p_57970_, f3);
        VoxelShape voxelshape2 = Block.box(f2, p_57969_, f2, f3, p_57970_, 16.0);
        VoxelShape voxelshape3 = Block.box(0.0, p_57969_, f2, f3, p_57970_, f3);
        VoxelShape voxelshape4 = Block.box(f2, p_57969_, f2, 16.0, p_57970_, f3);
        VoxelShape voxelshape5 = Block.box(f2, p_57969_, 0.0, f3, p_57971_, f3);
        VoxelShape voxelshape6 = Block.box(f2, p_57969_, f2, f3, p_57971_, 16.0);
        VoxelShape voxelshape7 = Block.box(0.0, p_57969_, f2, f3, p_57971_, f3);
        VoxelShape voxelshape8 = Block.box(f2, p_57969_, f2, 16.0, p_57971_, f3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean obool : UP.getPossibleValues()) {
            for (WallSide wallside : EAST_WALL.getPossibleValues()) {
                for (WallSide wallside1 : NORTH_WALL.getPossibleValues()) {
                    for (WallSide wallside2 : WEST_WALL.getPossibleValues()) {
                        for (WallSide wallside3 : SOUTH_WALL.getPossibleValues()) {
                            VoxelShape voxelshape9 = Shapes.empty();
                            voxelshape9 = WallBlock.applyWallShape(voxelshape9, wallside, voxelshape4, voxelshape8);
                            voxelshape9 = WallBlock.applyWallShape(voxelshape9, wallside2, voxelshape3, voxelshape7);
                            voxelshape9 = WallBlock.applyWallShape(voxelshape9, wallside1, voxelshape1, voxelshape5);
                            voxelshape9 = WallBlock.applyWallShape(voxelshape9, wallside3, voxelshape2, voxelshape6);
                            if (obool.booleanValue()) {
                                voxelshape9 = Shapes.or(voxelshape9, voxelshape);
                            }
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(UP, obool)).setValue(EAST_WALL, wallside)).setValue(WEST_WALL, wallside2)).setValue(NORTH_WALL, wallside1)).setValue(SOUTH_WALL, wallside3);
                            builder.put((Object)((BlockState)blockstate.setValue(WATERLOGGED, false)), (Object)voxelshape9);
                            builder.put((Object)((BlockState)blockstate.setValue(WATERLOGGED, true)), (Object)voxelshape9);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeByIndex.get(pState);
    }

    @Override
    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.collisionShapeByIndex.get(pState);
    }

    @Override
    public boolean isPathfindable(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    private boolean connectsTo(BlockState pState, boolean pSideSolid, Direction pDirection) {
        boolean flag;
        Block block = pState.getBlock();
        boolean bl = flag = block instanceof FenceGateBlock && FenceGateBlock.connectsToDirection(pState, pDirection);
        return pState.is(BlockTags.WALLS) || !WallBlock.isExceptionForConnection(pState) && pSideSolid || block instanceof IronBarsBlock || flag;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level levelreader = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        BlockPos blockpos1 = blockpos.north();
        BlockPos blockpos2 = blockpos.east();
        BlockPos blockpos3 = blockpos.south();
        BlockPos blockpos4 = blockpos.west();
        BlockPos blockpos5 = blockpos.above();
        BlockState blockstate = levelreader.getBlockState(blockpos1);
        BlockState blockstate1 = levelreader.getBlockState(blockpos2);
        BlockState blockstate2 = levelreader.getBlockState(blockpos3);
        BlockState blockstate3 = levelreader.getBlockState(blockpos4);
        BlockState blockstate4 = levelreader.getBlockState(blockpos5);
        boolean flag = this.connectsTo(blockstate, blockstate.isFaceSturdy(levelreader, blockpos1, Direction.SOUTH), Direction.SOUTH);
        boolean flag1 = this.connectsTo(blockstate1, blockstate1.isFaceSturdy(levelreader, blockpos2, Direction.WEST), Direction.WEST);
        boolean flag2 = this.connectsTo(blockstate2, blockstate2.isFaceSturdy(levelreader, blockpos3, Direction.NORTH), Direction.NORTH);
        boolean flag3 = this.connectsTo(blockstate3, blockstate3.isFaceSturdy(levelreader, blockpos4, Direction.EAST), Direction.EAST);
        BlockState blockstate5 = (BlockState)this.defaultBlockState().setValue(WATERLOGGED, fluidstate.getType() == Fluids.WATER);
        return this.updateShape(levelreader, blockstate5, blockpos5, blockstate4, flag, flag1, flag2, flag3);
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pState.getValue(WATERLOGGED).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, Fluids.WATER, Fluids.WATER.getTickDelay(pLevel));
        }
        if (pFacing == Direction.DOWN) {
            return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        return pFacing == Direction.UP ? this.topUpdate(pLevel, pState, pFacingPos, pFacingState) : this.sideUpdate(pLevel, pCurrentPos, pState, pFacingPos, pFacingState, pFacing);
    }

    private static boolean isConnected(BlockState pState, Property<WallSide> pHeightProperty) {
        return pState.getValue(pHeightProperty) != WallSide.NONE;
    }

    private static boolean isCovered(VoxelShape pShape1, VoxelShape pShape2) {
        return !Shapes.joinIsNotEmpty(pShape2, pShape1, BooleanOp.ONLY_FIRST);
    }

    private BlockState topUpdate(LevelReader p_57975_, BlockState p_57976_, BlockPos p_57977_, BlockState p_57978_) {
        boolean flag = WallBlock.isConnected(p_57976_, NORTH_WALL);
        boolean flag1 = WallBlock.isConnected(p_57976_, EAST_WALL);
        boolean flag2 = WallBlock.isConnected(p_57976_, SOUTH_WALL);
        boolean flag3 = WallBlock.isConnected(p_57976_, WEST_WALL);
        return this.updateShape(p_57975_, p_57976_, p_57977_, p_57978_, flag, flag1, flag2, flag3);
    }

    private BlockState sideUpdate(LevelReader p_57989_, BlockPos p_57990_, BlockState p_57991_, BlockPos p_57992_, BlockState p_57993_, Direction p_57994_) {
        Direction direction = p_57994_.getOpposite();
        boolean flag = p_57994_ == Direction.NORTH ? this.connectsTo(p_57993_, p_57993_.isFaceSturdy(p_57989_, p_57992_, direction), direction) : WallBlock.isConnected(p_57991_, NORTH_WALL);
        boolean flag1 = p_57994_ == Direction.EAST ? this.connectsTo(p_57993_, p_57993_.isFaceSturdy(p_57989_, p_57992_, direction), direction) : WallBlock.isConnected(p_57991_, EAST_WALL);
        boolean flag2 = p_57994_ == Direction.SOUTH ? this.connectsTo(p_57993_, p_57993_.isFaceSturdy(p_57989_, p_57992_, direction), direction) : WallBlock.isConnected(p_57991_, SOUTH_WALL);
        boolean flag3 = p_57994_ == Direction.WEST ? this.connectsTo(p_57993_, p_57993_.isFaceSturdy(p_57989_, p_57992_, direction), direction) : WallBlock.isConnected(p_57991_, WEST_WALL);
        BlockPos blockpos = p_57990_.above();
        BlockState blockstate = p_57989_.getBlockState(blockpos);
        return this.updateShape(p_57989_, p_57991_, blockpos, blockstate, flag, flag1, flag2, flag3);
    }

    private BlockState updateShape(LevelReader p_57980_, BlockState p_57981_, BlockPos p_57982_, BlockState p_57983_, boolean p_57984_, boolean p_57985_, boolean p_57986_, boolean p_57987_) {
        VoxelShape voxelshape = p_57983_.getCollisionShape(p_57980_, p_57982_).getFaceShape(Direction.DOWN);
        BlockState blockstate = this.updateSides(p_57981_, p_57984_, p_57985_, p_57986_, p_57987_, voxelshape);
        return (BlockState)blockstate.setValue(UP, this.shouldRaisePost(blockstate, p_57983_, voxelshape));
    }

    private boolean shouldRaisePost(BlockState p_58007_, BlockState p_58008_, VoxelShape p_58009_) {
        boolean flag6;
        boolean flag5;
        boolean flag;
        boolean bl = flag = p_58008_.getBlock() instanceof WallBlock && p_58008_.getValue(UP) != false;
        if (flag) {
            return true;
        }
        WallSide wallside = p_58007_.getValue(NORTH_WALL);
        WallSide wallside1 = p_58007_.getValue(SOUTH_WALL);
        WallSide wallside2 = p_58007_.getValue(EAST_WALL);
        WallSide wallside3 = p_58007_.getValue(WEST_WALL);
        boolean flag1 = wallside1 == WallSide.NONE;
        boolean flag2 = wallside3 == WallSide.NONE;
        boolean flag3 = wallside2 == WallSide.NONE;
        boolean flag4 = wallside == WallSide.NONE;
        boolean bl2 = flag5 = flag4 && flag1 && flag2 && flag3 || flag4 != flag1 || flag2 != flag3;
        if (flag5) {
            return true;
        }
        boolean bl3 = flag6 = wallside == WallSide.TALL && wallside1 == WallSide.TALL || wallside2 == WallSide.TALL && wallside3 == WallSide.TALL;
        if (flag6) {
            return false;
        }
        return p_58008_.is(BlockTags.WALL_POST_OVERRIDE) || WallBlock.isCovered(p_58009_, POST_TEST);
    }

    private BlockState updateSides(BlockState p_58025_, boolean p_58026_, boolean p_58027_, boolean p_58028_, boolean p_58029_, VoxelShape p_58030_) {
        return (BlockState)((BlockState)((BlockState)((BlockState)p_58025_.setValue(NORTH_WALL, this.makeWallState(p_58026_, p_58030_, NORTH_TEST))).setValue(EAST_WALL, this.makeWallState(p_58027_, p_58030_, EAST_TEST))).setValue(SOUTH_WALL, this.makeWallState(p_58028_, p_58030_, SOUTH_TEST))).setValue(WEST_WALL, this.makeWallState(p_58029_, p_58030_, WEST_TEST));
    }

    private WallSide makeWallState(boolean p_58042_, VoxelShape p_58043_, VoxelShape p_58044_) {
        if (p_58042_) {
            return WallBlock.isCovered(p_58043_, p_58044_) ? WallSide.TALL : WallSide.LOW;
        }
        return WallSide.NONE;
    }

    @Override
    public FluidState getFluidState(BlockState pState) {
        return pState.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    @Override
    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return pState.getValue(WATERLOGGED) == false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.a(UP, NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL, WATERLOGGED);
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        switch (pRotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH_WALL, pState.getValue(SOUTH_WALL))).setValue(EAST_WALL, pState.getValue(WEST_WALL))).setValue(SOUTH_WALL, pState.getValue(NORTH_WALL))).setValue(WEST_WALL, pState.getValue(EAST_WALL));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH_WALL, pState.getValue(EAST_WALL))).setValue(EAST_WALL, pState.getValue(SOUTH_WALL))).setValue(SOUTH_WALL, pState.getValue(WEST_WALL))).setValue(WEST_WALL, pState.getValue(NORTH_WALL));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH_WALL, pState.getValue(WEST_WALL))).setValue(EAST_WALL, pState.getValue(NORTH_WALL))).setValue(SOUTH_WALL, pState.getValue(EAST_WALL))).setValue(WEST_WALL, pState.getValue(SOUTH_WALL));
            }
        }
        return pState;
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        switch (pMirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)pState.setValue(NORTH_WALL, pState.getValue(SOUTH_WALL))).setValue(SOUTH_WALL, pState.getValue(NORTH_WALL));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)pState.setValue(EAST_WALL, pState.getValue(WEST_WALL))).setValue(WEST_WALL, pState.getValue(EAST_WALL));
            }
        }
        return super.mirror(pState, pMirror);
    }
}

