/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockMaterialPredicate;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.material.Material;

public class WitherSkullBlock
extends SkullBlock {
    @Nullable
    private static BlockPattern witherPatternFull;
    @Nullable
    private static BlockPattern witherPatternBase;

    protected WitherSkullBlock(BlockBehaviour.Properties p_58254_) {
        super(SkullBlock.Types.WITHER_SKELETON, p_58254_);
    }

    @Override
    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof SkullBlockEntity) {
            WitherSkullBlock.checkSpawn(pLevel, pPos, (SkullBlockEntity)blockentity);
        }
    }

    public static void checkSpawn(Level pLevel, BlockPos pPos, SkullBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide) {
            BlockPattern blockpattern;
            BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch;
            boolean flag;
            BlockState blockstate = pBlockEntity.getBlockState();
            boolean bl = flag = blockstate.is(Blocks.WITHER_SKELETON_SKULL) || blockstate.is(Blocks.WITHER_SKELETON_WALL_SKULL);
            if (flag && pPos.getY() >= pLevel.getMinBuildHeight() && pLevel.getDifficulty() != Difficulty.PEACEFUL && (blockpattern$blockpatternmatch = (blockpattern = WitherSkullBlock.getOrCreateWitherFull()).find(pLevel, pPos)) != null) {
                int i = 0;
                while (i < blockpattern.getWidth()) {
                    int j = 0;
                    while (j < blockpattern.getHeight()) {
                        BlockInWorld blockinworld = blockpattern$blockpatternmatch.getBlock(i, j, 0);
                        pLevel.setBlock(blockinworld.getPos(), Blocks.AIR.defaultBlockState(), 2);
                        pLevel.levelEvent(2001, blockinworld.getPos(), Block.getId(blockinworld.getState()));
                        ++j;
                    }
                    ++i;
                }
                WitherBoss witherboss = EntityType.WITHER.create(pLevel);
                BlockPos blockpos = blockpattern$blockpatternmatch.getBlock(1, 2, 0).getPos();
                witherboss.moveTo((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.55, (double)blockpos.getZ() + 0.5, blockpattern$blockpatternmatch.getForwards().getAxis() == Direction.Axis.X ? 0.0f : 90.0f, 0.0f);
                witherboss.yBodyRot = blockpattern$blockpatternmatch.getForwards().getAxis() == Direction.Axis.X ? 0.0f : 90.0f;
                witherboss.makeInvulnerable();
                for (ServerPlayer serverplayer : pLevel.getEntitiesOfClass(ServerPlayer.class, witherboss.getBoundingBox().inflate(50.0))) {
                    CriteriaTriggers.SUMMONED_ENTITY.trigger(serverplayer, witherboss);
                }
                pLevel.addFreshEntity(witherboss);
                int k = 0;
                while (k < blockpattern.getWidth()) {
                    int l = 0;
                    while (l < blockpattern.getHeight()) {
                        pLevel.blockUpdated(blockpattern$blockpatternmatch.getBlock(k, l, 0).getPos(), Blocks.AIR);
                        ++l;
                    }
                    ++k;
                }
            }
        }
    }

    public static boolean canSpawnMob(Level pLevel, BlockPos pPos, ItemStack pStack) {
        if (pStack.is(Items.WITHER_SKELETON_SKULL) && pPos.getY() >= pLevel.getMinBuildHeight() + 2 && pLevel.getDifficulty() != Difficulty.PEACEFUL && !pLevel.isClientSide) {
            return WitherSkullBlock.getOrCreateWitherBase().find(pLevel, pPos) != null;
        }
        return false;
    }

    private static BlockPattern getOrCreateWitherFull() {
        if (witherPatternFull == null) {
            witherPatternFull = BlockPatternBuilder.start().a("^^^", "###", "~#~").where('#', p_58272_ -> p_58272_.getState().is(BlockTags.WITHER_SUMMON_BASE_BLOCKS)).where('^', BlockInWorld.hasState(BlockStatePredicate.forBlock(Blocks.WITHER_SKELETON_SKULL).or(BlockStatePredicate.forBlock(Blocks.WITHER_SKELETON_WALL_SKULL)))).where('~', BlockInWorld.hasState(BlockMaterialPredicate.forMaterial(Material.AIR))).build();
        }
        return witherPatternFull;
    }

    private static BlockPattern getOrCreateWitherBase() {
        if (witherPatternBase == null) {
            witherPatternBase = BlockPatternBuilder.start().a("   ", "###", "~#~").where('#', p_58266_ -> p_58266_.getState().is(BlockTags.WITHER_SUMMON_BASE_BLOCKS)).where('~', BlockInWorld.hasState(BlockMaterialPredicate.forMaterial(Material.AIR))).build();
        }
        return witherPatternBase;
    }
}

