/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    public static final int DATA_LIT_TIME = 0;
    private static final int[] SLOTS_FOR_UP = new int[1];
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    protected NonNullList<ItemStack> items = NonNullList.withSize(3, ItemStack.EMPTY);
    int litTime;
    int litDuration;
    int cookingProgress;
    int cookingTotalTime;
    protected final ContainerData dataAccess = new ContainerData(){

        @Override
        public int get(int p_58431_) {
            switch (p_58431_) {
                case 0: {
                    return AbstractFurnaceBlockEntity.this.litTime;
                }
                case 1: {
                    return AbstractFurnaceBlockEntity.this.litDuration;
                }
                case 2: {
                    return AbstractFurnaceBlockEntity.this.cookingProgress;
                }
                case 3: {
                    return AbstractFurnaceBlockEntity.this.cookingTotalTime;
                }
            }
            return 0;
        }

        @Override
        public void set(int p_58433_, int p_58434_) {
            switch (p_58433_) {
                case 0: {
                    AbstractFurnaceBlockEntity.this.litTime = p_58434_;
                    break;
                }
                case 1: {
                    AbstractFurnaceBlockEntity.this.litDuration = p_58434_;
                    break;
                }
                case 2: {
                    AbstractFurnaceBlockEntity.this.cookingProgress = p_58434_;
                    break;
                }
                case 3: {
                    AbstractFurnaceBlockEntity.this.cookingTotalTime = p_58434_;
                }
            }
        }

        @Override
        public int getCount() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeType<? extends AbstractCookingRecipe> recipeType;

    protected AbstractFurnaceBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState, RecipeType<? extends AbstractCookingRecipe> pRecipeType) {
        super(pType, pWorldPosition, pBlockState);
        this.recipeType = pRecipeType;
    }

    public static Map<Item, Integer> getFuel() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Items.LAVA_BUCKET, 20000);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.COAL_BLOCK, 16000);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Items.BLAZE_ROD, 2400);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Items.COAL, 1600);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Items.CHARCOAL, 1600);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, ItemTags.LOGS, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, ItemTags.PLANKS, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, ItemTags.WOODEN_STAIRS, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, ItemTags.WOODEN_SLABS, 150);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, ItemTags.WOODEN_TRAPDOORS, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, ItemTags.WOODEN_PRESSURE_PLATES, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.OAK_FENCE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.BIRCH_FENCE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.SPRUCE_FENCE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.JUNGLE_FENCE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.DARK_OAK_FENCE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.ACACIA_FENCE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.OAK_FENCE_GATE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.BIRCH_FENCE_GATE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.SPRUCE_FENCE_GATE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.JUNGLE_FENCE_GATE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.DARK_OAK_FENCE_GATE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.ACACIA_FENCE_GATE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.NOTE_BLOCK, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.BOOKSHELF, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.LECTERN, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.JUKEBOX, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.CHEST, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.TRAPPED_CHEST, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.CRAFTING_TABLE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.DAYLIGHT_DETECTOR, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, ItemTags.BANNERS, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Items.BOW, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Items.FISHING_ROD, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.LADDER, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, ItemTags.SIGNS, 200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Items.WOODEN_SHOVEL, 200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Items.WOODEN_SWORD, 200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Items.WOODEN_HOE, 200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Items.WOODEN_AXE, 200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Items.WOODEN_PICKAXE, 200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, ItemTags.WOODEN_DOORS, 200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, ItemTags.BOATS, 1200);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, ItemTags.WOOL, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, ItemTags.WOODEN_BUTTONS, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Items.STICK, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, ItemTags.SAPLINGS, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Items.BOWL, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, ItemTags.CARPETS, 67);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.DRIED_KELP_BLOCK, 4001);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Items.CROSSBOW, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.BAMBOO, 50);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.DEAD_BUSH, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.SCAFFOLDING, 400);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.LOOM, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.BARREL, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.CARTOGRAPHY_TABLE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.FLETCHING_TABLE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.SMITHING_TABLE, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.COMPOSTER, 300);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.AZALEA, 100);
        AbstractFurnaceBlockEntity.add((Map<Item, Integer>)map, Blocks.FLOWERING_AZALEA, 100);
        return map;
    }

    private static boolean isNeverAFurnaceFuel(Item pItem) {
        return pItem.builtInRegistryHolder().is(ItemTags.NON_FLAMMABLE_WOOD);
    }

    private static void add(Map<Item, Integer> pMap, TagKey<Item> pItemTag, int pBurnTime) {
        for (Holder<Item> holder : Registry.ITEM.getTagOrEmpty(pItemTag)) {
            if (AbstractFurnaceBlockEntity.isNeverAFurnaceFuel(holder.value())) continue;
            pMap.put(holder.value(), pBurnTime);
        }
    }

    private static void add(Map<Item, Integer> pMap, ItemLike pItemTag, int pBurnTime) {
        Item item = pItemTag.asItem();
        if (AbstractFurnaceBlockEntity.isNeverAFurnaceFuel(item)) {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                throw Util.pauseInIde(new IllegalStateException("A developer tried to explicitly make fire resistant item " + item.getName(null).getString() + " a furnace fuel. That will not work!"));
            }
        } else {
            pMap.put(item, pBurnTime);
        }
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    @Override
    public void load(CompoundTag pTag) {
        super.load(pTag);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        ContainerHelper.loadAllItems(pTag, this.items);
        this.litTime = pTag.getShort("BurnTime");
        this.cookingProgress = pTag.getShort("CookTime");
        this.cookingTotalTime = pTag.getShort("CookTimeTotal");
        this.litDuration = this.getBurnDuration(this.items.get(1));
        CompoundTag compoundtag = pTag.getCompound("RecipesUsed");
        for (String s : compoundtag.getAllKeys()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundtag.getInt(s));
        }
    }

    @Override
    protected void saveAdditional(CompoundTag p_187452_) {
        super.saveAdditional(p_187452_);
        p_187452_.putShort("BurnTime", (short)this.litTime);
        p_187452_.putShort("CookTime", (short)this.cookingProgress);
        p_187452_.putShort("CookTimeTotal", (short)this.cookingTotalTime);
        ContainerHelper.saveAllItems(p_187452_, this.items);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((p_187449_, p_187450_) -> compoundtag.putInt(p_187449_.toString(), (int)p_187450_));
        p_187452_.put("RecipesUsed", compoundtag);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, AbstractFurnaceBlockEntity pBlockEntity) {
        boolean flag = pBlockEntity.isLit();
        boolean flag1 = false;
        if (pBlockEntity.isLit()) {
            --pBlockEntity.litTime;
        }
        ItemStack itemstack = pBlockEntity.items.get(1);
        if (pBlockEntity.isLit() || !itemstack.isEmpty() && !pBlockEntity.items.get(0).isEmpty()) {
            Recipe recipe = pLevel.getRecipeManager().getRecipeFor(pBlockEntity.recipeType, pBlockEntity, pLevel).orElse(null);
            int i = pBlockEntity.getMaxStackSize();
            if (!pBlockEntity.isLit() && AbstractFurnaceBlockEntity.canBurn(recipe, pBlockEntity.items, i)) {
                pBlockEntity.litDuration = pBlockEntity.litTime = pBlockEntity.getBurnDuration(itemstack);
                if (pBlockEntity.isLit()) {
                    flag1 = true;
                    if (!itemstack.isEmpty()) {
                        Item item = itemstack.getItem();
                        itemstack.shrink(1);
                        if (itemstack.isEmpty()) {
                            Item item1 = item.getCraftingRemainingItem();
                            pBlockEntity.items.set(1, item1 == null ? ItemStack.EMPTY : new ItemStack(item1));
                        }
                    }
                }
            }
            if (pBlockEntity.isLit() && AbstractFurnaceBlockEntity.canBurn(recipe, pBlockEntity.items, i)) {
                ++pBlockEntity.cookingProgress;
                if (pBlockEntity.cookingProgress == pBlockEntity.cookingTotalTime) {
                    pBlockEntity.cookingProgress = 0;
                    pBlockEntity.cookingTotalTime = AbstractFurnaceBlockEntity.getTotalCookTime(pLevel, pBlockEntity.recipeType, pBlockEntity);
                    if (AbstractFurnaceBlockEntity.burn(recipe, pBlockEntity.items, i)) {
                        pBlockEntity.setRecipeUsed(recipe);
                    }
                    flag1 = true;
                }
            } else {
                pBlockEntity.cookingProgress = 0;
            }
        } else if (!pBlockEntity.isLit() && pBlockEntity.cookingProgress > 0) {
            pBlockEntity.cookingProgress = Mth.clamp(pBlockEntity.cookingProgress - 2, 0, pBlockEntity.cookingTotalTime);
        }
        if (flag != pBlockEntity.isLit()) {
            flag1 = true;
            pState = (BlockState)pState.setValue(AbstractFurnaceBlock.LIT, pBlockEntity.isLit());
            pLevel.setBlock(pPos, pState, 3);
        }
        if (flag1) {
            AbstractFurnaceBlockEntity.setChanged(pLevel, pPos, pState);
        }
    }

    private static boolean canBurn(@Nullable Recipe<?> p_155006_, NonNullList<ItemStack> p_155007_, int p_155008_) {
        if (!p_155007_.get(0).isEmpty() && p_155006_ != null) {
            ItemStack itemstack = p_155006_.getResultItem();
            if (itemstack.isEmpty()) {
                return false;
            }
            ItemStack itemstack1 = p_155007_.get(2);
            if (itemstack1.isEmpty()) {
                return true;
            }
            if (!itemstack1.sameItem(itemstack)) {
                return false;
            }
            if (itemstack1.getCount() < p_155008_ && itemstack1.getCount() < itemstack1.getMaxStackSize()) {
                return true;
            }
            return itemstack1.getCount() < itemstack.getMaxStackSize();
        }
        return false;
    }

    private static boolean burn(@Nullable Recipe<?> p_155027_, NonNullList<ItemStack> p_155028_, int p_155029_) {
        if (p_155027_ != null && AbstractFurnaceBlockEntity.canBurn(p_155027_, p_155028_, p_155029_)) {
            ItemStack itemstack = p_155028_.get(0);
            ItemStack itemstack1 = p_155027_.getResultItem();
            ItemStack itemstack2 = p_155028_.get(2);
            if (itemstack2.isEmpty()) {
                p_155028_.set(2, itemstack1.copy());
            } else if (itemstack2.is(itemstack1.getItem())) {
                itemstack2.grow(1);
            }
            if (itemstack.is(Blocks.WET_SPONGE.asItem()) && !p_155028_.get(1).isEmpty() && p_155028_.get(1).is(Items.BUCKET)) {
                p_155028_.set(1, new ItemStack(Items.WATER_BUCKET));
            }
            itemstack.shrink(1);
            return true;
        }
        return false;
    }

    protected int getBurnDuration(ItemStack pFuel) {
        if (pFuel.isEmpty()) {
            return 0;
        }
        Item item = pFuel.getItem();
        return AbstractFurnaceBlockEntity.getFuel().getOrDefault(item, 0);
    }

    private static int getTotalCookTime(Level pLevel, RecipeType<? extends AbstractCookingRecipe> pRecipeType, Container pContainer) {
        return pLevel.getRecipeManager().getRecipeFor(pRecipeType, pContainer, pLevel).map(AbstractCookingRecipe::getCookingTime).orElse(200);
    }

    public static boolean isFuel(ItemStack pStack) {
        return AbstractFurnaceBlockEntity.getFuel().containsKey(pStack.getItem());
    }

    @Override
    public int[] getSlotsForFace(Direction pSide) {
        if (pSide == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return pSide == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    @Override
    public boolean canPlaceItemThroughFace(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return this.canPlaceItem(pIndex, pItemStack);
    }

    @Override
    public boolean canTakeItemThroughFace(int pIndex, ItemStack pStack, Direction pDirection) {
        if (pDirection == Direction.DOWN && pIndex == 1) {
            return pStack.is(Items.WATER_BUCKET) || pStack.is(Items.BUCKET);
        }
        return true;
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int pIndex) {
        return this.items.get(pIndex);
    }

    @Override
    public ItemStack removeItem(int pIndex, int pCount) {
        return ContainerHelper.removeItem(this.items, pIndex, pCount);
    }

    @Override
    public ItemStack removeItemNoUpdate(int pIndex) {
        return ContainerHelper.takeItem(this.items, pIndex);
    }

    @Override
    public void setItem(int pIndex, ItemStack pStack) {
        ItemStack itemstack = this.items.get(pIndex);
        boolean flag = !pStack.isEmpty() && pStack.sameItem(itemstack) && ItemStack.tagMatches(pStack, itemstack);
        this.items.set(pIndex, pStack);
        if (pStack.getCount() > this.getMaxStackSize()) {
            pStack.setCount(this.getMaxStackSize());
        }
        if (pIndex == 0 && !flag) {
            this.cookingTotalTime = AbstractFurnaceBlockEntity.getTotalCookTime(this.level, this.recipeType, this);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    @Override
    public boolean stillValid(Player pPlayer) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return pPlayer.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @Override
    public boolean canPlaceItem(int pIndex, ItemStack pStack) {
        if (pIndex == 2) {
            return false;
        }
        if (pIndex != 1) {
            return true;
        }
        ItemStack itemstack = this.items.get(1);
        return AbstractFurnaceBlockEntity.isFuel(pStack) || pStack.is(Items.BUCKET) && !itemstack.is(Items.BUCKET);
    }

    @Override
    public void clearContent() {
        this.items.clear();
    }

    @Override
    public void setRecipeUsed(@Nullable Recipe<?> pRecipe) {
        if (pRecipe != null) {
            ResourceLocation resourcelocation = pRecipe.getId();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Override
    @Nullable
    public Recipe<?> getRecipeUsed() {
        return null;
    }

    @Override
    public void awardUsedRecipes(Player pPlayer) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer pPlayer) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(pPlayer.getLevel(), pPlayer.position());
        pPlayer.awardRecipes(list);
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel p_154996_, Vec3 p_154997_) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            p_154996_.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(p_155023_ -> {
                list.add(p_155023_);
                AbstractFurnaceBlockEntity.createExperience(p_154996_, p_154997_, entry.getIntValue(), ((AbstractCookingRecipe)p_155023_).getExperience());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel p_154999_, Vec3 p_155000_, int p_155001_, float p_155002_) {
        int i = Mth.floor((float)p_155001_ * p_155002_);
        float f = Mth.frac((float)p_155001_ * p_155002_);
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.award(p_154999_, p_155000_, i);
    }

    @Override
    public void fillStackedContents(StackedContents pHelper) {
        for (ItemStack itemstack : this.items) {
            pHelper.accountStack(itemstack);
        }
    }
}

