/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class BeaconBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int MAX_LEVELS = 4;
    public static final MobEffect[][] BEACON_EFFECTS = new MobEffect[][]{{MobEffects.MOVEMENT_SPEED, MobEffects.DIG_SPEED}, {MobEffects.DAMAGE_RESISTANCE, MobEffects.JUMP}, {MobEffects.DAMAGE_BOOST}, {MobEffects.REGENERATION}};
    private static final Set<MobEffect> VALID_EFFECTS = Arrays.stream(BEACON_EFFECTS).flatMap(Arrays::stream).collect(Collectors.toSet());
    public static final int DATA_LEVELS = 0;
    public static final int DATA_PRIMARY = 1;
    public static final int DATA_SECONDARY = 2;
    public static final int NUM_DATA_VALUES = 3;
    private static final int BLOCKS_CHECK_PER_TICK = 10;
    List<BeaconBeamSection> beamSections = Lists.newArrayList();
    private List<BeaconBeamSection> checkingBeamSections = Lists.newArrayList();
    int levels;
    private int lastCheckY;
    @Nullable
    MobEffect primaryPower;
    @Nullable
    MobEffect secondaryPower;
    @Nullable
    private Component name;
    private LockCode lockKey = LockCode.NO_LOCK;
    private final ContainerData dataAccess = new ContainerData(){

        @Override
        public int get(int p_58711_) {
            switch (p_58711_) {
                case 0: {
                    return BeaconBlockEntity.this.levels;
                }
                case 1: {
                    return MobEffect.getId(BeaconBlockEntity.this.primaryPower);
                }
                case 2: {
                    return MobEffect.getId(BeaconBlockEntity.this.secondaryPower);
                }
            }
            return 0;
        }

        @Override
        public void set(int p_58713_, int p_58714_) {
            switch (p_58713_) {
                case 0: {
                    BeaconBlockEntity.this.levels = p_58714_;
                    break;
                }
                case 1: {
                    if (!BeaconBlockEntity.this.level.isClientSide && !BeaconBlockEntity.this.beamSections.isEmpty()) {
                        BeaconBlockEntity.playSound(BeaconBlockEntity.this.level, BeaconBlockEntity.this.worldPosition, SoundEvents.BEACON_POWER_SELECT);
                    }
                    BeaconBlockEntity.this.primaryPower = BeaconBlockEntity.getValidEffectById(p_58714_);
                    break;
                }
                case 2: {
                    BeaconBlockEntity.this.secondaryPower = BeaconBlockEntity.getValidEffectById(p_58714_);
                }
            }
        }

        @Override
        public int getCount() {
            return 3;
        }
    };

    public BeaconBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(BlockEntityType.BEACON, pWorldPosition, pBlockState);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, BeaconBlockEntity pBlockEntity) {
        BlockPos blockpos;
        int i = pPos.getX();
        int j = pPos.getY();
        int k = pPos.getZ();
        if (pBlockEntity.lastCheckY < j) {
            blockpos = pPos;
            pBlockEntity.checkingBeamSections = Lists.newArrayList();
            pBlockEntity.lastCheckY = pPos.getY() - 1;
        } else {
            blockpos = new BlockPos(i, pBlockEntity.lastCheckY + 1, k);
        }
        BeaconBeamSection beaconblockentity$beaconbeamsection = pBlockEntity.checkingBeamSections.isEmpty() ? null : pBlockEntity.checkingBeamSections.get(pBlockEntity.checkingBeamSections.size() - 1);
        int l = pLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i, k);
        int i1 = 0;
        while (i1 < 10 && blockpos.getY() <= l) {
            BlockState blockstate = pLevel.getBlockState(blockpos);
            Block block = blockstate.getBlock();
            if (block instanceof BeaconBeamBlock) {
                float[] afloat = ((BeaconBeamBlock)((Object)block)).getColor().getTextureDiffuseColors();
                if (pBlockEntity.checkingBeamSections.size() <= 1) {
                    beaconblockentity$beaconbeamsection = new BeaconBeamSection(afloat);
                    pBlockEntity.checkingBeamSections.add(beaconblockentity$beaconbeamsection);
                } else if (beaconblockentity$beaconbeamsection != null) {
                    if (Arrays.equals(afloat, beaconblockentity$beaconbeamsection.color)) {
                        beaconblockentity$beaconbeamsection.increaseHeight();
                    } else {
                        beaconblockentity$beaconbeamsection = new BeaconBeamSection(new float[]{(beaconblockentity$beaconbeamsection.color[0] + afloat[0]) / 2.0f, (beaconblockentity$beaconbeamsection.color[1] + afloat[1]) / 2.0f, (beaconblockentity$beaconbeamsection.color[2] + afloat[2]) / 2.0f});
                        pBlockEntity.checkingBeamSections.add(beaconblockentity$beaconbeamsection);
                    }
                }
            } else {
                if (beaconblockentity$beaconbeamsection == null || blockstate.getLightBlock(pLevel, blockpos) >= 15 && !blockstate.is(Blocks.BEDROCK)) {
                    pBlockEntity.checkingBeamSections.clear();
                    pBlockEntity.lastCheckY = l;
                    break;
                }
                beaconblockentity$beaconbeamsection.increaseHeight();
            }
            blockpos = blockpos.above();
            ++pBlockEntity.lastCheckY;
            ++i1;
        }
        int j1 = pBlockEntity.levels;
        if (pLevel.getGameTime() % 80L == 0L) {
            if (!pBlockEntity.beamSections.isEmpty()) {
                pBlockEntity.levels = BeaconBlockEntity.updateBase(pLevel, i, j, k);
            }
            if (pBlockEntity.levels > 0 && !pBlockEntity.beamSections.isEmpty()) {
                BeaconBlockEntity.applyEffects(pLevel, pPos, pBlockEntity.levels, pBlockEntity.primaryPower, pBlockEntity.secondaryPower);
                BeaconBlockEntity.playSound(pLevel, pPos, SoundEvents.BEACON_AMBIENT);
            }
        }
        if (pBlockEntity.lastCheckY >= l) {
            pBlockEntity.lastCheckY = pLevel.getMinBuildHeight() - 1;
            boolean flag = j1 > 0;
            pBlockEntity.beamSections = pBlockEntity.checkingBeamSections;
            if (!pLevel.isClientSide) {
                boolean flag1;
                boolean bl = flag1 = pBlockEntity.levels > 0;
                if (!flag && flag1) {
                    BeaconBlockEntity.playSound(pLevel, pPos, SoundEvents.BEACON_ACTIVATE);
                    for (ServerPlayer serverplayer : pLevel.getEntitiesOfClass(ServerPlayer.class, new AABB(i, j, k, i, j - 4, k).inflate(10.0, 5.0, 10.0))) {
                        CriteriaTriggers.CONSTRUCT_BEACON.trigger(serverplayer, pBlockEntity.levels);
                    }
                } else if (flag && !flag1) {
                    BeaconBlockEntity.playSound(pLevel, pPos, SoundEvents.BEACON_DEACTIVATE);
                }
            }
        }
    }

    private static int updateBase(Level p_155093_, int p_155094_, int p_155095_, int p_155096_) {
        int i = 0;
        int j = 1;
        while (j <= 4) {
            int k = p_155095_ - j;
            if (k < p_155093_.getMinBuildHeight()) break;
            boolean flag = true;
            int l = p_155094_ - j;
            while (l <= p_155094_ + j && flag) {
                int i1 = p_155096_ - j;
                while (i1 <= p_155096_ + j) {
                    if (!p_155093_.getBlockState(new BlockPos(l, k, i1)).is(BlockTags.BEACON_BASE_BLOCKS)) {
                        flag = false;
                        break;
                    }
                    ++i1;
                }
                ++l;
            }
            if (!flag) break;
            i = j++;
        }
        return i;
    }

    @Override
    public void setRemoved() {
        BeaconBlockEntity.playSound(this.level, this.worldPosition, SoundEvents.BEACON_DEACTIVATE);
        super.setRemoved();
    }

    private static void applyEffects(Level p_155098_, BlockPos p_155099_, int p_155100_, @Nullable MobEffect p_155101_, @Nullable MobEffect p_155102_) {
        if (!p_155098_.isClientSide && p_155101_ != null) {
            double d0 = p_155100_ * 10 + 10;
            int i = 0;
            if (p_155100_ >= 4 && p_155101_ == p_155102_) {
                i = 1;
            }
            int j = (9 + p_155100_ * 2) * 20;
            AABB aabb = new AABB(p_155099_).inflate(d0).expandTowards(0.0, p_155098_.getHeight(), 0.0);
            List<Player> list = p_155098_.getEntitiesOfClass(Player.class, aabb);
            for (Player player : list) {
                player.addEffect(new MobEffectInstance(p_155101_, j, i, true, true));
            }
            if (p_155100_ >= 4 && p_155101_ != p_155102_ && p_155102_ != null) {
                for (Player player1 : list) {
                    player1.addEffect(new MobEffectInstance(p_155102_, j, 0, true, true));
                }
            }
        }
    }

    public static void playSound(Level pLevel, BlockPos pPos, SoundEvent pSound) {
        pLevel.playSound(null, pPos, pSound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public List<BeaconBeamSection> getBeamSections() {
        return this.levels == 0 ? ImmutableList.of() : this.beamSections;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    @Nullable
    static MobEffect getValidEffectById(int pEffectId) {
        MobEffect mobeffect = MobEffect.byId(pEffectId);
        return VALID_EFFECTS.contains(mobeffect) ? mobeffect : null;
    }

    @Override
    public void load(CompoundTag pTag) {
        super.load(pTag);
        this.primaryPower = BeaconBlockEntity.getValidEffectById(pTag.getInt("Primary"));
        this.secondaryPower = BeaconBlockEntity.getValidEffectById(pTag.getInt("Secondary"));
        if (pTag.contains("CustomName", 8)) {
            this.name = Component.Serializer.fromJson(pTag.getString("CustomName"));
        }
        this.lockKey = LockCode.fromTag(pTag);
    }

    @Override
    protected void saveAdditional(CompoundTag p_187463_) {
        super.saveAdditional(p_187463_);
        p_187463_.putInt("Primary", MobEffect.getId(this.primaryPower));
        p_187463_.putInt("Secondary", MobEffect.getId(this.secondaryPower));
        p_187463_.putInt("Levels", this.levels);
        if (this.name != null) {
            p_187463_.putString("CustomName", Component.Serializer.toJson(this.name));
        }
        this.lockKey.addToTag(p_187463_);
    }

    public void setCustomName(@Nullable Component pName) {
        this.name = pName;
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return BaseContainerBlockEntity.canUnlock(pPlayer, this.lockKey, this.getDisplayName()) ? new BeaconMenu(pContainerId, pInventory, this.dataAccess, ContainerLevelAccess.create(this.level, this.getBlockPos())) : null;
    }

    @Override
    public Component getDisplayName() {
        return this.name != null ? this.name : new TranslatableComponent("container.beacon");
    }

    @Override
    public void setLevel(Level pLevel) {
        super.setLevel(pLevel);
        this.lastCheckY = pLevel.getMinBuildHeight() - 1;
    }

    public static class BeaconBeamSection {
        final float[] color;
        private int height;

        public BeaconBeamSection(float[] pColor) {
            this.color = pColor;
            this.height = 1;
        }

        protected void increaseHeight() {
            ++this.height;
        }

        public float[] getColor() {
            return this.color;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

