/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ConduitBlockEntity
extends BlockEntity {
    private static final int BLOCK_REFRESH_RATE = 2;
    private static final int EFFECT_DURATION = 13;
    private static final float ROTATION_SPEED = -0.0375f;
    private static final int MIN_ACTIVE_SIZE = 16;
    private static final int MIN_KILL_SIZE = 42;
    private static final int KILL_RANGE = 8;
    private static final Block[] VALID_BLOCKS = new Block[]{Blocks.PRISMARINE, Blocks.PRISMARINE_BRICKS, Blocks.SEA_LANTERN, Blocks.DARK_PRISMARINE};
    public int tickCount;
    private float activeRotation;
    private boolean isActive;
    private boolean isHunting;
    private final List<BlockPos> effectBlocks = Lists.newArrayList();
    @Nullable
    private LivingEntity destroyTarget;
    @Nullable
    private UUID destroyTargetUUID;
    private long nextAmbientSoundActivation;

    public ConduitBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(BlockEntityType.CONDUIT, pWorldPosition, pBlockState);
    }

    @Override
    public void load(CompoundTag pTag) {
        super.load(pTag);
        this.destroyTargetUUID = pTag.hasUUID("Target") ? pTag.getUUID("Target") : null;
    }

    @Override
    protected void saveAdditional(CompoundTag p_187495_) {
        super.saveAdditional(p_187495_);
        if (this.destroyTarget != null) {
            p_187495_.putUUID("Target", this.destroyTarget.getUUID());
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public static void clientTick(Level pLevel, BlockPos pPos, BlockState pState, ConduitBlockEntity pBlockEntity) {
        ++pBlockEntity.tickCount;
        long i = pLevel.getGameTime();
        List<BlockPos> list = pBlockEntity.effectBlocks;
        if (i % 40L == 0L) {
            pBlockEntity.isActive = ConduitBlockEntity.updateShape(pLevel, pPos, list);
            ConduitBlockEntity.updateHunting(pBlockEntity, list);
        }
        ConduitBlockEntity.updateClientTarget(pLevel, pPos, pBlockEntity);
        ConduitBlockEntity.animationTick(pLevel, pPos, list, pBlockEntity.destroyTarget, pBlockEntity.tickCount);
        if (pBlockEntity.isActive()) {
            pBlockEntity.activeRotation += 1.0f;
        }
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, ConduitBlockEntity pBlockEntity) {
        ++pBlockEntity.tickCount;
        long i = pLevel.getGameTime();
        List<BlockPos> list = pBlockEntity.effectBlocks;
        if (i % 40L == 0L) {
            boolean flag = ConduitBlockEntity.updateShape(pLevel, pPos, list);
            if (flag != pBlockEntity.isActive) {
                SoundEvent soundevent = flag ? SoundEvents.CONDUIT_ACTIVATE : SoundEvents.CONDUIT_DEACTIVATE;
                pLevel.playSound(null, pPos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            pBlockEntity.isActive = flag;
            ConduitBlockEntity.updateHunting(pBlockEntity, list);
            if (flag) {
                ConduitBlockEntity.applyEffects(pLevel, pPos, list);
                ConduitBlockEntity.updateDestroyTarget(pLevel, pPos, pState, list, pBlockEntity);
            }
        }
        if (pBlockEntity.isActive()) {
            if (i % 80L == 0L) {
                pLevel.playSound(null, pPos, SoundEvents.CONDUIT_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (i > pBlockEntity.nextAmbientSoundActivation) {
                pBlockEntity.nextAmbientSoundActivation = i + 60L + (long)pLevel.getRandom().nextInt(40);
                pLevel.playSound(null, pPos, SoundEvents.CONDUIT_AMBIENT_SHORT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private static void updateHunting(ConduitBlockEntity p_155429_, List<BlockPos> p_155430_) {
        p_155429_.setHunting(p_155430_.size() >= 42);
    }

    private static boolean updateShape(Level p_155415_, BlockPos p_155416_, List<BlockPos> p_155417_) {
        p_155417_.clear();
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                int k = -1;
                while (k <= 1) {
                    BlockPos blockpos = p_155416_.offset(i, j, k);
                    if (!p_155415_.isWaterAt(blockpos)) {
                        return false;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int j1 = -2;
        while (j1 <= 2) {
            int k1 = -2;
            while (k1 <= 2) {
                int l1 = -2;
                while (l1 <= 2) {
                    int i2 = Math.abs(j1);
                    int l = Math.abs(k1);
                    int i1 = Math.abs(l1);
                    if (!(i2 <= 1 && l <= 1 && i1 <= 1 || (j1 != 0 || l != 2 && i1 != 2) && (k1 != 0 || i2 != 2 && i1 != 2) && (l1 != 0 || i2 != 2 && l != 2))) {
                        BlockPos blockpos1 = p_155416_.offset(j1, k1, l1);
                        BlockState blockstate = p_155415_.getBlockState(blockpos1);
                        Block[] blockArray = VALID_BLOCKS;
                        int n = VALID_BLOCKS.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Block block = blockArray[n2];
                            if (blockstate.is(block)) {
                                p_155417_.add(blockpos1);
                            }
                            ++n2;
                        }
                    }
                    ++l1;
                }
                ++k1;
            }
            ++j1;
        }
        return p_155417_.size() >= 16;
    }

    private static void applyEffects(Level p_155444_, BlockPos p_155445_, List<BlockPos> p_155446_) {
        int i1;
        int l;
        int i = p_155446_.size();
        int j = i / 7 * 16;
        int k = p_155445_.getX();
        AABB aabb = new AABB(k, l = p_155445_.getY(), i1 = p_155445_.getZ(), k + 1, l + 1, i1 + 1).inflate(j).expandTowards(0.0, p_155444_.getHeight(), 0.0);
        List<Player> list = p_155444_.getEntitiesOfClass(Player.class, aabb);
        if (!list.isEmpty()) {
            for (Player player : list) {
                if (!p_155445_.closerThan(player.blockPosition(), j) || !player.isInWaterOrRain()) continue;
                player.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, 260, 0, true, true));
            }
        }
    }

    private static void updateDestroyTarget(Level p_155409_, BlockPos p_155410_, BlockState p_155411_, List<BlockPos> p_155412_, ConduitBlockEntity p_155413_) {
        LivingEntity livingentity = p_155413_.destroyTarget;
        int i = p_155412_.size();
        if (i < 42) {
            p_155413_.destroyTarget = null;
        } else if (p_155413_.destroyTarget == null && p_155413_.destroyTargetUUID != null) {
            p_155413_.destroyTarget = ConduitBlockEntity.findDestroyTarget(p_155409_, p_155410_, p_155413_.destroyTargetUUID);
            p_155413_.destroyTargetUUID = null;
        } else if (p_155413_.destroyTarget == null) {
            List<LivingEntity> list = p_155409_.getEntitiesOfClass(LivingEntity.class, ConduitBlockEntity.getDestroyRangeAABB(p_155410_), p_59213_ -> p_59213_ instanceof Enemy && p_59213_.isInWaterOrRain());
            if (!list.isEmpty()) {
                p_155413_.destroyTarget = list.get(p_155409_.random.nextInt(list.size()));
            }
        } else if (!p_155413_.destroyTarget.isAlive() || !p_155410_.closerThan(p_155413_.destroyTarget.blockPosition(), 8.0)) {
            p_155413_.destroyTarget = null;
        }
        if (p_155413_.destroyTarget != null) {
            p_155409_.playSound(null, p_155413_.destroyTarget.getX(), p_155413_.destroyTarget.getY(), p_155413_.destroyTarget.getZ(), SoundEvents.CONDUIT_ATTACK_TARGET, SoundSource.BLOCKS, 1.0f, 1.0f);
            p_155413_.destroyTarget.hurt(DamageSource.MAGIC, 4.0f);
        }
        if (livingentity != p_155413_.destroyTarget) {
            p_155409_.sendBlockUpdated(p_155410_, p_155411_, p_155411_, 2);
        }
    }

    private static void updateClientTarget(Level pLevel, BlockPos pPos, ConduitBlockEntity pBlockEntity) {
        if (pBlockEntity.destroyTargetUUID == null) {
            pBlockEntity.destroyTarget = null;
        } else if (pBlockEntity.destroyTarget == null || !pBlockEntity.destroyTarget.getUUID().equals(pBlockEntity.destroyTargetUUID)) {
            pBlockEntity.destroyTarget = ConduitBlockEntity.findDestroyTarget(pLevel, pPos, pBlockEntity.destroyTargetUUID);
            if (pBlockEntity.destroyTarget == null) {
                pBlockEntity.destroyTargetUUID = null;
            }
        }
    }

    private static AABB getDestroyRangeAABB(BlockPos pPos) {
        int i = pPos.getX();
        int j = pPos.getY();
        int k = pPos.getZ();
        return new AABB(i, j, k, i + 1, j + 1, k + 1).inflate(8.0);
    }

    @Nullable
    private static LivingEntity findDestroyTarget(Level pLevel, BlockPos pPos, UUID pTargetId) {
        List<LivingEntity> list = pLevel.getEntitiesOfClass(LivingEntity.class, ConduitBlockEntity.getDestroyRangeAABB(pPos), p_155435_ -> p_155435_.getUUID().equals(pTargetId));
        return list.size() == 1 ? list.get(0) : null;
    }

    private static void animationTick(Level p_155419_, BlockPos p_155420_, List<BlockPos> p_155421_, @Nullable Entity p_155422_, int p_155423_) {
        Random random = p_155419_.random;
        double d0 = Mth.sin((float)(p_155423_ + 35) * 0.1f) / 2.0f + 0.5f;
        d0 = (d0 * d0 + d0) * (double)0.3f;
        Vec3 vec3 = new Vec3((double)p_155420_.getX() + 0.5, (double)p_155420_.getY() + 1.5 + d0, (double)p_155420_.getZ() + 0.5);
        for (BlockPos blockpos : p_155421_) {
            if (random.nextInt(50) != 0) continue;
            BlockPos blockpos1 = blockpos.subtract(p_155420_);
            float f = -0.5f + random.nextFloat() + (float)blockpos1.getX();
            float f1 = -2.0f + random.nextFloat() + (float)blockpos1.getY();
            float f2 = -0.5f + random.nextFloat() + (float)blockpos1.getZ();
            p_155419_.addParticle(ParticleTypes.NAUTILUS, vec3.x, vec3.y, vec3.z, f, f1, f2);
        }
        if (p_155422_ != null) {
            Vec3 vec31 = new Vec3(p_155422_.getX(), p_155422_.getEyeY(), p_155422_.getZ());
            float f3 = (-0.5f + random.nextFloat()) * (3.0f + p_155422_.getBbWidth());
            float f4 = -1.0f + random.nextFloat() * p_155422_.getBbHeight();
            float f5 = (-0.5f + random.nextFloat()) * (3.0f + p_155422_.getBbWidth());
            Vec3 vec32 = new Vec3(f3, f4, f5);
            p_155419_.addParticle(ParticleTypes.NAUTILUS, vec31.x, vec31.y, vec31.z, vec32.x, vec32.y, vec32.z);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isHunting() {
        return this.isHunting;
    }

    private void setHunting(boolean pIsHunting) {
        this.isHunting = pIsHunting;
    }

    public float getActiveRotation(float p_59198_) {
        return (this.activeRotation + p_59198_) * -0.0375f;
    }
}

