/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EnchantmentTableBlockEntity
extends BlockEntity
implements Nameable {
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    public float tRot;
    private static final Random RANDOM = new Random();
    private Component name;

    public EnchantmentTableBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(BlockEntityType.ENCHANTING_TABLE, pWorldPosition, pBlockState);
    }

    @Override
    protected void saveAdditional(CompoundTag p_187500_) {
        super.saveAdditional(p_187500_);
        if (this.hasCustomName()) {
            p_187500_.putString("CustomName", Component.Serializer.toJson(this.name));
        }
    }

    @Override
    public void load(CompoundTag pTag) {
        super.load(pTag);
        if (pTag.contains("CustomName", 8)) {
            this.name = Component.Serializer.fromJson(pTag.getString("CustomName"));
        }
    }

    public static void bookAnimationTick(Level pLevel, BlockPos pPos, BlockState pState, EnchantmentTableBlockEntity pBlockEntity) {
        pBlockEntity.oOpen = pBlockEntity.open;
        pBlockEntity.oRot = pBlockEntity.rot;
        Player player = pLevel.getNearestPlayer((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, 3.0, false);
        if (player != null) {
            double d0 = player.getX() - ((double)pPos.getX() + 0.5);
            double d1 = player.getZ() - ((double)pPos.getZ() + 0.5);
            pBlockEntity.tRot = (float)Mth.atan2(d1, d0);
            pBlockEntity.open += 0.1f;
            if (pBlockEntity.open < 0.5f || RANDOM.nextInt(40) == 0) {
                float f1 = pBlockEntity.flipT;
                do {
                    pBlockEntity.flipT += (float)(RANDOM.nextInt(4) - RANDOM.nextInt(4));
                } while (f1 == pBlockEntity.flipT);
            }
        } else {
            pBlockEntity.tRot += 0.02f;
            pBlockEntity.open -= 0.1f;
        }
        while (pBlockEntity.rot >= (float)Math.PI) {
            pBlockEntity.rot -= (float)Math.PI * 2;
        }
        while (pBlockEntity.rot < (float)(-Math.PI)) {
            pBlockEntity.rot += (float)Math.PI * 2;
        }
        while (pBlockEntity.tRot >= (float)Math.PI) {
            pBlockEntity.tRot -= (float)Math.PI * 2;
        }
        while (pBlockEntity.tRot < (float)(-Math.PI)) {
            pBlockEntity.tRot += (float)Math.PI * 2;
        }
        float f2 = pBlockEntity.tRot - pBlockEntity.rot;
        while (f2 >= (float)Math.PI) {
            f2 -= (float)Math.PI * 2;
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        pBlockEntity.rot += f2 * 0.4f;
        pBlockEntity.open = Mth.clamp(pBlockEntity.open, 0.0f, 1.0f);
        ++pBlockEntity.time;
        pBlockEntity.oFlip = pBlockEntity.flip;
        float f = (pBlockEntity.flipT - pBlockEntity.flip) * 0.4f;
        float f3 = 0.2f;
        f = Mth.clamp(f, -0.2f, 0.2f);
        pBlockEntity.flipA += (f - pBlockEntity.flipA) * 0.9f;
        pBlockEntity.flip += pBlockEntity.flipA;
    }

    @Override
    public Component getName() {
        return this.name != null ? this.name : new TranslatableComponent("container.enchant");
    }

    public void setCustomName(@Nullable Component pName) {
        this.name = pName;
    }

    @Override
    @Nullable
    public Component getCustomName() {
        return this.name;
    }
}

